/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.DataRate;
import org.eclipse.app4mc.amalthea.model.DataRateUnit;
import org.eclipse.app4mc.amalthea.model.DataSize;
import org.eclipse.app4mc.amalthea.model.DataSizeUnit;
import org.eclipse.app4mc.amalthea.model.DiscreteValueBoundaries;
import org.eclipse.app4mc.amalthea.model.DiscreteValueConstant;
import org.eclipse.app4mc.amalthea.model.DiscreteValueGaussDistribution;
import org.eclipse.app4mc.amalthea.model.DiscreteValueWeibullEstimatorsDistribution;
import org.eclipse.app4mc.amalthea.model.ExecutionNeed;
import org.eclipse.app4mc.amalthea.model.Frequency;
import org.eclipse.app4mc.amalthea.model.FrequencyUnit;
import org.eclipse.app4mc.amalthea.model.HwFeature;
import org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.TypeDefinition;
import org.eclipse.app4mc.amalthea.model.TypeRef;
import org.eclipse.app4mc.amalthea.model.Voltage;
import org.eclipse.app4mc.amalthea.model.VoltageUnit;

public class FactoryUtil {
    public static DataSize createDataSize() {
        DataSize size = AmaltheaFactory.eINSTANCE.createDataSize();
        size.setValue(BigInteger.ZERO);
        size.setUnit(DataSizeUnit.BIT);
        return size;
    }

    public static DataSize createDataSize(long value, DataSizeUnit unit) {
        DataSize size = AmaltheaFactory.eINSTANCE.createDataSize();
        size.setValue(BigInteger.valueOf(value));
        size.setUnit(unit);
        return size;
    }

    public static DataRate createDataRate() {
        DataRate rate = AmaltheaFactory.eINSTANCE.createDataRate();
        rate.setValue(BigInteger.ZERO);
        rate.setUnit(DataRateUnit.BIT_PER_SECOND);
        return rate;
    }

    public static DataRate createDataRate(long value, DataRateUnit unit) {
        DataRate rate = AmaltheaFactory.eINSTANCE.createDataRate();
        rate.setValue(BigInteger.valueOf(value));
        rate.setUnit(unit);
        return rate;
    }

    public static Frequency createFrequency() {
        Frequency frequency = AmaltheaFactory.eINSTANCE.createFrequency();
        frequency.setUnit(FrequencyUnit.HZ);
        return frequency;
    }

    public static Frequency createFrequency(double value, FrequencyUnit unit) {
        Frequency frequency = AmaltheaFactory.eINSTANCE.createFrequency();
        frequency.setValue(value);
        frequency.setUnit(unit);
        return frequency;
    }

    public static Voltage createVoltage() {
        Voltage voltage = AmaltheaFactory.eINSTANCE.createVoltage();
        voltage.setUnit(VoltageUnit.UV);
        return voltage;
    }

    public static Voltage createVoltage(double value, VoltageUnit unit) {
        Voltage voltage = AmaltheaFactory.eINSTANCE.createVoltage();
        voltage.setValue(value);
        voltage.setUnit(unit);
        return voltage;
    }

    public static Time createTime() {
        Time time = AmaltheaFactory.eINSTANCE.createTime();
        time.setValue(BigInteger.ZERO);
        time.setUnit(TimeUnit.PS);
        return time;
    }

    public static Time createTime(Time inputTime) {
        Time time = AmaltheaFactory.eINSTANCE.createTime();
        time.setValue(inputTime.getValue());
        time.setUnit(inputTime.getUnit());
        return time;
    }

    public static Time createTime(long value, TimeUnit unit) {
        Time time = AmaltheaFactory.eINSTANCE.createTime();
        time.setValue(BigInteger.valueOf(value));
        time.setUnit(unit);
        return time;
    }

    public static Time createTime(BigInteger value, TimeUnit unit) {
        Time time = AmaltheaFactory.eINSTANCE.createTime();
        time.setValue(value);
        time.setUnit(unit);
        return time;
    }

    private static TimeUnit parseTimeUnit(String input) {
        if (input == null) {
            return TimeUnit.MS;
        }
        String unit = input.trim().toLowerCase();
        if (unit.equals("ps")) {
            return TimeUnit.PS;
        }
        if (unit.equals("ns")) {
            return TimeUnit.NS;
        }
        if (unit.equals("us")) {
            return TimeUnit.US;
        }
        if (unit.equals("ms")) {
            return TimeUnit.MS;
        }
        if (unit.equals("s")) {
            return TimeUnit.S;
        }
        return null;
    }

    public static Time createTime(long value, String unit) {
        return FactoryUtil.createTime(value, FactoryUtil.parseTimeUnit(unit));
    }

    public static Time createTime(BigInteger value, String unit) {
        return FactoryUtil.createTime(value, FactoryUtil.parseTimeUnit(unit));
    }

    public static Time createTime(String timeString) {
        Pattern p = Pattern.compile("(\\d+)\\s?(s|ms|us|ns|ps)");
        Matcher m = p.matcher(timeString);
        if (m.matches()) {
            String value = m.group(1);
            String unit = m.group(2);
            return FactoryUtil.createTime(Long.parseLong(value), FactoryUtil.parseTimeUnit(unit));
        }
        return null;
    }

    public static TypeRef createTypeRef(TypeDefinition typeDefinition) {
        TypeRef refObj = AmaltheaFactory.eINSTANCE.createTypeRef();
        refObj.setTypeDef(typeDefinition);
        return refObj;
    }

    public static DiscreteValueConstant createDiscreteValueConstant(long value) {
        DiscreteValueConstant result = AmaltheaFactory.eINSTANCE.createDiscreteValueConstant();
        result.setValue(value);
        return result;
    }

    public static DiscreteValueBoundaries createDiscreteValueBoundaries(long min, long max) {
        DiscreteValueBoundaries boundaries = AmaltheaFactory.eINSTANCE.createDiscreteValueBoundaries();
        boundaries.setLowerBound(min);
        boundaries.setUpperBound(max);
        return boundaries;
    }

    public static DiscreteValueGaussDistribution createDiscreteValueGaussDistribution(double mean, double sd) {
        DiscreteValueGaussDistribution result = AmaltheaFactory.eINSTANCE.createDiscreteValueGaussDistribution();
        result.setMean(mean);
        result.setSd(sd);
        return result;
    }

    public static DiscreteValueGaussDistribution createDiscreteValueGaussDistribution(double mean, double sd, Long min, Long max) {
        DiscreteValueGaussDistribution result = FactoryUtil.createDiscreteValueGaussDistribution(mean, sd);
        result.setLowerBound(min);
        result.setUpperBound(max);
        return result;
    }

    public static DiscreteValueWeibullEstimatorsDistribution createWeibullDistribution(long min, double avg, long max, double promille) {
        DiscreteValueWeibullEstimatorsDistribution result = AmaltheaFactory.eINSTANCE.createDiscreteValueWeibullEstimatorsDistribution();
        result.setLowerBound(min);
        result.setAverage(avg);
        result.setUpperBound(max);
        result.setPRemainPromille(promille);
        return result;
    }

    public static ExecutionNeed createExecutionNeed(String featureCategory, IDiscreteValueDeviation usages) {
        ExecutionNeed exeNeed = AmaltheaFactory.eINSTANCE.createExecutionNeed();
        exeNeed.getNeeds().put((Object)featureCategory, (Object)usages);
        return exeNeed;
    }

    public static ExecutionNeed createExecutionNeed(HwFeature feature, IDiscreteValueDeviation usages) {
        ExecutionNeed exeNeed = AmaltheaFactory.eINSTANCE.createExecutionNeed();
        exeNeed.getNeeds().put((Object)feature.getContainingCategory().getName(), (Object)usages);
        return exeNeed;
    }

    public static DiscreteValueConstant createLatency(long value) {
        return FactoryUtil.createDiscreteValueConstant(value);
    }
}

