/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.editors.sirius.command;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.app4mc.amalthea.editors.sirius.Activator;
import org.eclipse.app4mc.amalthea.editors.sirius.command.CreateDiagramCommand;
import org.eclipse.app4mc.amalthea.editors.sirius.helper.RepresentationQuery;
import org.eclipse.app4mc.amalthea.editors.sirius.helper.ViewPointSelector;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.helper.SiriusResourceHelper;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.ui.business.internal.commands.ChangeViewpointSelectionCommand;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class OpenGraphicalEditorAction<S extends IReferable> {
    private ILog logger = Activator.getDefault().getLog();
    protected final S sphinxElement;
    protected S element;
    protected Session session;
    protected Class<S> clazz;

    public OpenGraphicalEditorAction(Class<S> clazz, S adaptable) {
        this.sphinxElement = adaptable;
        this.clazz = clazz;
        this.initSession();
    }

    private void initSession() {
        block8: {
            this.session = SessionManager.INSTANCE.getSession(this.sphinxElement);
            if (this.session == null) {
                boolean result = false;
                for (Session sessionTmp : SessionManager.INSTANCE.getSessions()) {
                    result = this.checkSession(sessionTmp);
                }
                if (!result) {
                    IFile iFile = EcorePlatformUtil.getFile(this.sphinxElement);
                    IProject project = iFile.getProject();
                    try {
                        IFile aird = null;
                        IResource[] iResourceArray = project.members();
                        int n = iResourceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            aird = this.searchAirdFile(project);
                            ++n2;
                        }
                        if (aird == null) {
                            this.setupProject(project);
                            aird = this.searchAirdFile(project);
                            Session session = this.setupSession(aird);
                            this.addViewPoint(session);
                            break block8;
                        }
                        this.setupSession(aird);
                    }
                    catch (CoreException e) {
                        this.logger.log((IStatus)new Status(4, "org.eclipse.app4mc.amalthea.sirius", "Error at creating Sirius session!", (Throwable)e));
                    }
                }
            } else {
                this.element = this.sphinxElement;
            }
        }
    }

    private Session setupSession(IFile aird) {
        URI uri = URI.createPlatformResourceURI((String)aird.getFullPath().toString(), (boolean)true);
        Session session = SessionManager.INSTANCE.getSession(uri, (IProgressMonitor)new NullProgressMonitor());
        session.open((IProgressMonitor)new NullProgressMonitor());
        this.session = session;
        this.checkSession(session);
        return session;
    }

    private void addViewPoint(Session session) throws CoreException {
        Set availableViewpoints = ViewpointSelection.getViewpoints((String)"amxmi");
        if (availableViewpoints.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.app4mc.amalthea.sirius", "Could not found viewport for fileextension amxmi"));
        }
        HashSet<Viewpoint> viewpoints = new HashSet<Viewpoint>();
        for (Viewpoint p : availableViewpoints) {
            viewpoints.add(SiriusResourceHelper.getCorrespondingViewpoint((Session)session, (Viewpoint)p));
        }
        ChangeViewpointSelectionCommand command = new ChangeViewpointSelectionCommand(session, (ViewpointSelection.Callback)new ViewpointSelectionCallback(), viewpoints, new HashSet(), (IProgressMonitor)new NullProgressMonitor());
        session.getTransactionalEditingDomain().getCommandStack().execute((Command)command);
    }

    private IFile searchAirdFile(IProject project) throws CoreException {
        IFile result = null;
        if (project != null) {
            IResource[] iResourceArray = project.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource file = iResourceArray[n2];
                if (file instanceof IFile && file.getName().endsWith(".aird")) {
                    result = (IFile)file;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    private void setupProject(IProject project) throws CoreException {
        ModelingProjectManager.INSTANCE.convertToModelingProject(project, (IProgressMonitor)new NullProgressMonitor());
    }

    private boolean checkSession(Session checkSession) {
        for (Resource resource : checkSession.getSemanticResources()) {
            if (!resource.getURI().equals(this.sphinxElement.eResource().getURI())) continue;
            this.session = checkSession;
            SessionManager.INSTANCE.add(this.session);
            SessionUIManager.INSTANCE.getOrCreateUISession(this.session);
            EObject object = resource.getEObject(this.sphinxElement.eResource().getURIFragment(this.sphinxElement));
            if (object instanceof IReferable && object.getClass().getName().equals(this.sphinxElement.getClass().getName())) {
                this.element = (IReferable)object;
            }
            return true;
        }
        return false;
    }

    public void execute() {
        Preconditions.checkNotNull((Object)this.session);
        this.createAndStorePresentation();
        this.openRepresentation(this.getRepresentation());
    }

    private void createAndStorePresentation() {
        if (this.session.getSelectedViewpoints(false).isEmpty()) {
            ViewPointSelector.selectViewPoint(this.session);
        }
        if (this.getRepresentation() == null) {
            this.createRepresentation();
        }
    }

    public void executeWithUIThread() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                OpenGraphicalEditorAction.this.execute();
            }
        });
    }

    private DRepresentation getRepresentation() {
        RepresentationQuery query = new RepresentationQuery((IReferable)this.element, this.session, String.valueOf(this.element.getName()) + " " + this.clazz.getSimpleName());
        return query.execute();
    }

    private void createRepresentation() {
        TransactionalEditingDomain transactionalEditingDomain = this.session.getTransactionalEditingDomain();
        transactionalEditingDomain.getCommandStack().execute(new CreateDiagramCommand<S>(this.session, this.element, this.clazz));
    }

    private void openRepresentation(final DRepresentation representation) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Open Representation", 1);
                    DialectUIManager.INSTANCE.openEditor(OpenGraphicalEditorAction.this.session, representation, monitor);
                }
                finally {
                    monitor.done();
                }
            }
        };
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ProgressMonitorDialog context = new ProgressMonitorDialog(shell);
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, runnable, null);
        }
        catch (InterruptedException | InvocationTargetException e) {
            this.logger.log((IStatus)new Status(4, "org.eclipse.app4mc.amalthea.sirius", "Error at open representation for element ", (Throwable)e));
        }
    }
}

