/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters072.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters072.utils.HelperUtils_071_072;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class RootElementConverter
implements IConverter {
    private final HelperUtils_071_072 helper = HelperUtils_071_072.getInstance();
    private final Logger logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.7.1 to 0.7.2 : Executing \"Root Element Converter\" for model file : " + targetFile.getName()));
        Document document = fileName_documentsMap.get(targetFile);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        String rootTagName = rootElement.getName();
        if (!rootTagName.equals("Amalthea") && (rootTagName.equals("SWModel") || rootTagName.equals("HWModel") || rootTagName.equals("OSModel") || rootTagName.equals("StimuliModel") || rootTagName.equals("ConstraintsModel") || rootTagName.equals("EventModel") || rootTagName.equals("PropertyConstraintsModel") || rootTagName.equals("MappingModel") || rootTagName.equals("ConfigModel") || rootTagName.equals("ComponentsModel"))) {
            Element newRootElement = new Element("Amalthea");
            this.helper.copyAllNameSpaces(rootElement, newRootElement);
            this.updateCurrentRootTagProps(rootElement);
            document.removeContent();
            newRootElement.addContent((Content)rootElement);
            document.addContent((Content)newRootElement);
            fileName_documentsMap.put(targetFile.getCanonicalFile(), document);
        }
    }

    private void updateCurrentRootTagProps(Element rootElement) {
        this.helper.removeDefaultAttribs(rootElement);
        String name = rootElement.getName();
        if (name.equals("SWModel")) {
            rootElement.setName("swModel");
        } else if (name.equals("HWModel")) {
            rootElement.setName("hwModel");
        } else if (name.equals("OSModel")) {
            rootElement.setName("osModel");
        } else if (name.equals("StimuliModel")) {
            rootElement.setName("stimuliModel");
        } else if (name.equals("ConstraintsModel")) {
            rootElement.setName("constraintsModel");
        } else if (name.equals("EventModel")) {
            rootElement.setName("eventModel");
        } else if (name.equals("PropertyConstraintsModel")) {
            rootElement.setName("propertyConstraintsModel");
        } else if (name.equals("MappingModel")) {
            rootElement.setName("mappingModel");
        } else if (name.equals("ConfigModel")) {
            rootElement.setName("configModel");
        } else if (name.equals("ComponentsModel")) {
            rootElement.setName("componentsModel");
        }
    }
}

