/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters080.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters080.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters080.utils.HelperUtils_072_080;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class OSConverter
extends AbstractConverter {
    public OSConverter() {
        this.helper = HelperUtils_072_080.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.7.2 to 0.8.0 : Executing OS converter for model file : " + targetFile.getName()));
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.move_OsDataConsistency_Element(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void move_OsDataConsistency_Element(Element rootElement) {
        List osDataConsistencyElements = this.helper.getXpathResult(rootElement, "./osModel/osDataConsistency", Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        List operatingSystemElements = this.helper.getXpathResult(rootElement, "./osModel/operatingSystems", Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        if (osDataConsistencyElements.size() > 0) {
            Element osDataConsistencyElement = (Element)osDataConsistencyElements.get(0);
            for (Element operatingSystemElement : operatingSystemElements) {
                Element clone_osDataConsistencyElement = osDataConsistencyElement.clone();
                operatingSystemElement.addContent((Content)clone_osDataConsistencyElement);
            }
            this.logger.warn((Object)"OsDataConsistency element is removed from OsModel, and is added (cloned content) to each OperatingSystem element (which is part of corresponding OsModel).");
            osDataConsistencyElement.getParentElement().removeContent((Content)osDataConsistencyElement);
        }
    }
}

