/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.sphinx.ui.editors.search.handlers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.dialogs.IDialogSettings;

public class SearchDialogSettings {
    final String KEY_NAME_PATTERN = "Search_NamePattern";
    final String KEY_CLASS_NAME = "Search_ClassName";
    final String KEY_CASE_SENSITIVE = "Search_CaseSensitive";
    final String KEY_REGEX = "Search_RegularExpression";
    final String KEY_FILE_SCOPE = "Search_FileScope";
    final EClass FILTER_CLASS_DEFAULT = AmaltheaPackage.eINSTANCE.getINamed();
    final Map<String, EClass> FILTER_CLASS_MAP = this.computeSubclassMap();
    boolean m_success = false;
    String m_namePattern = "";
    String m_filterClassName = this.FILTER_CLASS_DEFAULT.getName();
    boolean m_caseSensitive = false;
    boolean m_regularExpression = false;
    boolean m_restrictToFile = false;

    String[] getFilterClassNames() {
        return (String[])this.FILTER_CLASS_MAP.keySet().stream().sorted().toArray(String[]::new);
    }

    Class<INamed> computeFilterClass() {
        EClass eClass = this.FILTER_CLASS_MAP.get(this.m_filterClassName);
        if (eClass == null) {
            return null;
        }
        return eClass.getInstanceClass();
    }

    Pattern computeSearchPattern() {
        if (!this.m_success) {
            return null;
        }
        StringBuilder pattern = new StringBuilder();
        pattern.append(this.m_caseSensitive ? "" : "(?i)");
        if (this.m_regularExpression) {
            pattern.append(this.m_namePattern);
            try {
                return Pattern.compile(pattern.toString());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return null;
            }
        }
        boolean quoted = false;
        StringBuilder buffer = new StringBuilder();
        char[] cArray = this.m_namePattern.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character ch = Character.valueOf(cArray[n2]);
            if (quoted) {
                buffer.append(ch);
                quoted = false;
            } else if (ch.charValue() == '\\') {
                quoted = true;
            } else if (ch.charValue() == '*' || ch.charValue() == '?') {
                if (buffer.length() > 0) {
                    pattern.append(Pattern.quote(buffer.toString()));
                    buffer.setLength(0);
                }
                pattern.append(ch.charValue() == '*' ? ".*" : ".");
            } else {
                buffer.append(ch);
            }
            ++n2;
        }
        if (buffer.length() > 0) {
            pattern.append(Pattern.quote(buffer.toString()));
        }
        return Pattern.compile(pattern.toString());
    }

    private Map<String, EClass> computeSubclassMap() {
        return this.computeSubclassMap(this.FILTER_CLASS_DEFAULT);
    }

    private Map<String, EClass> computeSubclassMap(EClass superClass) {
        HashMap<String, EClass> classMap = new HashMap<String, EClass>();
        for (EClassifier classifier : AmaltheaPackage.eINSTANCE.getEClassifiers()) {
            EClass subClass;
            if (!(classifier instanceof EClass) || !superClass.isSuperTypeOf(subClass = (EClass)classifier)) continue;
            classMap.put(subClass.getName(), subClass);
        }
        return Collections.unmodifiableMap(classMap);
    }

    void saveTo(IDialogSettings store) {
        if (store == null) {
            return;
        }
        store.put("Search_NamePattern", this.m_namePattern);
        store.put("Search_ClassName", this.m_filterClassName);
        store.put("Search_CaseSensitive", this.m_caseSensitive);
        store.put("Search_RegularExpression", this.m_regularExpression);
        store.put("Search_FileScope", this.m_restrictToFile);
    }

    void loadFrom(IDialogSettings store) {
        if (store == null) {
            return;
        }
        if (store.get("Search_NamePattern") != null) {
            this.m_namePattern = store.get("Search_NamePattern");
        }
        if (store.get("Search_ClassName") != null) {
            this.m_filterClassName = store.get("Search_ClassName");
        }
        if (store.get("Search_CaseSensitive") != null) {
            this.m_caseSensitive = store.getBoolean("Search_CaseSensitive");
        }
        if (store.get("Search_RegularExpression") != null) {
            this.m_regularExpression = store.getBoolean("Search_RegularExpression");
        }
        if (store.get("Search_FileScope") != null) {
            this.m_restrictToFile = store.getBoolean("Search_FileScope");
        }
    }
}

