/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters094.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters094.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters094.utils.HelperUtils_093_094;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SwConverter
extends AbstractConverter {
    public SwConverter() {
        this.helper = HelperUtils_093_094.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File file, Map<File, Document> map, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.9.3 to 0.9.4 : Executing Sw converter for model file : " + file.getName()));
        this.basicConvert(file, map, caches);
    }

    public void basicConvert(File file, Map<File, Document> map, List<ICache> caches) {
        Document document = map.get(file);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.update_Runnables(rootElement);
        this.update_Datatypes(rootElement);
        this.update_ModeLabels(rootElement);
        this.update_ModeLabelAccesses(rootElement);
        this.update_ModeValueLists(rootElement);
        this.update_ModeConditions(rootElement);
        this.update_EnablingModeValueLists(rootElement);
    }

    private void update_Datatypes(Element rootElement) {
        List types = this.helper.getXpathResult(rootElement, "./swModel/typeDefinitions[@xsi:type=\"am:BaseTypeDefinition\"]", Element.class, new Namespace[]{this.helper.getNS_094("am"), this.helper.getGenericNS("xsi")});
        for (Element baseType : types) {
            for (Element mapping : baseType.getChildren("dataMapping")) {
                String platformName = mapping.getAttributeValue("platformName");
                String platformType = mapping.getAttributeValue("platformType");
                mapping.removeAttribute("platformName");
                mapping.removeAttribute("platformType");
                mapping.setName("aliases");
                mapping.setAttribute("target", platformName);
                mapping.setAttribute("alias", platformType);
            }
        }
    }

    private void update_Runnables(Element rootElement) {
        List runnables = this.helper.getXpathResult(rootElement, "./swModel/runnables", Element.class, new Namespace[]{this.helper.getNS_094("am"), this.helper.getGenericNS("xsi")});
        Element constraintModel = rootElement.getChild("constraintsModel");
        if (constraintModel == null) {
            constraintModel = new Element("constraintsModel");
        }
        boolean deadlineFound = false;
        for (Element runnable : runnables) {
            Element deadline = runnable.getChild("deadline");
            String runnableName = runnable.getAttributeValue("name");
            if (deadline == null) continue;
            deadlineFound = true;
            Element runnableReq = new Element("requirements");
            constraintModel.addContent((Content)runnableReq);
            runnableReq.setAttribute("type", "am:RunnableRequirement", this.helper.getGenericNS("xsi"));
            runnableReq.setAttribute("name", "deadline");
            runnableReq.setAttribute("runnable", String.valueOf(this.helper.encodeName(runnableName)) + "?type=Runnable");
            Element limit = new Element("limit");
            runnableReq.addContent((Content)limit);
            limit.setAttribute("type", "am:TimeRequirementLimit", this.helper.getGenericNS("xsi"));
            limit.setAttribute("limitType", "UpperLimit");
            limit.setAttribute("metric", "ResponseTime");
            Element limitValue = deadline.clone();
            limitValue.setName("limitValue");
            limit.addContent((Content)limitValue);
            runnable.removeContent((Content)deadline);
        }
        if (deadlineFound) {
            rootElement.addContent((Content)constraintModel);
        }
    }

    private void update_ModeLabels(Element rootElement) {
        String xpath = "./swModel/modes";
        List modes = this.helper.getXpathResult(rootElement, xpath, Element.class, new Namespace[]{this.helper.getNS_094("am"), this.helper.getGenericNS("xsi")});
        for (Element mode : modes) {
            mode.setAttribute("type", "am:EnumMode", this.helper.getGenericNS("xsi"));
        }
        xpath = "./swModel/modeLabels";
        List modeLabels = this.helper.getXpathResult(rootElement, xpath, Element.class, new Namespace[]{this.helper.getNS_094("am"), this.helper.getGenericNS("xsi")});
        for (Element modeLabel : modeLabels) {
            Pattern p;
            Matcher m;
            String hrefValue;
            Element element;
            Pattern p2;
            Matcher m2;
            String attributeValue = modeLabel.getAttributeValue("initialValue");
            if (attributeValue != null && (m2 = (p2 = Pattern.compile("(.+)/(.+)\\?type=ModeLiteral")).matcher(attributeValue)).find()) {
                String mode = m2.group(1);
                String literal = this.helper.decodeName(m2.group(2));
                modeLabel.setAttribute("mode", String.valueOf(mode) + "?type=EnumMode");
                modeLabel.setAttribute("initialValue", literal);
            }
            if ((element = this.getSingleChild(modeLabel, "initialValue")) == null || (hrefValue = element.getAttributeValue("href")) == null || !(m = (p = Pattern.compile("amlt:/#(.+)/(.+)\\?type=ModeLiteral")).matcher(hrefValue)).find()) continue;
            String mode = m.group(1);
            String literal = this.helper.decodeName(m.group(2));
            element.setName("mode");
            element.setAttribute("type", "am:EnumMode", this.helper.getGenericNS("xsi"));
            element.setAttribute("href", "amlt:/#" + mode + "?type=EnumMode");
            modeLabel.setAttribute("initialValue", literal);
        }
    }

    private void update_ModeLabelAccesses(Element rootElement) {
        List modeLabelAccesses = this.helper.getXpathResult(rootElement, "./swModel/runnables//*[@xsi:type=\"am:ModeLabelAccess\"]", Element.class, new Namespace[]{this.helper.getNS_094("am"), this.helper.getGenericNS("xsi")});
        for (Element modeLabelAccess : modeLabelAccesses) {
            String hrefValue;
            Element element;
            Attribute modeValue;
            Attribute access = modeLabelAccess.getAttribute("access");
            if (access != null && access.getValue().equals("write")) {
                access.setValue("set");
            }
            if ((modeValue = modeLabelAccess.getAttribute("modeValue")) != null) {
                modeValue.setName("value");
                modeValue.setValue(this.extractAndDecodeLiteral(modeValue.getValue()));
            }
            if ((element = this.getSingleChild(modeLabelAccess, "modeValue")) == null || (hrefValue = element.getAttributeValue("href")) == null) continue;
            modeLabelAccess.setAttribute("value", this.extractAndDecodeLiteral(hrefValue));
            modeLabelAccess.removeChild("modeValue");
        }
    }

    private void update_ModeValueLists(Element rootElement) {
        List assignments = this.helper.getXpathResult(rootElement, "./stimuliModel/stimuli/setModeValueList/entries", Element.class, new Namespace[]{this.helper.getNS_094("am"), this.helper.getGenericNS("xsi")});
        for (Element assignment : assignments) {
            this.convertModeValueContents(assignment);
        }
    }

    private void update_ModeConditions(Element rootElement) {
        List conditionDisjunctionEntries = this.helper.getXpathResult(rootElement, "./swModel/runnables//*[@xsi:type=\"am:RunnableModeSwitch\"]/entries/condition/entries|./swModel/tasks//*[@xsi:type=\"am:ModeSwitch\"]/entries/condition/entries|./stimuliModel/stimuli/enablingModeValueList/entries", Element.class, new Namespace[]{this.helper.getNS_094("am"), this.helper.getGenericNS("xsi")});
        for (Element disjunctionEntry : conditionDisjunctionEntries) {
            String entryType = disjunctionEntry.getAttributeValue("type", this.helper.getGenericNS("xsi"));
            if (entryType.equals("am:ModeValue")) {
                this.convertModeValue(disjunctionEntry, true);
                continue;
            }
            if (!entryType.equals("am:ModeValueConjunction")) continue;
            disjunctionEntry.setAttribute("type", "am:ModeConditionConjunction", this.helper.getGenericNS("xsi"));
            for (Element modeValue : disjunctionEntry.getChildren("entries")) {
                this.convertModeValue(modeValue, false);
            }
        }
    }

    private void convertModeValue(Element modeValueElement, boolean setType) {
        if (setType) {
            modeValueElement.setAttribute("type", "am:ModeCondition", this.helper.getGenericNS("xsi"));
        }
        modeValueElement.setAttribute("relation", "EQUAL");
        this.convertModeValueContents(modeValueElement);
    }

    private void convertModeValueContents(Element modeValueElement) {
        String hrefValue;
        Element valueElement;
        String refValue;
        Element providerElement;
        Attribute providerAttribute = modeValueElement.getAttribute("valueProvider");
        if (providerAttribute != null) {
            providerAttribute.setName("label");
        }
        if ((providerElement = this.getSingleChild(modeValueElement, "valueProvider")) != null) {
            providerElement.setName("label");
        }
        if ((refValue = modeValueElement.getAttributeValue("value")) != null) {
            modeValueElement.setAttribute("value", this.extractAndDecodeLiteral(refValue));
        }
        if ((valueElement = this.getSingleChild(modeValueElement, "value")) != null && (hrefValue = valueElement.getAttributeValue("href")) != null) {
            modeValueElement.setAttribute("value", this.extractAndDecodeLiteral(hrefValue));
            modeValueElement.removeChild("value");
        }
    }

    private void update_EnablingModeValueLists(Element rootElement) {
        List stimuli = this.helper.getXpathResult(rootElement, "./stimuliModel/stimuli", Element.class, new Namespace[]{this.helper.getNS_094("am"), this.helper.getGenericNS("xsi")});
        for (Element stimulus : stimuli) {
            Element disablingList;
            String stimulusName = stimulus.getAttributeValue("name");
            Element enablingList = this.getSingleChild(stimulus, "enablingModeValueList");
            if (enablingList != null) {
                enablingList.setName("executionCondition");
            }
            if ((disablingList = this.getSingleChild(stimulus, "disablingModeValueList")) == null) continue;
            this.logger.warn((Object)("From Stimulus : " + stimulusName + ", disablingModeValueList element is removed (as this element is no longer supported by AMALTHEA meta model from 0.9.4 version) "));
            stimulus.removeChild("disablingModeValueList");
        }
    }

    private String extractAndDecodeLiteral(String modeValueReference) {
        String value = modeValueReference;
        Pattern p = Pattern.compile(".*/(.+?)\\?type=ModeLiteral");
        Matcher m = p.matcher(value);
        if (m.find()) {
            return this.helper.decodeName(m.group(1));
        }
        return modeValueReference;
    }

    private Element getSingleChild(Element parent, String name) {
        List list = parent.getChildren(name);
        if (list.size() == 1) {
            return (Element)list.get(0);
        }
        return null;
    }
}

