/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.misc;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.AbstractEventChain;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.EventChainItem;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="AM-Constraints-EventChain")
public class AmConstraintsEventChain
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getAbstractEventChain();
    }

    public void validate(EObject object, List<ValidationDiagnostic> results) {
        if (object instanceof AbstractEventChain) {
            AbstractEventChain chain = (AbstractEventChain)object;
            this.checkChainConsistency(chain, results);
        }
    }

    private void checkChainConsistency(AbstractEventChain eventChain, List<ValidationDiagnostic> results) {
        if (eventChain == null) {
            return;
        }
        this.checkSegments(eventChain, (EList<EventChainItem>)eventChain.getSegments(), results);
    }

    private void checkSegments(AbstractEventChain eventChain, EList<EventChainItem> eventChainItems, List<ValidationDiagnostic> results) {
        if (eventChainItems == null || eventChainItems.isEmpty()) {
            return;
        }
        if (eventChainItems.contains(null)) {
            this.addIssue(results, (EObject)eventChain, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractEventChain_Segments(), "Event Chain " + this.name((INamed)eventChain) + ": segment list contains null reference");
        }
        List subEventChains = eventChainItems.stream().map(item -> item.getEventChain()).filter(Objects::nonNull).collect(Collectors.toList());
        AbstractEventChain first = (AbstractEventChain)subEventChains.get(0);
        AbstractEventChain last = (AbstractEventChain)subEventChains.get(subEventChains.size() - 1);
        if (eventChain.getStimulus() != first.getStimulus()) {
            this.addIssue(results, (EObject)eventChain, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractEventChain_Segments(), "Event Chain " + this.name((INamed)eventChain) + ": stimulus of first segment <> stimulus of event chain");
        }
        if (eventChain.getResponse() != last.getResponse()) {
            this.addIssue(results, (EObject)eventChain, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractEventChain_Segments(), "Event Chain " + this.name((INamed)eventChain) + ": response of last segment <> response of event chain");
        }
        int i = 0;
        while (i < subEventChains.size() - 1) {
            AbstractEventChain current = (AbstractEventChain)subEventChains.get(i);
            AbstractEventChain next = (AbstractEventChain)subEventChains.get(i + 1);
            if (current.getResponse() != next.getStimulus()) {
                this.addIssue(results, (EObject)eventChain, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractEventChain_Segments(), "Event Chain " + this.name((INamed)eventChain) + ": response of segment " + i + " <> stimulus of segment " + (i + 1));
            }
            ++i;
        }
    }
}

