/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.tracing.converter;

import java.lang.reflect.InvocationTargetException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.app4mc.tracing.converter.Htf2Ot1Converter;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.CodeBlockType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.EventTypeEnum;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.InterruptType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.OT1Factory;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.RunnableType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.SchedulingEntityElementType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.SignalType;
import org.eclipse.app4mc.tracing.converter.ot1.OT1.TaskType;

public class Htf2OT1Mapping {
    private final String PREFIX_FACTORY_CREATE = "create";
    private final OT1Factory ot1Factory = OT1Factory.eINSTANCE;
    private final Map<Object, EventTypeEnum> eventMapping = new HashMap<Object, EventTypeEnum>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Htf2Ot1Converter.TaskEvent.ACTIVATE, EventTypeEnum.SCHED_ACTIVATION);
            this.put(Htf2Ot1Converter.TaskEvent.START, EventTypeEnum.SCHED_START);
            this.put(Htf2Ot1Converter.TaskEvent.PREEMPT, EventTypeEnum.SCHED_PREEMPT);
            this.put(Htf2Ot1Converter.TaskEvent.RELEASE, EventTypeEnum.SCHED_RELEASE);
            this.put(Htf2Ot1Converter.TaskEvent.RESUME, EventTypeEnum.SCHED_RESUME);
            this.put(Htf2Ot1Converter.TaskEvent.PARK, EventTypeEnum.SCHED_STOP);
            this.put(Htf2Ot1Converter.TaskEvent.TERMINATE, EventTypeEnum.SCHED_TERMINATE);
            this.put(Htf2Ot1Converter.TaskEvent.WAIT, EventTypeEnum.SCHED_WAIT);
            this.put(Htf2Ot1Converter.InterruptEvent.START, EventTypeEnum.SCHED_START);
            this.put(Htf2Ot1Converter.InterruptEvent.PREEMPT, EventTypeEnum.SCHED_PREEMPT);
            this.put(Htf2Ot1Converter.InterruptEvent.RESUME, EventTypeEnum.SCHED_RESUME);
            this.put(Htf2Ot1Converter.InterruptEvent.TERMINATE, EventTypeEnum.SCHED_TERMINATE);
            this.put(Htf2Ot1Converter.RunnableEvent.START, EventTypeEnum.RUNNABLE_START);
            this.put(Htf2Ot1Converter.RunnableEvent.TERMINATE, EventTypeEnum.RUNNABLE_STOP);
            this.put(Htf2Ot1Converter.CodeBlockEvent.START, EventTypeEnum.CODEBLOCK_START);
            this.put(Htf2Ot1Converter.CodeBlockEvent.STOP, EventTypeEnum.CODEBLOCK_STOP);
            this.put(Htf2Ot1Converter.SignalEvent.READ, EventTypeEnum.SIG_RECEIVE);
            this.put(Htf2Ot1Converter.SignalEvent.WRITE, EventTypeEnum.SIG_TRANSMIT);
        }
    };
    private final Map<Htf2Ot1Converter.EntityType, String> entityTypeMapping = new EnumMap<Htf2Ot1Converter.EntityType, String>(Htf2Ot1Converter.EntityType.class){
        private static final long serialVersionUID = 1L;
        {
            this.put(Htf2Ot1Converter.EntityType.TASK, TaskType.class.getSimpleName());
            this.put(Htf2Ot1Converter.EntityType.ISR, InterruptType.class.getSimpleName());
            this.put(Htf2Ot1Converter.EntityType.RUNNABLE, RunnableType.class.getSimpleName());
            this.put(Htf2Ot1Converter.EntityType.CODEBLOCK, CodeBlockType.class.getSimpleName());
            this.put(Htf2Ot1Converter.EntityType.SIGNAL, SignalType.class.getSimpleName());
        }
    };

    public <T extends Enum<T>> EventTypeEnum getOT1Event(T htfEventType) {
        return this.eventMapping.get(htfEventType);
    }

    public <T extends Enum<T>> int getOT1EventID(T htfEventType) {
        return this.eventMapping.get(htfEventType).getValue();
    }

    public SchedulingEntityElementType getOT1SchedulingEntityElement(Htf2Ot1Converter.EntityType htfEntityType) {
        String methodName = String.valueOf("create") + this.entityTypeMapping.get((Object)htfEntityType);
        Class<?>[] paramGetMethod = null;
        Object[] paramInvoke = null;
        SchedulingEntityElementType entity = null;
        try {
            entity = (SchedulingEntityElementType)this.ot1Factory.getClass().getMethod(methodName, paramGetMethod).invoke((Object)this.ot1Factory, paramInvoke);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return entity;
    }
}

