/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.editors.sirius.design.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.MappingModel;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.emf.ecore.EObject;

public class MappingService {
    public List<ProcessingUnit> getCoresOfMappingModel(MappingModel mappingModel) {
        ArrayList<ProcessingUnit> result = new ArrayList<ProcessingUnit>();
        if (mappingModel != null) {
            mappingModel.getSchedulerAllocation().forEach(alloc -> result.addAll((Collection<ProcessingUnit>)alloc.getResponsibility()));
        }
        return result;
    }

    public List<Scheduler> getSchedulersOfMappingModel(MappingModel mappingModel) {
        ArrayList<Scheduler> result = new ArrayList<Scheduler>();
        if (mappingModel != null) {
            mappingModel.getSchedulerAllocation().forEach(alloc -> {
                if (alloc.getScheduler() != null) {
                    result.add(alloc.getScheduler());
                }
            });
        }
        return result;
    }

    public List<ProcessingUnit> getCoresForScheduler(Scheduler scheduler) {
        Amalthea amalthea;
        ArrayList<ProcessingUnit> result = new ArrayList<ProcessingUnit>();
        if (scheduler != null && (amalthea = this.getAmaltheaForScheduler(scheduler)) != null && amalthea.getMappingModel() != null) {
            amalthea.getMappingModel().getSchedulerAllocation().forEach(alloc -> {
                if (alloc.getScheduler().equals(scheduler)) {
                    result.addAll((Collection<ProcessingUnit>)alloc.getResponsibility());
                }
            });
        }
        return result;
    }

    private Amalthea getAmaltheaForScheduler(Scheduler scheduler) {
        if (scheduler == null) {
            return null;
        }
        return (Amalthea)AmaltheaServices.getContainerOfType((EObject)scheduler, Amalthea.class);
    }

    public List<Task> getTasksForScheduler(Scheduler scheduler) {
        Amalthea amalthea;
        ArrayList<Task> result = new ArrayList<Task>();
        if (scheduler != null && (amalthea = this.getAmaltheaForScheduler(scheduler)) != null && amalthea.getMappingModel() != null) {
            amalthea.getMappingModel().getTaskAllocation().stream().map(alloc -> alloc).forEach(alloc -> {
                if (alloc.getScheduler().equals(scheduler)) {
                    result.add(alloc.getTask());
                }
            });
        }
        return result;
    }
}

