/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.validation.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.app4mc.validation.core.Severity;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ValidationDiagnostic
implements Diagnostic {
    private static final String SOURCE = "org.eclipse.app4mc.validation";
    private static final int NO_INDEX = -1;
    private Severity severity = Severity.UNDEFINED;
    private String validationID;
    private final String message;
    private final EObject targetObject;
    private final EStructuralFeature targetFeature;

    public ValidationDiagnostic(String message, EObject object) {
        this(message, object, null);
    }

    public ValidationDiagnostic(String message, EObject object, EStructuralFeature feature) {
        if (object != null && feature != null && object.eClass().getEStructuralFeature(feature.getName()) != feature) {
            throw new IllegalArgumentException("The object of class " + object.eClass().getName() + " does not contain feature " + feature.getEContainingClass().getName() + "#" + feature.getName());
        }
        this.message = message;
        this.targetObject = object;
        this.targetFeature = feature;
    }

    public EObject getTargetObject() {
        return this.targetObject;
    }

    public EStructuralFeature getTargetFeature() {
        return this.targetFeature;
    }

    public String getValidationID() {
        return this.validationID;
    }

    public void setValidationID(String validationID) {
        this.validationID = validationID;
    }

    public Severity getSeverityLevel() {
        return this.severity;
    }

    public void setSeverityLevel(Severity severity) {
        this.severity = severity;
    }

    public String toString() {
        return String.valueOf(this.validationID) + ": " + this.message + " (" + this.targetObject + ")";
    }

    public int getSeverity() {
        switch (this.severity) {
            case INFO: {
                return 1;
            }
            case WARNING: {
                return 2;
            }
            case ERROR: {
                return 4;
            }
        }
        return 0;
    }

    public String getMessage() {
        return this.message;
    }

    public List<?> getData() {
        return Arrays.asList(this.targetObject, this.targetFeature);
    }

    public String getSource() {
        return SOURCE;
    }

    public List<Diagnostic> getChildren() {
        return Collections.emptyList();
    }

    public int getCode() {
        return -1;
    }

    public Throwable getException() {
        return null;
    }
}

