/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.validation.util;

import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.IValidation;
import org.eclipse.app4mc.validation.core.Severity;
import org.eclipse.emf.ecore.EClassifier;

public class CachedValidator {
    private final Class<? extends IValidation> validatorClass;
    private final String validationID;
    private final IValidation validatorInstance;
    private final EClassifier targetEClassifier;
    private Severity severity;

    public CachedValidator(Class<? extends IValidation> validatorClass, Severity severity) {
        if (validatorClass == null) {
            throw new IllegalArgumentException("Loading aborted - Undefined validator class (null)");
        }
        if (severity == null) {
            throw new IllegalArgumentException("Loading aborted - Undefined validator severity (null)");
        }
        this.validatorClass = validatorClass;
        this.severity = severity;
        Validation validationInfo = validatorClass.getAnnotation(Validation.class);
        this.validationID = validationInfo != null ? validationInfo.id() : validatorClass.getSimpleName();
        try {
            this.validatorInstance = validatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new IllegalStateException(e);
        }
        this.targetEClassifier = this.validatorInstance.getEClassifier();
        if (this.targetEClassifier == null) {
            throw new IllegalArgumentException("Loading aborted - Validation doesn't define a target: " + validatorClass);
        }
    }

    public Class<? extends IValidation> getValidatorClass() {
        return this.validatorClass;
    }

    public IValidation getValidatorInstance() {
        return this.validatorInstance;
    }

    public EClassifier getTargetEClassifier() {
        return this.targetEClassifier;
    }

    public Class<?> getTargetClass() {
        return this.targetEClassifier.getInstanceClass();
    }

    public String getValidationID() {
        return this.validationID;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        if (severity == null) {
            return;
        }
        this.severity = severity;
    }
}

