/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters090.impl;

import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters090.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters090.utils.HWCacheBuilder;
import org.eclipse.app4mc.amalthea.converters090.utils.HWTransformationCache;
import org.eclipse.app4mc.amalthea.converters090.utils.HelperUtils_083_090;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class HwConverter
extends AbstractConverter {
    private List<ICache> caches;
    private HWTransformationCache hwTransformationCache;
    private boolean hasProcessedQuartzes;
    private boolean hasProcessedMemoryTypes;

    public HwConverter() {
        this.helper = HelperUtils_083_090.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.8.3 to 0.9.0  : Executing HW model converter for model file : " + targetFile.getName()));
        this.caches = caches;
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.hwTransformationCache = this.getHWTransformationCache();
        Element oldHWModelElement = rootElement.getChild("hwModel");
        this.migrateHWModel(rootElement, oldHWModelElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void migrateHWModel(Element rootElement, Element oldHWModelElement) {
        if (oldHWModelElement != null) {
            Element newHWModelElement = new Element("hwModel");
            if (!this.hasProcessedMemoryTypes) {
                this.hasProcessedMemoryTypes = true;
                this.migrateAllMemoryTypes_modelscope(newHWModelElement);
            }
            this.migrateCoreTypes(oldHWModelElement, newHWModelElement);
            this.migrateNetworkTypes(oldHWModelElement, newHWModelElement);
            Element oldHWSystem = oldHWModelElement.getChild("system");
            if (oldHWSystem != null) {
                this.migrateSystem(newHWModelElement, oldHWSystem);
            }
            this.migrateLatencyAccessPath(oldHWModelElement, newHWModelElement);
            int indexOf = rootElement.indexOf((Content)oldHWModelElement);
            rootElement.removeContent((Content)oldHWModelElement);
            rootElement.addContent(indexOf, (Content)newHWModelElement);
            this.migrateCustomProperties(oldHWModelElement, newHWModelElement);
        }
    }

    private void migrateAllMemoryTypes_modelscope(Element newHWModelElement) {
        Collection<Element> oldHW_MemoryType_definitions = this.hwTransformationCache.old_memory_Types_Definition_Map.values();
        for (Element oldHWModelElement : oldHW_MemoryType_definitions) {
            this.migrateMemoryTypes(oldHWModelElement, newHWModelElement);
        }
    }

    private void migrateLatencyAccessPath(Element oldHWModelElement, Element newHWModelElement) {
        List oldHWAccessPaths = oldHWModelElement.getChildren("accessPaths");
        for (Element oldHWAccessPath : oldHWAccessPaths) {
            String oldHWAccessPath_name = oldHWAccessPath.getAttributeValue("name");
            String oldHW_AccessPath_Type = oldHWAccessPath.getAttributeValue("type", this.helper.getGenericNS("xsi"));
            if (oldHW_AccessPath_Type == null || !oldHW_AccessPath_Type.equals("am:LatencyAccessPath")) continue;
            Map.Entry oldHW_Source = this.helper.getSingleElementsNameandTypeFromAttributeOrChildeElement("source", oldHWAccessPath);
            Map.Entry oldHW_Target = this.helper.getSingleElementsNameandTypeFromAttributeOrChildeElement("target", oldHWAccessPath);
            Element newHW_AccessElements = null;
            if (oldHW_Source != null) {
                String oldHW_element_key = (String)oldHW_Source.getKey();
                String oldHW_element_type = (String)oldHW_Source.getValue();
                if (oldHW_element_type.equals("Core")) {
                    Element newHW_Core_ProcessingUnit = this.hwTransformationCache.new_cores_Map.get(oldHW_element_key);
                    if (newHW_Core_ProcessingUnit != null) {
                        newHW_AccessElements = new Element("accessElements");
                        newHW_AccessElements.setAttribute("name", oldHWAccessPath_name != null ? oldHWAccessPath_name : "");
                        newHW_Core_ProcessingUnit.addContent((Content)newHW_AccessElements);
                    }
                } else {
                    this.logger.warn((Object)("Unable to migrate LatencyAccessPath from 0.8.3, as the Source type is :" + oldHW_element_type + ". Migration is supported only if source element is of type Core"));
                }
            }
            if (oldHW_Target != null) {
                Element newHW_AccessElements_Destination = new Element("destination");
                String oldHW_element_name = (String)oldHW_Target.getKey();
                String oldHW_element_type = (String)oldHW_Target.getValue();
                if (oldHW_element_type.equals("Memory")) {
                    newHW_AccessElements_Destination.setAttribute("type", "am:Memory", this.helper.getGenericNS("xsi"));
                    newHW_AccessElements_Destination.setAttribute("href", "amlt://#" + this.helper.encodeNameForReference(oldHW_element_name) + "?type=Memory");
                } else if (oldHW_element_type.equals("Core")) {
                    newHW_AccessElements_Destination.setAttribute("type", "am:ProcessingUnit", this.helper.getGenericNS("xsi"));
                    newHW_AccessElements_Destination.setAttribute("href", "amlt://#" + this.helper.encodeNameForReference(oldHW_element_name) + "?type=ProcessingUnit");
                } else {
                    this.logger.warn((Object)("Unable to migrate LatencyAccessPath destination from 0.8.3 successfully, as the destination type is :" + oldHW_element_type + ". Migration is supported only if target element is of type Memory or Core"));
                }
                if (newHW_AccessElements != null) {
                    newHW_AccessElements.addContent((Content)newHW_AccessElements_Destination);
                }
            }
            if (newHW_AccessElements == null) continue;
            List oldHW_Latencies = oldHWAccessPath.getChildren("latencies");
            for (Element oldHW_Latency : oldHW_Latencies) {
                String oldHW_Latency_AccessType = oldHW_Latency.getAttributeValue("accessType");
                if (oldHW_Latency_AccessType == null) continue;
                ArrayList<Element> newHWLatencies = new ArrayList<Element>();
                if (oldHW_Latency_AccessType.equals("R")) {
                    newHWLatencies.add(new Element("readLatency"));
                } else if (oldHW_Latency_AccessType.equals("W")) {
                    newHWLatencies.add(new Element("writeLatency"));
                } else {
                    if (!oldHW_Latency_AccessType.equals("RW")) continue;
                    newHWLatencies.add(new Element("readLatency"));
                    newHWLatencies.add(new Element("writeLatency"));
                }
                for (Element newHW_Latency : newHWLatencies) {
                    newHW_AccessElements.addContent((Content)newHW_Latency);
                    String oldHW_Latency_Type = oldHW_Latency.getAttributeValue("type", this.helper.getGenericNS("xsi"));
                    if (oldHW_Latency_Type == null) continue;
                    if (oldHW_Latency_Type.equals("am:LatencyConstant")) {
                        newHW_Latency.setAttribute("type", "am:LatencyConstant", this.helper.getGenericNS("xsi"));
                        String oldHW_Latency_Value = oldHW_Latency.getAttributeValue("value");
                        if (oldHW_Latency_Value == null) continue;
                        newHW_Latency.setAttribute("cycles", oldHW_Latency_Value);
                        continue;
                    }
                    if (!oldHW_Latency_Type.equals("am:LatencyDeviation")) continue;
                    newHW_Latency.setAttribute("type", "am:LatencyDeviation", this.helper.getGenericNS("xsi"));
                    Element oldHW_Latency_Deviation = oldHW_Latency.getChild("deviation");
                    if (oldHW_Latency_Deviation == null) continue;
                    oldHW_Latency_Deviation = oldHW_Latency_Deviation.clone();
                    oldHW_Latency_Deviation.detach();
                    oldHW_Latency_Deviation.setName("cycles");
                    newHW_Latency.addContent((Content)oldHW_Latency_Deviation);
                }
            }
        }
    }

    private void migrateNetworkTypes(Element oldHWModelElement, Element newHWModelElement) {
        List oldHWNetworkTypes = oldHWModelElement.getChildren("networkTypes");
        for (Element oldHWNetworkType : oldHWNetworkTypes) {
            String oldHWNetworkType_schedPolicy;
            String oldHWNetworkType_name = oldHWNetworkType.getAttributeValue("name");
            Element newHWNetworkType = new Element("definitions");
            newHWModelElement.addContent((Content)newHWNetworkType);
            newHWNetworkType.setAttribute("type", "am:ConnectionHandlerDefinition", this.helper.getGenericNS("xsi"));
            if (oldHWNetworkType_name != null) {
                newHWNetworkType.setAttribute("name", oldHWNetworkType_name);
            }
            if ((oldHWNetworkType_schedPolicy = oldHWNetworkType.getAttributeValue("schedPolicy")) != null) {
                String policy = "_undefined_";
                if (oldHWNetworkType_schedPolicy.equals("RROBIN")) {
                    policy = "RoundRobin";
                } else if (oldHWNetworkType_schedPolicy.equals("PRIORITY")) {
                    policy = "PriorityBased";
                }
                newHWNetworkType.setAttribute("policy", policy);
            }
            this.migrateCustomProperties(oldHWNetworkType, newHWNetworkType);
        }
    }

    private void migrateCoreTypes(Element oldHWModelElement, Element newHWModelElement) {
        List oldHWCoreTypes = oldHWModelElement.getChildren("coreTypes");
        for (Element oldHWCoreType : oldHWCoreTypes) {
            String oldHWCoreType_name = oldHWCoreType.getAttributeValue("name");
            Element newHWCoreType = new Element("definitions");
            newHWModelElement.addContent((Content)newHWCoreType);
            newHWCoreType.setAttribute("type", "am:ProcessingUnitDefinition", this.helper.getGenericNS("xsi"));
            if (oldHWCoreType_name != null) {
                newHWCoreType.setAttribute("name", oldHWCoreType_name);
            }
            newHWCoreType.setAttribute("puType", "CPU");
            Attribute oldHWCoreType_Classifiers = oldHWCoreType.getAttribute("classifiers");
            if (oldHWCoreType_Classifiers != null) {
                newHWCoreType.setAttribute(oldHWCoreType_Classifiers.clone());
            } else {
                List oldCoreType_Classifiers_List = oldHWCoreType.getChildren("classifiers");
                for (Element oldCoreType_Classifier : oldCoreType_Classifiers_List) {
                    newHWCoreType.addContent((Content)oldCoreType_Classifier.clone());
                }
            }
            String oldCoreType_ipc = oldHWCoreType.getAttributeValue("instructionsPerCycle");
            if (oldCoreType_ipc != null) {
                String ipc_value = oldCoreType_ipc;
                oldCoreType_ipc = "IPC_" + ipc_value;
                String newHWFeatureCategoryName = "Instructions";
                Element newHWFeatureCategories = new Element("featureCategories");
                newHWFeatureCategories.setAttribute("name", newHWFeatureCategoryName);
                if (this.hwTransformationCache.new_feature_categories_Map.containsKey(newHWFeatureCategoryName)) {
                    newHWFeatureCategories = this.hwTransformationCache.new_feature_categories_Map.get(newHWFeatureCategoryName);
                } else {
                    newHWModelElement.addContent((Content)newHWFeatureCategories);
                }
                newHWFeatureCategories.setAttribute("featureType", "performance");
                if (!this.hwTransformationCache.new_features_Map.containsKey(String.valueOf(newHWFeatureCategoryName) + "/" + oldCoreType_ipc)) {
                    Element newHWFeatureElement = new Element("features");
                    newHWFeatureElement.setAttribute("name", oldCoreType_ipc);
                    newHWFeatureElement.setAttribute("value", ipc_value);
                    newHWFeatureCategories.addContent((Content)newHWFeatureElement);
                    this.hwTransformationCache.new_features_Map.put(String.valueOf(newHWFeatureCategoryName) + "/" + oldCoreType_ipc, newHWFeatureElement);
                }
                this.hwTransformationCache.new_feature_categories_Map.put(newHWFeatureCategoryName, newHWFeatureCategories);
                Element newHwFeaturesElement = new Element("features");
                newHwFeaturesElement.setAttribute("href", "amlt:/#" + newHWFeatureCategoryName + "/" + oldCoreType_ipc + "?type=HwFeature");
                newHWCoreType.addContent((Content)newHwFeaturesElement);
            }
            this.migrateCustomProperties(oldHWCoreType, newHWCoreType);
        }
    }

    private void migrateMemoryTypes(Element oldHWModelElement_MemoryType, Element newHWModelElement) {
        Element oldMemoryType_size;
        String oldHWMemoryType_name = oldHWModelElement_MemoryType.getAttributeValue("name");
        String oldHWMemoryType_type = oldHWModelElement_MemoryType.getAttributeValue("type");
        Element newHWMemoryType = new Element("definitions");
        newHWModelElement.addContent((Content)newHWMemoryType);
        if (oldHWMemoryType_type != null && oldHWMemoryType_type.equals("CACHE")) {
            newHWMemoryType.setAttribute("type", "am:CacheDefinition", this.helper.getGenericNS("xsi"));
            this.hwTransformationCache.new_cache_Types_Definition_Map.put(this.helper.encodeName(oldHWMemoryType_name), newHWMemoryType);
        } else {
            newHWMemoryType.setAttribute("type", "am:MemoryDefinition", this.helper.getGenericNS("xsi"));
            this.hwTransformationCache.new_memory_Types_Definition_Map.put(this.helper.encodeName(oldHWMemoryType_name), newHWMemoryType);
            Attribute oldHWMemoryType_Classifiers = oldHWModelElement_MemoryType.getAttribute("classifiers");
            if (oldHWMemoryType_Classifiers != null) {
                newHWMemoryType.setAttribute(oldHWMemoryType_Classifiers.clone());
            } else {
                List oldMemoryType_Classifiers_List = oldHWModelElement_MemoryType.getChildren("classifiers");
                for (Element oldMemoryType_Classifier : oldMemoryType_Classifiers_List) {
                    newHWMemoryType.addContent((Content)oldMemoryType_Classifier.clone());
                }
            }
        }
        if (oldHWMemoryType_name != null) {
            newHWMemoryType.setAttribute("name", oldHWMemoryType_name);
        }
        if ((oldMemoryType_size = oldHWModelElement_MemoryType.getChild("size")) != null) {
            newHWMemoryType.addContent((Content)oldMemoryType_size.clone());
        }
        this.migrateCustomProperties(oldHWModelElement_MemoryType, newHWMemoryType);
    }

    private void migrateSystem(Element newHWModelElement, Element oldHWSystem) {
        String oldHWSystem_name = oldHWSystem.getAttributeValue("name");
        Element newHWSystem = new Element("structures");
        if (oldHWSystem_name != null) {
            newHWSystem.setAttribute("name", oldHWSystem_name);
        }
        newHWSystem.setAttribute("structureType", "System");
        newHWModelElement.addContent((Content)newHWSystem);
        this.hwTransformationCache.new_systems_Map.put(this.helper.encodeName(oldHWSystem_name), newHWSystem);
        if (!this.hasProcessedQuartzes) {
            this.hasProcessedQuartzes = true;
            this.migrateAllQuartzes_modelscope(newHWModelElement);
        }
        List oldHWecus = oldHWSystem.getChildren("ecus");
        for (Element oldHWEcu : oldHWecus) {
            this.migrateECU(newHWSystem, oldHWEcu);
        }
        this.migrateMemoriesAndCaches(oldHWSystem, newHWSystem, true, true);
        this.migrateNetworks(oldHWSystem, newHWSystem);
        this.migratePorts(oldHWSystem, newHWSystem);
        this.migrateCustomProperties(oldHWSystem, newHWSystem);
    }

    private void migratePorts(Element oldHWElement, Element newHWElement) {
        List oldHW_ports = oldHWElement.getChildren("ports");
        for (Element oldHWPort : oldHW_ports) {
            Element newHWPort = new Element("ports");
            String oldHWPort_name = oldHWPort.getAttributeValue("name");
            String oldHWPort_bitWidth = oldHWPort.getAttributeValue("bitWidth");
            String oldHWPort_master = oldHWPort.getAttributeValue("master");
            if (oldHWPort_name != null) {
                newHWPort.setAttribute("name", oldHWPort_name);
            }
            if (oldHWPort_bitWidth != null) {
                newHWPort.setAttribute("bitWidth", oldHWPort_bitWidth);
            }
            if (oldHWPort_master != null) {
                if (Boolean.valueOf(oldHWPort_master.trim()).booleanValue()) {
                    newHWPort.setAttribute("portType", "initiator");
                } else {
                    newHWPort.setAttribute("portType", "responder");
                }
            }
            newHWElement.addContent((Content)newHWPort);
            this.migrateCustomProperties(oldHWPort, newHWPort);
        }
    }

    private void migrateMemoriesAndCaches(Element oldHWElement, Element newHWStructure_or_PU_Element, boolean migrateCache, boolean migrateMemory) {
        List<Element> oldHW_Memories = this.getAllMemories(oldHWElement);
        for (Element oldHW_Memory : oldHW_Memories) {
            Element newHW_Memory_Element = new Element("modules");
            String oldHW_Memory_Name = oldHW_Memory.getAttributeValue("name");
            if (oldHW_Memory_Name != null) {
                newHW_Memory_Element.setAttribute("name", oldHW_Memory_Name);
            }
            String hw_memory_typeDefinitionName = this.helper.getSingleElementNameFromAttributeOrChildeElement("type", oldHW_Memory);
            String newHW_definitions_type_amalthea_element = "MemoryDefinition";
            boolean isElementAddedToTheParent = false;
            if (hw_memory_typeDefinitionName != null) {
                if (migrateCache && this.hwTransformationCache.new_cache_Types_Definition_Map.containsKey(hw_memory_typeDefinitionName)) {
                    newHW_definitions_type_amalthea_element = "CacheDefinition";
                    if (migrateCache && !migrateMemory) {
                        newHW_Memory_Element.setName("caches");
                    }
                    newHW_Memory_Element.setAttribute("type", "am:Cache", this.helper.getGenericNS("xsi"));
                    this.hwTransformationCache.new_caches_Map.put(this.helper.encodeName(oldHW_Memory_Name), newHW_Memory_Element);
                    newHWStructure_or_PU_Element.addContent((Content)newHW_Memory_Element);
                    isElementAddedToTheParent = true;
                }
                if (migrateMemory && this.hwTransformationCache.new_memory_Types_Definition_Map.containsKey(hw_memory_typeDefinitionName)) {
                    newHW_Memory_Element.setAttribute("type", "am:Memory", this.helper.getGenericNS("xsi"));
                    this.hwTransformationCache.new_memories_Map.put(this.helper.encodeName(oldHW_Memory_Name), newHW_Memory_Element);
                    newHWStructure_or_PU_Element.addContent((Content)newHW_Memory_Element);
                    isElementAddedToTheParent = true;
                }
            } else if (migrateMemory) {
                newHW_Memory_Element.setAttribute("type", "am:Memory", this.helper.getGenericNS("xsi"));
                this.hwTransformationCache.new_memories_Map.put(this.helper.encodeName(oldHW_Memory_Name), newHW_Memory_Element);
                newHWStructure_or_PU_Element.addContent((Content)newHW_Memory_Element);
                isElementAddedToTheParent = true;
            }
            if (!isElementAddedToTheParent) continue;
            List<Element> newHWMemoryDefinitions = this.migrateAttributeorElementData(oldHW_Memory, "type", "definition", newHW_definitions_type_amalthea_element);
            for (Element newHWMemoryDefinition : newHWMemoryDefinitions) {
                newHW_Memory_Element.addContent((Content)newHWMemoryDefinition);
            }
            this.migratePrescaler(oldHW_Memory, newHW_Memory_Element);
            this.migratePorts(oldHW_Memory, newHW_Memory_Element);
            this.migrateCustomProperties(oldHW_Memory, newHW_Memory_Element);
        }
    }

    private void migrateNetworks(Element oldHWElement, Element newHWStructure) {
        List<Element> oldHW_Networks = this.getAllNetworks(oldHWElement);
        for (Element oldHW_network : oldHW_Networks) {
            Element newHW_network = new Element("modules");
            String oldHW_network_Name = oldHW_network.getAttributeValue("name");
            if (oldHW_network_Name != null) {
                newHW_network.setAttribute("name", oldHW_network_Name);
            }
            newHW_network.setAttribute("type", "am:ConnectionHandler", this.helper.getGenericNS("xsi"));
            List<Element> newHWNetworkTypeDefinitions = this.migrateAttributeorElementData(oldHW_network, "type", "definition", "ConnectionHandlerDefinition");
            for (Element newHWNetworkTypeDefinition : newHWNetworkTypeDefinitions) {
                newHW_network.addContent((Content)newHWNetworkTypeDefinition);
            }
            this.migratePrescaler(oldHW_network, newHW_network);
            this.migratePorts(oldHW_network, newHW_network);
            newHWStructure.addContent((Content)newHW_network);
            this.migrateCustomProperties(oldHW_network, newHW_network);
        }
    }

    private List<Element> getAllNetworks(Element oldHW_ComplexNode) {
        ArrayList<Element> oldHW_Networks = new ArrayList<Element>();
        List oldHW_ComplexNodeElements = oldHW_ComplexNode.getChildren("networks");
        oldHW_Networks.addAll(oldHW_ComplexNodeElements);
        this.populateAllSubNetworks(oldHW_Networks, oldHW_ComplexNode.getChildren("networks"));
        this.populateAllSubNetworks(oldHW_Networks, oldHW_ComplexNode.getChildren("memories"));
        this.populateAllSubNetworks(oldHW_Networks, oldHW_ComplexNode.getChildren("components"));
        return oldHW_Networks;
    }

    private List<Element> getAllMemories(Element oldHW_ComplexNode) {
        ArrayList<Element> oldHW_Memories = new ArrayList<Element>();
        List oldHW_ComplexNodeElements = oldHW_ComplexNode.getChildren("memories");
        oldHW_Memories.addAll(oldHW_ComplexNodeElements);
        this.populateAllSubMemories(oldHW_Memories, oldHW_ComplexNode.getChildren("memories"));
        this.populateAllSubMemories(oldHW_Memories, oldHW_ComplexNode.getChildren("networks"));
        this.populateAllSubMemories(oldHW_Memories, oldHW_ComplexNode.getChildren("components"));
        return oldHW_Memories;
    }

    private void populateAllSubMemories(List<Element> oldHW_Memories, List<Element> oldHW_ComplexNodeElements) {
        for (Element oldHWMemory : oldHW_ComplexNodeElements) {
            StringBuffer xpathBufferForMemoryDefinitions = new StringBuffer();
            xpathBufferForMemoryDefinitions.append("./memories");
            xpathBufferForMemoryDefinitions.append("|");
            xpathBufferForMemoryDefinitions.append(".//components/memories");
            xpathBufferForMemoryDefinitions.append("|");
            xpathBufferForMemoryDefinitions.append(".//nestedComponents/memories");
            xpathBufferForMemoryDefinitions.append("|");
            xpathBufferForMemoryDefinitions.append(".//memories/memories");
            xpathBufferForMemoryDefinitions.append("|");
            xpathBufferForMemoryDefinitions.append(".//networks/memories");
            List memoryElements = this.helper.getXpathResult(oldHWMemory, xpathBufferForMemoryDefinitions.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi"), this.helper.getNS_090("am")});
            oldHW_Memories.addAll(memoryElements);
        }
    }

    private void populateAllSubNetworks(List<Element> oldHW_Networks, List<Element> oldHW_ComplexNodeElements) {
        for (Element oldHWNetwork : oldHW_ComplexNodeElements) {
            StringBuffer xpathBufferForMemoryDefinitions = new StringBuffer();
            xpathBufferForMemoryDefinitions.append("./networks");
            xpathBufferForMemoryDefinitions.append("|");
            xpathBufferForMemoryDefinitions.append(".//components/networks");
            xpathBufferForMemoryDefinitions.append("|");
            xpathBufferForMemoryDefinitions.append(".//nestedComponents/networks");
            xpathBufferForMemoryDefinitions.append("|");
            xpathBufferForMemoryDefinitions.append(".//memories/networks");
            xpathBufferForMemoryDefinitions.append("|");
            xpathBufferForMemoryDefinitions.append(".//networks/networks");
            List networkElements = this.helper.getXpathResult(oldHWNetwork, xpathBufferForMemoryDefinitions.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi"), this.helper.getNS_090("am")});
            oldHW_Networks.addAll(networkElements);
        }
    }

    @Deprecated
    private void migrateAllCores_modelscope(Element newHW_MicroController) {
        Collection<Element> oldHWCoreElements = this.hwTransformationCache.old_cores_Map.values();
        for (Element oldHWCoreElement : oldHWCoreElements) {
            this.migrateCore(newHW_MicroController, oldHWCoreElement);
        }
    }

    private void migrateAllQuartzes_modelscope(Element newHWModel) {
        Collection<Element> oldHWQuartzElements = this.hwTransformationCache.old_hwQuartzs_Map.values();
        for (Element oldHWQuartzElement : oldHWQuartzElements) {
            Element oldHWElement_Frequency;
            Element newHWFrequencyDomain = new Element("domains");
            newHWFrequencyDomain.setAttribute("type", "am:FrequencyDomain", this.helper.getGenericNS("xsi"));
            String oldHWQuartz_name = oldHWQuartzElement.getAttributeValue("name");
            if (oldHWQuartz_name != null) {
                newHWFrequencyDomain.setAttribute("name", oldHWQuartz_name);
            }
            if ((oldHWElement_Frequency = oldHWQuartzElement.getChild("frequency")) != null) {
                Element newHWFrequency_defaultValue = oldHWElement_Frequency.clone();
                newHWFrequency_defaultValue.detach();
                newHWFrequency_defaultValue.setName("defaultValue");
                newHWFrequencyDomain.addContent((Content)newHWFrequency_defaultValue);
            }
            newHWModel.addContent((Content)newHWFrequencyDomain);
            this.migrateCustomProperties(oldHWQuartzElement, newHWFrequencyDomain);
            this.hwTransformationCache.new_hwQuartzs_FrequencyDomain_Map.put(this.helper.encodeName(oldHWQuartz_name), newHWFrequencyDomain);
        }
    }

    private void migrateECU(Element newHWSystem, Element oldHWEcu) {
        String oldHWEcu_name = oldHWEcu.getAttributeValue("name");
        this.hwTransformationCache.old_ecus_Map.put(this.helper.encodeName(oldHWEcu_name), oldHWEcu);
        Element newHWEcu = new Element("structures");
        if (oldHWEcu_name != null) {
            newHWEcu.setAttribute("name", oldHWEcu_name);
        }
        newHWEcu.setAttribute("structureType", "ECU");
        newHWSystem.addContent((Content)newHWEcu);
        this.hwTransformationCache.new_ecus_Map.put(this.helper.encodeName(oldHWEcu_name), newHWEcu);
        this.migrateMemoriesAndCaches(oldHWEcu, newHWEcu, true, true);
        this.migrateNetworks(oldHWEcu, newHWEcu);
        this.migratePorts(oldHWEcu, newHWEcu);
        List oldHWMicroControllers = oldHWEcu.getChildren("microcontrollers");
        for (Element oldHWMicroController : oldHWMicroControllers) {
            this.migrateMicroController(newHWEcu, oldHWMicroController);
        }
        this.migrateCustomProperties(oldHWEcu, newHWEcu);
    }

    private void migrateMicroController(Element newHWEcu, Element oldHWMicroController) {
        String oldHWMicroController_name = oldHWMicroController.getAttributeValue("name");
        this.hwTransformationCache.old_microControllers_Map.put(this.helper.encodeName(oldHWMicroController_name), oldHWMicroController);
        Element newHWMicroController = new Element("structures");
        if (oldHWMicroController_name != null) {
            newHWMicroController.setAttribute("name", oldHWMicroController_name);
        }
        newHWMicroController.setAttribute("structureType", "Microcontroller");
        newHWEcu.addContent((Content)newHWMicroController);
        this.hwTransformationCache.new_microControllers_Map.put(this.helper.encodeName(oldHWMicroController_name), newHWMicroController);
        this.migrateMemoriesAndCaches(oldHWMicroController, newHWMicroController, true, true);
        this.migrateNetworks(oldHWMicroController, newHWMicroController);
        this.migratePorts(oldHWMicroController, newHWMicroController);
        List oldHWCores = oldHWMicroController.getChildren("cores");
        for (Element oldHWCore : oldHWCores) {
            this.migrateCore(newHWMicroController, oldHWCore);
            this.migrateMemoriesAndCaches(oldHWCore, newHWMicroController, false, true);
            this.migrateNetworks(oldHWCore, newHWMicroController);
        }
        this.migrateCustomProperties(oldHWMicroController, newHWMicroController);
    }

    private void migrateCore(Element newHWMicroController, Element oldHWCore) {
        Element newHWCore = new Element("modules");
        newHWMicroController.addContent((Content)newHWCore);
        newHWCore.setAttribute("type", "am:ProcessingUnit", this.helper.getGenericNS("xsi"));
        String oldHWCore_name = oldHWCore.getAttributeValue("name");
        if (oldHWCore_name != null) {
            newHWCore.setAttribute("name", oldHWCore_name);
        }
        List<Element> newHWProcessingUnits = this.migrateAttributeorElementData(oldHWCore, "coreType", "definition", "ProcessingUnitDefinition");
        for (Element newHWProcessingUnit : newHWProcessingUnits) {
            newHWCore.addContent((Content)newHWProcessingUnit);
        }
        this.migratePrescaler(oldHWCore, newHWCore);
        this.migratePorts(oldHWCore, newHWCore);
        this.migrateMemoriesAndCaches(oldHWCore, newHWCore, true, false);
        this.hwTransformationCache.new_cores_Map.put(this.helper.encodeName(oldHWCore_name), newHWCore);
        this.migrateCustomProperties(oldHWCore, newHWCore);
    }

    private void migratePrescaler(Element oldHWElement, Element newHWElement) {
        String oldHW_quartz_name;
        Element oldHWPrescaler = oldHWElement.getChild("prescaler");
        if (oldHWPrescaler != null && (oldHW_quartz_name = this.helper.getSingleElementNameFromAttributeOrChildeElement("quartz", oldHWPrescaler)) != null) {
            Element newHW_FrequencyDomain_baseFrequency_from_Quartz;
            String clockRatio = oldHWPrescaler.getAttributeValue("clockRatio");
            if (clockRatio == null) {
                clockRatio = "0.0";
            }
            String newHW_frequencyDomain_name = "";
            newHW_frequencyDomain_name = clockRatio.trim().toString().equals("1.0") ? oldHW_quartz_name : String.valueOf(oldHW_quartz_name) + "__" + clockRatio;
            Element newHW_FrequencyDomain = this.hwTransformationCache.new_hwQuartzs_FrequencyDomain_Map.get(newHW_frequencyDomain_name);
            if (newHW_FrequencyDomain == null && (newHW_FrequencyDomain_baseFrequency_from_Quartz = this.hwTransformationCache.new_hwQuartzs_FrequencyDomain_Map.get(oldHW_quartz_name)) != null) {
                Attribute newHW_frequency_value_attribute;
                Element parentElement = newHW_FrequencyDomain_baseFrequency_from_Quartz.getParentElement();
                newHW_FrequencyDomain = newHW_FrequencyDomain_baseFrequency_from_Quartz.clone();
                newHW_FrequencyDomain.detach();
                newHW_frequencyDomain_name = String.valueOf(oldHW_quartz_name) + "__" + clockRatio;
                newHW_FrequencyDomain.setAttribute("name", newHW_frequencyDomain_name);
                parentElement.addContent((Content)newHW_FrequencyDomain);
                this.hwTransformationCache.new_hwQuartzs_FrequencyDomain_Map.put(newHW_frequencyDomain_name, newHW_FrequencyDomain);
                Element newHW_frequency = newHW_FrequencyDomain.getChild("defaultValue");
                if (newHW_frequency != null && (newHW_frequency_value_attribute = newHW_frequency.getAttribute("value")) != null) {
                    try {
                        String value = newHW_frequency_value_attribute.getValue();
                        String newHW_frequency_value = String.valueOf(Double.parseDouble(value) * Double.parseDouble(clockRatio));
                        newHW_frequency_value_attribute.setValue(newHW_frequency_value);
                    }
                    catch (Exception exception) {
                        this.logger.error((Object)("Exception occured during creation of new FrequencyDomain :" + newHW_FrequencyDomain.getAttributeValue("name")));
                    }
                }
            }
            if (newHW_FrequencyDomain != null) {
                Element newHW_frequencyDoamin_reference = new Element("frequencyDomain");
                newHW_frequencyDoamin_reference.setAttribute("href", "amlt:/#" + this.helper.encodeNameForReference(newHW_FrequencyDomain.getAttributeValue("name")) + "?type=FrequencyDomain");
                newHWElement.addContent((Content)newHW_frequencyDoamin_reference);
            }
        }
    }

    private List<Element> migrateAttributeorElementData(Element oldHWElement, String attributeOrChildElementName, String newChildElementName, String newChildElementType) {
        ArrayList<Element> newHWElements = new ArrayList<Element>();
        Attribute oldHWAttribute = oldHWElement.getAttribute(attributeOrChildElementName);
        if (oldHWAttribute != null) {
            String oldHWRefElementsValue = oldHWAttribute.getValue();
            StringTokenizer stk = new StringTokenizer(oldHWRefElementsValue);
            while (stk.hasMoreTokens()) {
                String nextToken = stk.nextToken();
                String newHWRefElementName = this.updateReferenceStringWithNewType(nextToken, newChildElementType);
                Element newHWRefElement = new Element(newChildElementName);
                newHWRefElement.setAttribute("href", "amlt:/#" + newHWRefElementName);
                newHWElements.add(newHWRefElement);
            }
        } else {
            List oldHWChildElements = oldHWElement.getChildren(attributeOrChildElementName);
            for (Element oldHWChildElement : oldHWChildElements) {
                String oldHWhrefValue = oldHWChildElement.getAttributeValue("href");
                if (oldHWhrefValue == null) continue;
                String newHWRefElementName = this.updateReferenceStringWithNewType(oldHWhrefValue, newChildElementType);
                Element newHWRefElement = new Element(newChildElementName);
                newHWRefElement.setAttribute("href", newHWRefElementName);
                newHWElements.add(newHWRefElement);
            }
        }
        oldHWElement.removeAttribute(attributeOrChildElementName);
        oldHWElement.removeChildren(attributeOrChildElementName);
        return newHWElements;
    }

    private String updateReferenceStringWithNewType(String inputString, String newType) {
        if (inputString != null) {
            int startIndex = inputString.indexOf("?type=");
            if (startIndex != -1) {
                String oldHWRefElementName = inputString.substring(0, startIndex);
                String newHWRefElementName = String.valueOf(oldHWRefElementName) + "?type=" + newType;
                return newHWRefElementName;
            }
            return inputString;
        }
        return inputString;
    }

    private void migrateCustomProperties(Element oldHwElement, Element newHwElement) {
        List customProperties = oldHwElement.getChildren("customProperties");
        for (Element customProperty : customProperties) {
            Element newHwCustomProperty = customProperty.clone();
            newHwCustomProperty.detach();
            newHwElement.addContent((Content)newHwCustomProperty);
        }
    }

    private HWTransformationCache getHWTransformationCache() {
        if (this.hwTransformationCache == null) {
            boolean isHWCacheAvailable = false;
            for (ICache cache : this.caches) {
                Map map;
                if (!(cache instanceof HWCacheBuilder)) continue;
                isHWCacheAvailable = true;
                Map cacheMap = cache.getCacheMap();
                if (cacheMap == null || cacheMap.size() <= 0 || (map = (Map)Iterables.get(cacheMap.values(), (int)0)) == null) continue;
                Object object = map.get("globalCache");
                return (HWTransformationCache)object;
            }
            if (!isHWCacheAvailable) {
                return new HWTransformationCache();
            }
        }
        return this.hwTransformationCache;
    }
}

