/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.jobs;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.FileAppender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.converters.ui.utils.MigrationInputFile;
import org.eclipse.app4mc.amalthea.converters.ui.utils.MigrationSettings;
import org.eclipse.app4mc.amalthea.converters.ui.utils.ModelMigrationDelegator;
import org.eclipse.app4mc.amalthea.converters.ui.utils.ModelVersions;

public class SimpleModelMigrationJob {
    private MigrationSettings migrationSettings;
    private Logger logger;
    private FileAppender fileAppender;

    public SimpleModelMigrationJob(MigrationSettings migrationSettings) {
        this.migrationSettings = migrationSettings;
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void run() {
        boolean sourceFileBackup;
        ModelMigrationDelegator migrationJob;
        block7: {
            List<String> modelVersions = ModelVersions.get();
            Collections.reverse(modelVersions);
            this.migrationSettings.setMigrationModelVersion(modelVersions.get(0));
            MigrationInputFile migrationInputFile = this.migrationSettings.getMigModelFiles().get(0);
            File origFile = migrationInputFile.getFile();
            this.migrationSettings.setOutputDirectoryLocation(origFile.getParent());
            migrationJob = new ModelMigrationDelegator(this.migrationSettings, this.logger);
            sourceFileBackup = false;
            String newFileName = this.getBackupFileName(migrationInputFile);
            try {
                try {
                    String filebackupName = String.valueOf(migrationInputFile.getFile().getParent()) + File.separator + newFileName;
                    Files.copy((File)origFile, (File)new File(filebackupName));
                    migrationJob.getLogger().info((Object)("Original model file saved as " + filebackupName + System.getProperty("line.separator")));
                    if (new File(filebackupName).exists()) {
                        sourceFileBackup = true;
                    }
                }
                catch (IOException e) {
                    migrationJob.getLogger().error((Object)e.getMessage(), (Throwable)e);
                    this.migrationSettings.setOutputDirectoryLocation(origFile.getParent());
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.migrationSettings.setOutputDirectoryLocation(origFile.getParent());
                throw throwable;
            }
            this.migrationSettings.setOutputDirectoryLocation(origFile.getParent());
        }
        if (!sourceFileBackup) {
            migrationJob.getLogger().error((Object)("Migration Stopped : Source file could not be backed up before migration" + System.getProperty("line.separator")));
            return;
        }
        migrationJob.execute();
    }

    public MigrationSettings getMigrationSettings() {
        return this.migrationSettings;
    }

    public FileAppender getFileAppender() {
        return this.fileAppender;
    }

    public void setFileAppender(FileAppender fileAppender) {
        this.fileAppender = fileAppender;
    }

    private String getBackupFileName(MigrationInputFile migrationInputFile) {
        String fileName = migrationInputFile.getFile().getName();
        String newFileName = fileName.substring(0, fileName.lastIndexOf("."));
        String suffixString = "_" + migrationInputFile.getModelVersion();
        String fileExtension = ".amxmi";
        newFileName = String.valueOf(newFileName) + suffixString + fileExtension;
        if (new File(String.valueOf(migrationInputFile.getFile().getParent()) + File.separator + newFileName).exists()) {
            newFileName.replace(String.valueOf(suffixString) + fileExtension, String.valueOf(suffixString) + suffixString + fileExtension);
        }
        return newFileName;
    }
}

