/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters072.impl;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters072.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters072.utils.HelperUtils_071_072;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SwConverter
extends AbstractConverter {
    public SwConverter() {
        this.helper = HelperUtils_071_072.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.7.1 to 0.7.2 : Executing SW converter for model file : " + targetFile.getName()));
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.update_Buffering(rootElement);
        this.update_SamplingType(rootElement);
        this.update_InstructionsConstant(rootElement);
        this.update_InstructionsDeviation(rootElement);
        this.update_ProbabilityGroup(rootElement);
        this.update_Group(rootElement);
        this.update_Preemption(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void update_Buffering(Element rootElement) {
        StringBuffer labelXpathBuffer = new StringBuffer();
        labelXpathBuffer.append("./swModel/labels");
        List elements = this.helper.getXpathResult(rootElement, labelXpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element labelElement : elements) {
            Attribute bufferedAttribute = labelElement.getAttribute("buffered");
            if (bufferedAttribute == null) continue;
            bufferedAttribute.setName("dataStability");
            String bufferedValue = bufferedAttribute.getValue();
            if (bufferedValue.equals("buffered")) {
                bufferedAttribute.setValue("customProtection");
                continue;
            }
            if (!bufferedValue.equals("notBuffered")) continue;
            bufferedAttribute.setValue("noProtection");
        }
        StringBuffer labelAccessXpathBuffer = new StringBuffer();
        labelAccessXpathBuffer.append("./swModel/runnables//runnableItems[@xsi:type=\"am:LabelAccess\"]");
        labelAccessXpathBuffer.append("|");
        labelAccessXpathBuffer.append("./swModel/runnables//runnableItem[@xsi:type=\"am:LabelAccess\"]");
        List labelAccesselements = this.helper.getXpathResult(rootElement, labelAccessXpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element labelAccessElement : labelAccesselements) {
            Attribute bufferedAttribute = labelAccessElement.getAttribute("buffered");
            if (bufferedAttribute == null) continue;
            bufferedAttribute.setName("dataStability");
            String bufferedValue = bufferedAttribute.getValue();
            if (bufferedValue.equals("inherited")) {
                bufferedAttribute.setValue("inherited");
                continue;
            }
            if (bufferedValue.equals("buffered")) {
                bufferedAttribute.setValue("customProtection");
                continue;
            }
            if (!bufferedValue.equals("notBuffered")) continue;
            bufferedAttribute.setValue("noProtection");
        }
    }

    private void update_SamplingType(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./stimuliModel/stimuli/stimulusDeviation");
        xpathBuffer.append("|");
        xpathBuffer.append("./hwModel/accessPaths/latencies[@xsi:type=\"am:LatencyDeviation\"]/deviation");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/taskSchedulers/schedulingUnit/instructions/deviation");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/interruptControllers/schedulingUnit/instructions/deviation");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads//deviation");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables//deviation");
        List elements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element deviation : elements) {
            String distributionType;
            Attribute samplingTypeAttribute = deviation.getAttribute("samplingType");
            if (samplingTypeAttribute == null) continue;
            String value = samplingTypeAttribute.getValue();
            Element distribution = deviation.getChild("distribution");
            if (distribution != null && (distributionType = distribution.getAttributeValue("type", this.helper.getGenericNS("xsi"))) != null && distributionType.equals("am:Boundaries")) {
                distribution.setAttribute("samplingType", value);
            }
            deviation.removeAttribute(samplingTypeAttribute);
        }
    }

    private void update_InstructionsConstant(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/runnables//runnableItems[@xsi:type=\"am:InstructionsConstant\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables//runnableItem[@xsi:type=\"am:InstructionsConstant\"]");
        List elements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element instructionsConstantElement : elements) {
            Attribute typeAttribute = instructionsConstantElement.getAttribute("type", this.helper.getGenericNS("xsi"));
            typeAttribute.setValue("am:RunnableInstructions");
            Attribute valueAttribute = instructionsConstantElement.getAttribute("value");
            Element subInstructionsConstantElement = new Element("default");
            subInstructionsConstantElement.setAttribute("type", "am:InstructionsConstant", this.helper.getGenericNS("xsi"));
            if (valueAttribute != null) {
                subInstructionsConstantElement.setAttribute("value", valueAttribute.getValue());
                instructionsConstantElement.removeAttribute(valueAttribute);
            }
            instructionsConstantElement.addContent((Content)subInstructionsConstantElement);
        }
    }

    private void update_InstructionsDeviation(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/runnables//runnableItems[@xsi:type=\"am:InstructionsDeviation\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables//runnableItem[@xsi:type=\"am:InstructionsDeviation\"]");
        List elements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element instructionsDeviationElement : elements) {
            Attribute typeAttribute = instructionsDeviationElement.getAttribute("type", this.helper.getGenericNS("xsi"));
            typeAttribute.setValue("am:RunnableInstructions");
            Element subInstructionsDeviationElement = new Element("default");
            subInstructionsDeviationElement.setAttribute("type", "am:InstructionsDeviation", this.helper.getGenericNS("xsi"));
            List instructionsDeviationChildElements = instructionsDeviationElement.getChildren();
            Iterator instructionsDeviationChildElements_iterator = instructionsDeviationChildElements.iterator();
            while (instructionsDeviationChildElements_iterator.hasNext()) {
                Element nextChildElement = (Element)instructionsDeviationChildElements_iterator.next();
                instructionsDeviationChildElements_iterator.remove();
                subInstructionsDeviationElement.addContent((Content)nextChildElement);
            }
            instructionsDeviationElement.addContent((Content)subInstructionsDeviationElement);
        }
    }

    private void update_Preemption(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/processPrototypes[@preemption=\"unknown\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/tasks[@preemption=\"unknown\"]");
        List elements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element element : elements) {
            element.removeAttribute("preemption");
        }
    }

    private void update_Group(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/runnables//runnableItems[@xsi:type=\"am:Group\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables//runnableItem[@xsi:type=\"am:Group\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables//items[@xsi:type=\"am:Group\"]");
        List runnableItemElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element runnableItemElement : runnableItemElements) {
            List deviationRunnableItemsList = this.helper.getXpathResult(runnableItemElement, "./items", Element.class, new Namespace[0]);
            for (Element deviationRunnableItemElement : deviationRunnableItemsList) {
                List childRunnableItems = this.helper.getXpathResult(deviationRunnableItemElement, "./runnableItem", Element.class, new Namespace[0]);
                if (childRunnableItems != null && childRunnableItems.size() > 0) {
                    Element childRunnableItem = (Element)childRunnableItems.get(0);
                    deviationRunnableItemElement.removeContent((Content)childRunnableItem);
                    childRunnableItem.setName("items");
                    runnableItemElement.removeContent((Content)deviationRunnableItemElement);
                    runnableItemElement.addContent((Content)childRunnableItem);
                    continue;
                }
                runnableItemElement.removeContent((Content)deviationRunnableItemElement);
            }
        }
    }

    private void update_ProbabilityGroup(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/runnables//runnableItems[@xsi:type=\"am:ProbabilityGroup\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables//runnableItem[@xsi:type=\"am:ProbabilityGroup\"]");
        List runnableItemElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element runnableItemElement : runnableItemElements) {
            Attribute typeAttribute = runnableItemElement.getAttribute("type", this.helper.getGenericNS("xsi"));
            typeAttribute.setValue("am:RunnableProbabilitySwitch");
            List itemsElements = runnableItemElement.getChildren("items");
            for (Element itemsElement : itemsElements) {
                itemsElement.setName("entries");
                Element childRunnableItemElement = itemsElement.getChild("runnableItem");
                if (childRunnableItemElement == null) continue;
                childRunnableItemElement.setName("items");
            }
        }
    }
}

