/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.ta.hardware;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.ProcessingUnitDefinition;
import org.eclipse.app4mc.amalthea.model.PuType;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="TA-Hardware-PUDIPCMissing")
public class TAHardwarePUDIPCMissing
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getProcessingUnitDefinition();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        ProcessingUnitDefinition pud;
        if (eObject instanceof ProcessingUnitDefinition && (pud = (ProcessingUnitDefinition)eObject).getPuType() == PuType.CPU) {
            List oHWF = pud.getFeatures().stream().filter(hwf -> hwf.getContainingCategory() != null && "Instructions".equalsIgnoreCase(hwf.getContainingCategory().getName())).filter(hwf -> hwf.getName() != null && hwf.getName().startsWith("IPC_")).collect(Collectors.toList());
            if (oHWF.size() > 1) {
                this.addIssue(results, (EObject)pud, (EStructuralFeature)ePackage.getProcessingUnitDefinition_Features(), String.valueOf(this.objectInfo((EObject)pud)) + " has multiple IPC HwFeatures (only the first will be considered)");
            }
            if (oHWF.isEmpty()) {
                this.addIssue(results, (EObject)pud, (EStructuralFeature)ePackage.getProcessingUnitDefinition_Features(), String.valueOf(this.objectInfo((EObject)pud)) + " does not have an IPC specified (default value of 1.0 will be assumed). " + "To specify an IPC value: add a HwFeature in the category named \"Instructions\", set a name that starts with \"IPC_\", set a positive " + "value, and add it to the feature list of " + this.objectInfo((EObject)pud) + ".");
            }
        }
    }
}

