/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters080.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters080.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters080.utils.HelperUtils_072_080;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.XMLOutputter;

public class PropertyConstraintsConverter
extends AbstractConverter {
    public PropertyConstraintsConverter() {
        this.helper = HelperUtils_072_080.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.7.2 to 0.8.0 : Executing Mapping converter for model file : " + targetFile.getName()));
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.remove_HWConstraint_Element(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void remove_HWConstraint_Element(Element rootElement) {
        XMLOutputter xmlOutputter = new XMLOutputter();
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./propertyConstraintsModel/allocationConstraints/hwConstraint");
        xpathBuffer.append("|");
        xpathBuffer.append("./propertyConstraintsModel/mappingConstraints/hwConstraint");
        List elements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element hwConstraintElement : elements) {
            String xmlString = xmlOutputter.outputString(hwConstraintElement);
            Element parentElement = hwConstraintElement.getParentElement();
            Element customPropertyElement = new Element("customProperties");
            customPropertyElement.setAttribute("key", "hwConstraint (element removed during Migration of Model to 0.8.0 version)");
            Element valueElement = new Element("value");
            valueElement.setAttribute("type", "am:StringObject", this.helper.getGenericNS("xsi"));
            valueElement.setAttribute("value", xmlString);
            customPropertyElement.addContent((Content)valueElement);
            parentElement.addContent((Content)customPropertyElement);
            this.logger.warn((Object)("hwConstraint tag is removed from " + parentElement.getName() + " . Below is the content of hwConstraint object: \n" + xmlString));
            parentElement.removeContent((Content)hwConstraintElement);
        }
    }
}

