/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.validation.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.validation.annotation.ProfileGroup;
import org.eclipse.app4mc.validation.core.IProfile;
import org.eclipse.app4mc.validation.util.ProfileManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.TreeNode;

public class ProfileDialogSettings {
    private final String KEY_SELECTED_PROFILE_CLASSES = "Validation_SelectedProfileClasses";
    private Map<Class<? extends IProfile>, TreeNode> rootProfiles = new HashMap<Class<? extends IProfile>, TreeNode>();
    private Set<String> selectedProfileClassNames = new HashSet<String>();
    boolean dialogSuccess = false;
    public List<Class<? extends IProfile>> dialogResults = null;

    public void addAllRegisteredProfileClasses() {
        Map profileMap = ProfileManager.getRegisteredProfileClasses();
        for (Class profileClass : profileMap.values()) {
            this.addRootProfile(profileClass);
        }
    }

    public void addRootProfile(Class<? extends IProfile> profileClass) {
        TreeNode node = new TreeNode(profileClass);
        this.addSubNodes(node);
        this.rootProfiles.put(profileClass, node);
    }

    public void removeRootProfile(Class<? extends IProfile> profileClass) {
        this.rootProfiles.remove(profileClass);
    }

    public void setSelectedProfileClassNames(List<String> classNames) {
        this.selectedProfileClassNames.clear();
        this.selectedProfileClassNames.addAll(classNames);
    }

    public TreeNode[] getRootNodes() {
        return (TreeNode[])this.rootProfiles.values().stream().toArray(TreeNode[]::new);
    }

    public TreeNode[] getSelectedNodes() {
        ArrayList<TreeNode> allNodes = new ArrayList<TreeNode>();
        for (TreeNode rootNode : this.rootProfiles.values()) {
            allNodes.add(rootNode);
            this.collectSubNodes(rootNode, allNodes);
        }
        return (TreeNode[])allNodes.stream().filter(e -> this.selectedProfileClassNames.contains(((Class)e.getValue()).getName())).toArray(TreeNode[]::new);
    }

    public void loadFrom(IDialogSettings store) {
        if (store == null) {
            return;
        }
        String[] classNames = store.getArray("Validation_SelectedProfileClasses");
        if (classNames != null) {
            this.setSelectedProfileClassNames(Arrays.asList(classNames));
        }
    }

    public void saveTo(IDialogSettings store) {
        if (store == null) {
            return;
        }
        if (!this.dialogSuccess || this.dialogResults == null) {
            return;
        }
        String[] classNames = (String[])this.dialogResults.stream().map(cls -> cls.getName()).toArray(String[]::new);
        store.put("Validation_SelectedProfileClasses", classNames);
    }

    private void collectSubNodes(TreeNode node, List<TreeNode> list) {
        if (node.hasChildren()) {
            TreeNode[] treeNodeArray = node.getChildren();
            int n = treeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode subNode = treeNodeArray[n2];
                list.add(subNode);
                this.collectSubNodes(subNode, list);
                ++n2;
            }
        }
    }

    private void addSubNodes(TreeNode node) {
        ProfileGroup[] profileGroupList;
        List<Class<? extends IProfile>> forbiddenClasses = this.forbiddenSubProfiles(node);
        Class profileClass = (Class)node.getValue();
        ArrayList<TreeNode> subnodeList = new ArrayList<TreeNode>();
        ProfileGroup[] profileGroupArray = profileGroupList = (ProfileGroup[])profileClass.getAnnotationsByType(ProfileGroup.class);
        int n = profileGroupList.length;
        int n2 = 0;
        while (n2 < n) {
            ProfileGroup pGroup = profileGroupArray[n2];
            Class[] classArray = pGroup.profiles();
            int n3 = classArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Class pClass = classArray[n4];
                if (pClass != null && !forbiddenClasses.contains(pClass)) {
                    TreeNode newNode = new TreeNode((Object)pClass);
                    newNode.setParent(node);
                    subnodeList.add(newNode);
                    this.addSubNodes(newNode);
                }
                ++n4;
            }
            ++n2;
        }
        node.setChildren((TreeNode[])subnodeList.stream().toArray(TreeNode[]::new));
    }

    private List<Class<? extends IProfile>> forbiddenSubProfiles(TreeNode node) {
        ArrayList<Class<? extends IProfile>> classes = new ArrayList<Class<? extends IProfile>>();
        TreeNode n = node;
        while (n != null) {
            Class pc = (Class)n.getValue();
            if (pc != null) {
                classes.add(pc);
            }
            n = n.getParent();
        }
        return classes;
    }
}

