/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters071.impl;

import java.io.File;
import java.util.AbstractMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.7.0", "output_model_version=0.7.1"}, service={IConverter.class})
public class ConstraintsConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConstraintsConverter.class);

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) {
        LOGGER.info("Migration from 0.7.0 to 0.7.1 : Executing Constraints converter for model file : {}", (Object)targetFile.getName());
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.remove_SchedulerPairing_SchedulerSeparation_Constraints(rootElement);
        this.update_ProcessRunnableGroup(rootElement);
        this.remove_OrderConstraints(rootElement);
        this.update_Age_Reaction_Delay_SynchronisationConstraints(rootElement);
    }

    private void update_Age_Reaction_Delay_SynchronisationConstraints(Element rootElement) {
        List ageConstraints = HelperUtil.getXpathResult((Element)rootElement, (String)"./constraintsModel/timingConstraints[@xsi:type=\"am:AgeConstraint\" or @xsi:type=\"am:ReactionConstraint\" or  @xsi:type=\"am:DelayConstraint\" or @xsi:type=\"am:SynchronisationConstraint\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._071, (String)"am")});
        for (Element constraint : ageConstraints) {
            Attribute typeAttrib = constraint.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            String attribValue = typeAttrib.getValue();
            if (attribValue.equals("am:AgeConstraint")) {
                typeAttrib.setValue("am:EventChainLatencyConstraint");
                constraint.setAttribute("type", "Age");
                continue;
            }
            if (attribValue.equals("am:ReactionConstraint")) {
                typeAttrib.setValue("am:EventChainLatencyConstraint");
                constraint.setAttribute("type", "Reaction");
                continue;
            }
            if (attribValue.equals("am:SynchronisationConstraint")) {
                typeAttrib.setValue("am:EventSynchronizationConstraint");
                continue;
            }
            if (!attribValue.equals("am:DelayConstraint")) continue;
            constraint.setAttribute("mappingType", "Reaction");
        }
    }

    private void remove_OrderConstraints(Element rootElement) {
        List constraints = HelperUtil.getXpathResult((Element)rootElement, (String)"./constraintsModel/timingConstraints[@xsi:type=\"am:OrderConstraint\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._071, (String)"am")});
        for (Element constraint : constraints) {
            constraint.getParentElement().removeContent((Content)constraint);
        }
    }

    private void remove_SchedulerPairing_SchedulerSeparation_Constraints(Element rootElement) {
        List constraints = HelperUtil.getXpathResult((Element)rootElement, (String)"./constraintsModel/affinityConstraints[@xsi:type=\"am:SchedulerPairingConstraint\" or @xsi:type=\"am:SchedulerSeparationConstraint\" ]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._071, (String)"am")});
        for (Element constraint : constraints) {
            constraint.getParentElement().removeContent((Content)constraint);
        }
    }

    private void update_ProcessRunnableGroup(Element rootElement) {
        List runnableGroups = HelperUtil.getXpathResult((Element)rootElement, (String)"./constraintsModel/runnableSequencingConstraints/runnableGroups", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._071, (String)"am")});
        for (Element runnableGroup : runnableGroups) {
            runnableGroup.removeAttribute("groupingType");
            List processRunnableGroupEntries = runnableGroup.getChildren("entries");
            Map.Entry<Boolean, Set<String>> resultEntry = this.getRunnableRefs_from_ProcessRunnableGroupEntries(processRunnableGroupEntries);
            Boolean isExternalAmaltheaModelElementReferred = resultEntry.getKey();
            Set<String> runnableRefs = resultEntry.getValue();
            if (isExternalAmaltheaModelElementReferred.booleanValue()) {
                for (String runnableRef : runnableRefs) {
                    Element runnableRefElement = new Element("runnables");
                    if (runnableRef.contains("?")) {
                        if (!runnableRef.contains("amlt:/#")) {
                            runnableRef = "amlt:/#" + runnableRef;
                        }
                    } else {
                        int indexOf = runnableRef.indexOf("#");
                        if (indexOf != -1) {
                            runnableRef = runnableRef.substring(indexOf + 1);
                        }
                        runnableRef = "amlt:/#" + runnableRef;
                    }
                    runnableRefElement.setAttribute("href", runnableRef);
                    runnableGroup.addContent((Content)runnableRefElement);
                }
            } else {
                StringBuilder runnablesBuffer = new StringBuilder();
                for (String runnable : runnableRefs) {
                    runnablesBuffer.append(runnable);
                    runnablesBuffer.append(" ");
                }
                runnableGroup.setAttribute(new Attribute("runnables", runnablesBuffer.toString().trim()));
            }
            runnableGroup.removeChildren("entries");
        }
    }

    private Map.Entry<Boolean, Set<String>> getRunnableRefs_from_ProcessRunnableGroupEntries(List<Element> processRunnableGroupEntries) {
        boolean isElementFromOtherFilePresent = false;
        LinkedHashSet<String> runnableRefs = new LinkedHashSet<String>();
        for (Element entry : processRunnableGroupEntries) {
            Element runnableElement;
            String attributeValue = entry.getAttributeValue("runnable");
            if (attributeValue == null && (runnableElement = entry.getChild("runnable")) != null && (attributeValue = runnableElement.getAttributeValue("href")) != null) {
                isElementFromOtherFilePresent = true;
            }
            if (attributeValue == null) continue;
            runnableRefs.add(attributeValue);
        }
        return new AbstractMap.SimpleEntry<Boolean, Set<String>>(isElementFromOtherFilePresent, runnableRefs);
    }
}

