/**
 ********************************************************************************
 * Copyright (c) 2015-2019 Robert Bosch GmbH and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 ********************************************************************************
 */

package org.eclipse.app4mc.amalthea.converters.ui.dialog;

import org.eclipse.app4mc.amalthea.converters.common.MigrationInputFile;
import org.eclipse.app4mc.amalthea.converters.common.MigrationSettings;
import org.eclipse.app4mc.amalthea.converters.ui.providers.MigrationVersionErrorDataProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class MigrationErrorDialog extends Dialog {

	private final MigrationSettings migrationSettings;

	public MigrationErrorDialog(Shell parentShell, MigrationSettings migrationSettings) {
		super(parentShell);
		setShellStyle(SWT.APPLICATION_MODAL | SWT.DIALOG_TRIM | SWT.RESIZE);
		this.migrationSettings = migrationSettings;
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText("AMALTHEA Model Migration");
	}

	@Override
	protected Control createDialogArea(Composite parent) {

		parent.setToolTipText("AMALTHEA Model Migration");

		Composite parentComposite = (Composite) super.createDialogArea(parent);
		GridLayout gridLayout = (GridLayout) parentComposite.getLayout();
		gridLayout.numColumns = 1;

		Label lblModelMigrationIs = new Label(parentComposite, SWT.NONE);
		lblModelMigrationIs.setText("Model migration stopped as selected model files belong to different versions.");
		GridDataFactory
			.swtDefaults()
			.align(SWT.FILL, SWT.CENTER)
			.grab(true, false)
			.applyTo(lblModelMigrationIs);

		Composite tableComposite = createFileTableViewer(parentComposite);
		GridDataFactory
			.fillDefaults()
			.grab(true, true)
			.applyTo(tableComposite);

		return parentComposite;
	}

	private Composite createFileTableViewer(Composite parent) {
		Composite tableComposite = new Composite(parent, SWT.NONE);

		TableColumnLayout tableColumnLayout = new TableColumnLayout();
		tableComposite.setLayout(tableColumnLayout);

		TableViewer tableViewer = new TableViewer(tableComposite,
				SWT.BORDER | SWT.FULL_SELECTION | SWT.H_SCROLL | SWT.V_SCROLL);
		tableViewer.setColumnProperties(new String[] { "File Name", "Model Version" });

		Table table = tableViewer.getTable();
		table.setLinesVisible(true);
		table.setHeaderVisible(true);

		TableViewerColumn filenameColumn = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn column = filenameColumn.getColumn();
		column.setText("File Name");
		filenameColumn.setLabelProvider(new CellLabelProvider() {

			@Override
			public void update(final ViewerCell cell) {
				Object element = cell.getElement();
				if (element instanceof MigrationInputFile
						&& ((MigrationInputFile) element).isVersionDifferent()) {
					cell.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_RED));
				}
			}
		});

		tableColumnLayout.setColumnData(column, new ColumnWeightData(75, true));

		TableViewerColumn modelVersionColumn = new TableViewerColumn(tableViewer, SWT.NONE);
		column = modelVersionColumn.getColumn();
		column.setText("Model Version");
		tableColumnLayout.setColumnData(column, new ColumnWeightData(25, true));

		MigrationVersionErrorDataProvider dataProvider = new MigrationVersionErrorDataProvider();
		tableViewer.setContentProvider(dataProvider);
		tableViewer.setLabelProvider(dataProvider);
		tableViewer.setInput(this.migrationSettings.getMigModelFiles());

		return tableComposite;
	}

}
