/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualization.hw;

import java.io.File;
import javax.inject.Named;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualizationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(VisualizationHandler.class);

    @Execute
    public void execute(Shell shell, UISynchronize sync, @Optional @Preference(nodePath="net.sourceforge.plantuml.eclipse", value="graphvizPath") String dotPath, @Named(value="org.eclipse.ui.selection") IStructuredSelection selection) {
        if (!selection.isEmpty() && !(selection.getFirstElement() instanceof HWModel)) {
            LOGGER.info("No HWModel selected!");
            return;
        }
        HWModel hwModel = (HWModel)selection.getFirstElement();
        DiagramResource diagramResource = this.getDiagramResource(hwModel);
        this.execute(shell, sync, dotPath, hwModel, diagramResource, true, null);
    }

    public void execute(Shell shell, UISynchronize sync, String dotPath, HWModel hwModel, DiagramResource diagramResource, boolean showSuccessInfo, IJobChangeListener listener) {
        if (dotPath == null || dotPath.equals("")) {
            this.showErrorDialog(shell, sync, "Missing Graphviz dot.exe location.\nPlease specify location via Window - Preferences - PlantUML - Path to the dot executable of Graphviz.");
            return;
        }
        File dotFile = new File(dotPath);
        if (!dotFile.canExecute()) {
            this.showErrorDialog(shell, sync, "Invalid Graphviz dot.exe location: " + dotFile.getAbsolutePath() + "\nPlease set location via Window - Preferences - PlantUML - Path to the dot executable of Graphviz.");
            return;
        }
        System.setProperty("GRAPHVIZ_DOT", dotFile.getAbsolutePath());
        LOGGER.info("GRAPHVIZ_DOT: " + System.getProperty("GRAPHVIZ_DOT"));
        Job job = Job.create((String)"Generate diagram", monitor -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        if (listener != null) {
            job.addJobChangeListener(listener);
        }
        job.schedule();
    }

    public DiagramResource getDiagramResource(HWModel hwModel) {
        Resource eResource = hwModel.eResource();
        if (eResource == null) {
            return null;
        }
        URI uri = eResource.getURI();
        Path path = new Path(uri.toPlatformString(true));
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        IContainer parentFolder = file.getParent();
        if (parentFolder == null) {
            return null;
        }
        IFolder folder = parentFolder.getFolder((IPath)new Path("hwModelVisualization"));
        if (!folder.exists()) {
            try {
                folder.create(0, true, null);
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        String absPath = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + folder.getFullPath().toString();
        String diagramFileName = "Diagram.svg";
        String plantumlFileName = "Diagram_Description.plantuml";
        String amaltheaModelName = file.getName();
        if (amaltheaModelName != null) {
            amaltheaModelName = amaltheaModelName.replaceFirst("[.][^.]+$", "");
            diagramFileName = String.valueOf(amaltheaModelName) + ".svg";
            plantumlFileName = String.valueOf(amaltheaModelName) + ".plantuml";
        }
        String plantumlFilePath = String.valueOf(absPath) + "/" + plantumlFileName;
        String diagramFilePath = String.valueOf(absPath) + "/" + diagramFileName;
        LOGGER.info("Generate plantUML file {} and SVG file {}", (Object)plantumlFilePath, (Object)diagramFilePath);
        return new DiagramResource(folder, plantumlFilePath, diagramFilePath);
    }

    private void showInfoDialog(Shell shell, UISynchronize sync, String message) {
        sync.asyncExec(() -> MessageDialog.openInformation((Shell)shell, (String)"AMALTHEA HW Visualization", (String)message));
    }

    private void showErrorDialog(Shell shell, UISynchronize sync, String message) {
        sync.asyncExec(() -> MessageDialog.openError((Shell)shell, (String)"AMALTHEA HW Visualization", (String)message));
    }

    public static class DiagramResource {
        public final IFolder diagramFolder;
        public final String plantUmlFilePath;
        public final String diagramFilePath;

        public DiagramResource(IFolder diagramFolder, String plantUmlFilePath, String diagramFilePath) {
            this.diagramFolder = diagramFolder;
            this.plantUmlFilePath = plantUmlFilePath;
            this.diagramFilePath = diagramFilePath;
        }
    }
}

