/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.headless.app;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.service.command.Descriptor;
import org.apache.felix.service.command.Parameter;
import org.eclipse.app4mc.amalthea.converters.common.MigrationException;
import org.eclipse.app4mc.amalthea.converters.common.MigrationHelper;
import org.eclipse.app4mc.amalthea.converters.common.MigrationInputFile;
import org.eclipse.app4mc.amalthea.converters.common.MigrationProcessor;
import org.eclipse.app4mc.amalthea.converters.common.MigrationSettings;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"osgi.command.scope:String=app4mc", "osgi.command.function:String=convert"}, service={ModelMigrationCommand.class})
public class ModelMigrationCommand {
    @Reference
    MigrationProcessor migrationProcessor;

    @Descriptor(value="Start an APP4MC AMALTHEA model migration")
    public void convert(@Descriptor(value="The model version to which the model should be migrated to") @Parameter(absentValue="latest", names={"-v", "--version"}) String modelVersion, @Descriptor(value="true/false whether the migration should be performed recursive on the provided folder or not (default=false)") @Parameter(absentValue="false", names={"-r", "--recursive"}) boolean recursive, @Descriptor(value="true/false whether the backup files per model file should be created or not (default=false)") @Parameter(absentValue="false", names={"-nb", "--nobackup"}) boolean noBackup, @Descriptor(value="The filename of the model file or the folder that contains model files to migrate") String filename) {
        Path modelFilePath = Paths.get(filename, new String[0]).toAbsolutePath();
        if (!Files.exists(modelFilePath, new LinkOption[0])) {
            System.err.println("Model file or folder \"" + filename + "\" does not exist!");
            return;
        }
        String outputModelVersion = ModelVersion.getLatestVersion();
        if (!"latest".equals(modelVersion)) {
            ModelVersion version = ModelVersion.getModelVersion((String)modelVersion);
            if (version != null) {
                outputModelVersion = modelVersion;
            } else {
                System.err.println("Migration model version " + modelVersion + "is invalid");
                return;
            }
        }
        if (Files.isDirectory(modelFilePath, new LinkOption[0])) {
            this.convertDirectory(modelFilePath, outputModelVersion, recursive, noBackup);
        } else if (modelFilePath.toString().toLowerCase().endsWith(".amxmi")) {
            MigrationSettings migrationSettings = new MigrationSettings();
            migrationSettings.setProject(modelFilePath.getParent().toFile());
            migrationSettings.setMigrationModelVersion(outputModelVersion);
            this.convert(Arrays.asList(modelFilePath.toFile()), migrationSettings, noBackup);
        } else {
            System.err.println("Given parameter \"" + filename + "\" is neither a directory nor a model file!");
        }
    }

    private void convertDirectory(Path modelFilePath, String outputModelVersion, boolean recursive, boolean noBackup) {
        Stream<Path> directoryStream;
        Object var6_10;
        try {
            Throwable throwable = null;
            var6_10 = null;
            try {
                directoryStream = Files.walk(modelFilePath, 1, new FileVisitOption[0]);
                try {
                    List<File> modelFiles = directoryStream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(file -> file.toString().toLowerCase().endsWith(".amxmi")).map(Path::toFile).collect(Collectors.toList());
                    if (!modelFiles.isEmpty()) {
                        MigrationSettings migrationSettings = new MigrationSettings();
                        migrationSettings.setProject(modelFilePath.toFile());
                        migrationSettings.setMigrationModelVersion(outputModelVersion);
                        this.convert(modelFiles, migrationSettings, noBackup);
                    }
                }
                finally {
                    if (directoryStream != null) {
                        directoryStream.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load model files");
            e.printStackTrace();
            return;
        }
        if (recursive) {
            try {
                Throwable e = null;
                var6_10 = null;
                try {
                    directoryStream = Files.walk(modelFilePath, 1, new FileVisitOption[0]);
                    try {
                        List modelDirectories = directoryStream.filter(path -> Files.isDirectory(path, new LinkOption[0])).filter(file -> {
                            try {
                                return !Files.isSameFile(file, modelFilePath);
                            }
                            catch (IOException e) {
                                return false;
                            }
                        }).collect(Collectors.toList());
                        for (Path path2 : modelDirectories) {
                            this.convertDirectory(path2, outputModelVersion, recursive, noBackup);
                        }
                    }
                    finally {
                        if (directoryStream != null) {
                            directoryStream.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                System.err.println("Failed to load model files");
                e.printStackTrace();
                return;
            }
        }
    }

    private void convert(List<File> inputFiles, MigrationSettings migrationSettings, boolean noBackup) {
        try {
            Map modelFilesMap = MigrationHelper.populateModels(inputFiles, (MigrationSettings)migrationSettings);
            migrationSettings.getMigModelFiles().addAll(modelFilesMap.values());
        }
        catch (Exception e) {
            System.err.println("Failed to load model files");
            e.printStackTrace();
            return;
        }
        try {
            boolean inputValid = MigrationHelper.isInputModelVersionValid((MigrationSettings)migrationSettings);
            if (!inputValid) {
                System.err.println("Model migration stopped in " + migrationSettings.getOutputDirectoryLocation() + " as selected model files belong to different versions");
                return;
            }
            if (migrationSettings.getInputModelVersion() != null && ModelVersion.getLatestVersion().equals(migrationSettings.getInputModelVersion())) {
                System.out.println("Selected models are compatible to latest AMALTHEA meta-model version (" + ModelVersion.getLatestVersion() + ")\nIt is not required to migrate the models in " + migrationSettings.getOutputDirectoryLocation());
                return;
            }
            Map migStepEntries = MigrationHelper.generateMigrationSteps((String)migrationSettings.getInputModelVersion(), (String)migrationSettings.getMigrationModelVersion());
            if (migStepEntries.size() == 0) {
                System.err.println("Migration not supported for the selected model versions. \nInput Model version : \"" + migrationSettings.getInputModelVersion() + "\" Output Model Version : \"" + migrationSettings.getMigrationModelVersion() + "\"");
                return;
            }
            MigrationInputFile migrationInputFile = (MigrationInputFile)migrationSettings.getMigModelFiles().get(0);
            migrationSettings.setOutputDirectoryLocation(migrationInputFile.getFile().getParent());
            boolean backupSucceeded = true;
            if (!noBackup) {
                for (MigrationInputFile input : migrationSettings.getMigModelFiles()) {
                    backupSucceeded = MigrationHelper.createBackupFile((MigrationInputFile)input);
                }
            }
            if (backupSucceeded) {
                int result = this.migrationProcessor.execute(migrationSettings, null);
                switch (result) {
                    case 20: {
                        System.err.println("Migration in " + migrationSettings.getOutputDirectoryLocation() + " not supported for the selected model versions. \nInput Model version : \"" + migrationSettings.getInputModelVersion() + "\" Output Model Version : \"" + migrationSettings.getMigrationModelVersion() + "\"");
                        break;
                    }
                    case 30: {
                        System.err.println("Error during migration in " + migrationSettings.getOutputDirectoryLocation());
                        break;
                    }
                    default: {
                        System.out.println("Model Migration in " + migrationSettings.getOutputDirectoryLocation() + " successful !!");
                        break;
                    }
                }
            } else {
                System.err.println("Migration Stopped : Source files could not be backed up before migration in " + migrationSettings.getOutputDirectoryLocation());
            }
        }
        catch (MigrationException e) {
            System.err.println("Error during migration in " + migrationSettings.getOutputDirectoryLocation() + ": " + e.getLocalizedMessage());
        }
    }
}

