/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.sphinx.ui.editors.wizards;

import java.util.Collection;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.wizards.CreateNewAmaltheaModelFileJob;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.workspace.ui.wizards.AbstractNewModelFileWizard;
import org.eclipse.sphinx.emf.workspace.ui.wizards.pages.InitialModelProperties;
import org.eclipse.sphinx.emf.workspace.ui.wizards.pages.NewModelFileCreationPage;
import org.eclipse.swt.widgets.Composite;

public class AmaltheaModelCreationWizard
extends AbstractNewModelFileWizard<IMetaModelDescriptor> {
    private final InitialModelProperties<IMetaModelDescriptor> properties = new InitialModelProperties();
    private static final String AMALTHEA_MODEL_ID = "org.eclipse.app4mc.amalthea.model";
    private boolean isRequiredDataFound = false;
    private NewModelFileCreationPage<IMetaModelDescriptor> newModelFileCreationPage;

    public void addPages() {
        this.fillRequiredData();
        if (this.properties.getMetaModelDescriptor() != null && this.properties.getRootObjectEClassifier() != null && this.properties.getRootObjectEClassifier() != null) {
            this.isRequiredDataFound = true;
        }
        super.addPages();
    }

    public void setWindowTitle(String newTitle) {
        super.setWindowTitle("Model Creation Wizard");
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.newModelFileCreationPage.setTitle("AMALTHEA Model");
        this.newModelFileCreationPage.setDescription("Create new file");
    }

    private void fillRequiredData() {
        List descriptors = MetaModelDescriptorRegistry.INSTANCE.getDescriptors(MetaModelDescriptorRegistry.ANY_MM, true);
        for (IMetaModelDescriptor iMetaModelDescriptor : descriptors) {
            String identifier = iMetaModelDescriptor.getIdentifier();
            if (!identifier.equals(AMALTHEA_MODEL_ID)) continue;
            this.properties.setMetaModelDescriptor(iMetaModelDescriptor);
            Collection ePackages = iMetaModelDescriptor.getEPackages();
            if (ePackages.size() <= 0) break;
            EPackage rootObjectEPackage = (EPackage)ePackages.toArray()[0];
            this.properties.setRootObjectEPackage(rootObjectEPackage);
            EClassifier eClassifier = rootObjectEPackage.getEClassifier(Amalthea.class.getSimpleName());
            if (eClassifier == null) break;
            this.properties.setRootObjectEClassifier(eClassifier);
            break;
        }
    }

    protected NewModelFileCreationPage<IMetaModelDescriptor> createMainPage() {
        this.newModelFileCreationPage = new NewModelFileCreationPage("amaltheaModelCreationPageID", this.selection, this.properties);
        return this.newModelFileCreationPage;
    }

    protected Job createCreateNewModelFileJob(String jobToCreateFile, IFile newModelFile) {
        IMetaModelDescriptor metaModelDescriptor = this.properties.getMetaModelDescriptor();
        EPackage rootObjectEPackage = this.properties.getRootObjectEPackage();
        EClassifier rootObjectEClassifier = this.properties.getRootObjectEClassifier();
        return new CreateNewAmaltheaModelFileJob(jobToCreateFile, newModelFile, metaModelDescriptor, rootObjectEPackage, rootObjectEClassifier);
    }

    public boolean canFinish() {
        if (!this.isRequiredDataFound) {
            String metaModelDescriptor = this.properties.getMetaModelDescriptor() == null ? "MetaModelDescriptor (org.eclipse.app4mc.amalthea.model), " : "";
            String ePackage = this.properties.getRootObjectEPackage() == null ? "EPackage (model), " : "";
            String eClass = this.properties.getRootObjectEClassifier() == null ? "EClass (Amalthea)" : "";
            this.newModelFileCreationPage.setErrorMessage("AMALTHEA Metamodel description is incomplete. \n Following properties are not found: " + metaModelDescriptor + ePackage + eClass);
            return false;
        }
        return super.canFinish();
    }
}

