/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.eclipse.app4mc.amalthea.converters.common.MigrationException;
import org.eclipse.app4mc.amalthea.converters.common.MigrationInputFile;
import org.eclipse.app4mc.amalthea.converters.common.MigrationSettings;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigrationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationHelper.class);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private MigrationHelper() {
    }

    public static Map<File, MigrationInputFile> populateModels(List<File> inputModelFiles, MigrationSettings migrationSettings) throws Exception {
        HashMap<File, MigrationInputFile> modelFilesMap = new HashMap<File, MigrationInputFile>();
        for (File inputFile : inputModelFiles) {
            MigrationInputFile migModelFile = new MigrationInputFile();
            migModelFile.setFile(inputFile.getCanonicalFile(), migrationSettings.getProject());
            migModelFile.setSelectedFile(inputModelFiles.contains(inputFile));
            migModelFile.setModelVersion(MigrationHelper.getModelVersion(inputFile));
            modelFilesMap.put(inputFile, migModelFile);
        }
        return modelFilesMap;
    }

    public static void saveFiles(MigrationSettings settings) throws IOException {
        Set<File> keySet = settings.getMigModelFilesMap().keySet();
        boolean updateFileNames = false;
        if (settings.getInputModelVersion().equals("itea.103") || settings.getInputModelVersion().equals("itea.110")) {
            List<String> allVersions = ModelVersion.getAllSupportedVersions();
            if (!settings.getMigrationModelVersion().equals("itea.103") && !settings.getMigrationModelVersion().equals("itea.110") && allVersions.contains(settings.getMigrationModelVersion())) {
                updateFileNames = true;
            }
        }
        for (File inputFile : keySet) {
            String location;
            int indexOfDot;
            String extension;
            String outputDirectoryLocation = settings.getOutputDirectoryLocation();
            String convertedFileName = inputFile.getName();
            if (updateFileNames && (extension = convertedFileName.substring((indexOfDot = convertedFileName.lastIndexOf(".")) + 1)).startsWith("amxmi") && !extension.equals("amxmi")) {
                convertedFileName = String.valueOf(convertedFileName) + ".amxmi";
            }
            File outputFile = null;
            if (outputDirectoryLocation != null && !outputDirectoryLocation.equals("")) {
                location = String.valueOf(outputDirectoryLocation) + File.separator + convertedFileName;
                HelperUtil.saveFile(settings.getMigModelFilesMap().get(inputFile), location, true, true);
                outputFile = new File(location);
            } else {
                location = String.valueOf(inputFile.getParentFile().getAbsolutePath()) + File.separator + convertedFileName;
                HelperUtil.saveFile(settings.getMigModelFilesMap().get(inputFile), location, true, true);
                outputFile = new File(location);
            }
            LOGGER.info("Migrated model file saved @ : {}", (Object)outputFile.getAbsolutePath());
        }
    }

    public static Map<String, String> generateMigrationSteps(String inputModelVersion, String outputModelVersion) {
        LinkedHashMap<String, String> migStepEntries = new LinkedHashMap<String, String>();
        List<String> versions = ModelVersion.getAllSupportedVersions();
        int inputModelVersionIndex = versions.indexOf(inputModelVersion);
        int outputModelVersionIndex = versions.indexOf(outputModelVersion);
        if (inputModelVersionIndex != -1 && outputModelVersionIndex != -1) {
            int i = inputModelVersionIndex;
            while (i <= outputModelVersionIndex && i + 1 <= outputModelVersionIndex) {
                migStepEntries.put(versions.get(i), versions.get(i + 1));
                ++i;
            }
        }
        return migStepEntries;
    }

    public static boolean isInputModelVersionValid(MigrationSettings migrationSettings) {
        List<MigrationInputFile> modelsWithLegacyVersionInfo = MigrationHelper.getInputModelsOfLegacyVersions(migrationSettings);
        List<MigrationInputFile> modelsWithInvalidVersionInfo = MigrationHelper.getModelsWithInvalidVersionInfo(migrationSettings);
        if (modelsWithLegacyVersionInfo.size() > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append("Can not migrate legacy Amalthea models of versions : itea.103 or itea.110 or itea.111");
            builder.append(LINE_SEPARATOR);
            builder.append(LINE_SEPARATOR);
            builder.append("From APP4MC 0.9.3, support for migrating legacy model versions (itea.103, itea.110, itea.111) is removed");
            builder.append(LINE_SEPARATOR);
            builder.append(LINE_SEPARATOR);
            builder.append("** Legacy model versions found for the below files ->");
            builder.append(LINE_SEPARATOR);
            builder.append(LINE_SEPARATOR);
            for (MigrationInputFile migrationFile : modelsWithInvalidVersionInfo) {
                builder.append(migrationFile.getFile().getAbsolutePath()).append(" Version: ").append(migrationFile.getModelVersion());
                builder.append(LINE_SEPARATOR);
                builder.append(" -------- > Version: ").append(migrationFile.getModelVersion());
            }
            builder.append(LINE_SEPARATOR);
            builder.append(LINE_SEPARATOR);
            builder.append("Use one of the previous version of APP4MC (till 0.9.2) for migrating these legacy Amalthea models to regular versions (0.7.0 and above)");
            throw new MigrationException(builder.toString());
        }
        if (modelsWithInvalidVersionInfo.size() > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append("Invalid model versions found for the below files ->");
            builder.append(LINE_SEPARATOR);
            builder.append(LINE_SEPARATOR);
            for (MigrationInputFile migrationFile : modelsWithInvalidVersionInfo) {
                builder.append(migrationFile.getFile().getAbsolutePath());
                builder.append(LINE_SEPARATOR);
            }
            throw new MigrationException(builder.toString());
        }
        boolean inputModelVersionEqual = true;
        String inputModelVersion = null;
        for (MigrationInputFile migModelFile : migrationSettings.getMigModelFiles()) {
            if (inputModelVersion == null) {
                inputModelVersion = migModelFile.getModelVersion();
                continue;
            }
            if (inputModelVersion.equals(migModelFile.getModelVersion())) continue;
            migModelFile.setVersionDifferent(true);
            inputModelVersionEqual = false;
        }
        if (inputModelVersionEqual) {
            migrationSettings.setInputModelVersion(inputModelVersion);
        }
        return inputModelVersionEqual;
    }

    private static List<MigrationInputFile> getInputModelsOfLegacyVersions(MigrationSettings migrationSettings) {
        ArrayList<MigrationInputFile> list = new ArrayList<MigrationInputFile>();
        for (MigrationInputFile migModelFile : migrationSettings.getMigModelFiles()) {
            String inputModelVersion = migModelFile.getModelVersion();
            if (inputModelVersion == null || !inputModelVersion.equals("itea.103") && !inputModelVersion.equals("itea.110") && !inputModelVersion.equals("itea.111")) continue;
            list.add(migModelFile);
        }
        return list;
    }

    private static List<MigrationInputFile> getModelsWithInvalidVersionInfo(MigrationSettings migrationSettings) {
        ArrayList<MigrationInputFile> list = new ArrayList<MigrationInputFile>();
        for (MigrationInputFile migModelFile : migrationSettings.getMigModelFiles()) {
            String inputModelVersion = migModelFile.getModelVersion();
            if (ModelVersion.isValidVersion(inputModelVersion)) continue;
            list.add(migModelFile);
        }
        return list;
    }

    public static boolean createBackupFile(MigrationInputFile migrationInputFile) {
        String newFileName = MigrationHelper.getBackupFileName(migrationInputFile);
        try {
            String filebackupName = String.valueOf(migrationInputFile.getFile().getParent()) + File.separator + newFileName;
            Files.copy(migrationInputFile.getFile().toPath(), new File(filebackupName).toPath(), StandardCopyOption.REPLACE_EXISTING);
            LOGGER.info("Original model file saved as {}", (Object)filebackupName);
            if (new File(filebackupName).exists()) {
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static String getBackupFileName(MigrationInputFile migrationInputFile) {
        String fileName = migrationInputFile.getFile().getName();
        String newFileName = fileName.substring(0, fileName.lastIndexOf("."));
        String suffixString = "_" + migrationInputFile.getModelVersion();
        String fileExtension = ".amxmi";
        newFileName = String.valueOf(newFileName) + suffixString + fileExtension;
        if (new File(String.valueOf(migrationInputFile.getFile().getParent()) + File.separator + newFileName).exists()) {
            newFileName = newFileName.replace(String.valueOf(suffixString) + fileExtension, String.valueOf(suffixString) + suffixString + fileExtension);
        }
        return newFileName;
    }

    public static String getModelVersion(File inputModelFile) {
        String result = "";
        if (inputModelFile != null && inputModelFile.exists() && inputModelFile.getName().endsWith(".amxmi")) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileInputStream input = new FileInputStream(inputModelFile);){
                    XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
                    XMLEventReader reader = xmlInputFactory.createXMLEventReader(input);
                    while (reader.hasNext()) {
                        StartElement startElement;
                        XMLEvent nextEvent = reader.nextEvent();
                        if (!nextEvent.isStartElement() || !"am".equals((startElement = nextEvent.asStartElement()).getName().getPrefix())) continue;
                        String url = startElement.getNamespaceURI("am");
                        Namespace namespace = Namespace.getNamespace((String)"am", (String)url);
                        ModelVersion version = AmaltheaNamespaceRegistry.getModelVersion(namespace);
                        result = version != null ? version.getVersion() : "invalid";
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | XMLStreamException e) {
                LOGGER.error("Error on parsing input model file for model version", (Throwable)e);
                result = "invalid";
            }
        }
        return result;
    }
}

