/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.validation.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.app4mc.validation.core.IProfile;
import org.eclipse.app4mc.validation.util.CachedProfile;
import org.eclipse.app4mc.validation.util.ProfileManager;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.jface.dialogs.IDialogSettings;

public class ProfileDialogSettings {
    private final String KEY_SELECTED_PROFILE_CLASSES = "Validation_SelectedProfileClasses";
    private Set<String> selectedProfileClassNames = new HashSet<String>();
    boolean dialogSuccess = false;
    public List<Class<? extends IProfile>> dialogResults = null;
    private ProfileManager profileManager;

    @Inject
    @Optional
    public void setProfileManager(@Service ProfileManager manager) {
        this.profileManager = manager;
    }

    public Object[] getProfiles() {
        return this.profileManager.getRegisteredValidationProfiles().values().stream().sorted((p1, p2) -> p1.getName().compareTo(p2.getName())).toArray();
    }

    public CachedProfile[] getSelectedProfiles() {
        ArrayList<CachedProfile> allNodes = new ArrayList<CachedProfile>();
        for (CachedProfile rootNode : this.profileManager.getRegisteredValidationProfiles().values()) {
            allNodes.add(rootNode);
            this.collectSubNodes(rootNode, allNodes);
        }
        return (CachedProfile[])allNodes.stream().filter(cache -> this.selectedProfileClassNames.contains(cache.getProfileClass().getName())).toArray(CachedProfile[]::new);
    }

    private void collectSubNodes(CachedProfile profile, List<CachedProfile> list) {
        if (!profile.getCachedProfiles().isEmpty()) {
            for (CachedProfile subProfile : profile.getCachedProfiles().values()) {
                list.add(subProfile);
                this.collectSubNodes(subProfile, list);
            }
        }
    }

    public void setSelectedProfileClassNames(List<String> classNames) {
        this.selectedProfileClassNames.clear();
        this.selectedProfileClassNames.addAll(classNames);
    }

    public void loadFrom(IDialogSettings store) {
        if (store == null) {
            return;
        }
        String[] classNames = store.getArray("Validation_SelectedProfileClasses");
        if (classNames != null) {
            this.setSelectedProfileClassNames(Arrays.asList(classNames));
        }
    }

    public void saveTo(IDialogSettings store) {
        if (store == null) {
            return;
        }
        if (!this.dialogSuccess || this.dialogResults == null) {
            return;
        }
        String[] classNames = (String[])this.dialogResults.stream().map(cls -> cls.getName()).toArray(String[]::new);
        store.put("Validation_SelectedProfileClasses", classNames);
    }
}

