/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.workflow.core;

import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.workflow.core.Context;
import org.eclipse.app4mc.amalthea.workflow.core.exception.ConfigurationException;
import org.eclipse.app4mc.amalthea.workflow.core.exception.WorkflowException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class WorkflowComponent {
    protected static final String AMALTHEA_SLOT = "amalthea";
    protected Logger log;
    private String modelSlot = "amalthea";

    public WorkflowComponent() {
        this.log = Logger.getLogger(this.getClass());
    }

    public WorkflowComponent(Logger log) {
        this.log = log;
    }

    public void run(Context ctx) throws WorkflowException {
        this.log.info((Object)"Starting...");
        this.checkInternal();
        this.runInternal(ctx);
        this.log.info((Object)"Finished!");
    }

    protected void checkInternal() throws ConfigurationException {
        this.log.info((Object)"checkInternal not implemented yet!");
    }

    protected abstract void runInternal(Context var1) throws WorkflowException;

    protected Amalthea getAmaltheaModel(Context ctx) {
        if (ctx.get(this.getModelSlot()) == null) {
            this.log.debug((Object)("Empty model initialized for slot " + this.getModelSlot()));
            ctx.set(this.getModelSlot(), AmaltheaFactory.eINSTANCE.createAmalthea());
        }
        return (Amalthea)ctx.get(this.getModelSlot());
    }

    protected Amalthea getAmaltheaModelCopy(Context ctx) {
        return (Amalthea)EcoreUtil.copy((EObject)this.getAmaltheaModel(ctx));
    }

    protected void setAmaltheaModel(Context ctx, Amalthea model) {
        ctx.set(this.getModelSlot(), model);
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public String getModelSlot() {
        return this.modelSlot;
    }

    public void setModelSlot(String modelSlot) {
        this.modelSlot = modelSlot;
    }
}

