/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.standard;

import java.util.ArrayList;
import java.util.List;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.AreaChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.math3.distribution.BetaDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.WeibullDistribution;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.ITimeDeviation;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeBetaDistribution;
import org.eclipse.app4mc.amalthea.model.TimeBoundaries;
import org.eclipse.app4mc.amalthea.model.TimeConstant;
import org.eclipse.app4mc.amalthea.model.TimeGaussDistribution;
import org.eclipse.app4mc.amalthea.model.TimeHistogram;
import org.eclipse.app4mc.amalthea.model.TimeHistogramEntry;
import org.eclipse.app4mc.amalthea.model.TimeInterval;
import org.eclipse.app4mc.amalthea.model.TimeStatistics;
import org.eclipse.app4mc.amalthea.model.TimeUniformDistribution;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.TimeWeibullEstimatorsDistribution;
import org.eclipse.app4mc.amalthea.model.util.WeibullUtil;
import org.eclipse.app4mc.amalthea.visualizations.standard.AbstractDeviationChart;
import org.eclipse.app4mc.visualization.ui.registry.Visualization;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.component.annotations.Component;

@Component(property={"name=Probability Density Diagram (time values)", "description=Visualize the Probability Density Function (PDF) of the deviation"})
public class DeviationChartTime
extends AbstractDeviationChart
implements Visualization {
    @PostConstruct
    public void createVisualization(ITimeDeviation dev, Composite parent) {
        Double upperBound;
        parent.setLayout((Layout)new GridLayout());
        FXCanvas canvas = new FXCanvas(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)canvas);
        BorderPane layout = new BorderPane();
        layout.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)}));
        Scene scene = new Scene((Parent)layout);
        canvas.setScene(scene);
        if (!this.isValid(dev)) {
            Label output = new Label();
            output.setText("Invalid input");
            layout.setCenter((Node)output);
            return;
        }
        TimeUnit commonUnit = this.getCommonUnit(dev);
        if (commonUnit == null) {
            commonUnit = TimeUnit.MS;
        }
        Double lowerBound = dev.getLowerBound() != null ? Double.valueOf(this.scaleTo(dev.getLowerBound(), commonUnit)) : null;
        Double d = upperBound = dev.getUpperBound() != null ? Double.valueOf(this.scaleTo(dev.getUpperBound(), commonUnit)) : null;
        if (this.isSinglePeek(lowerBound, upperBound)) {
            AreaChart<Number, Number> chart = this.createChart((EObject)dev, null);
            this.setChartXBounds(chart, lowerBound - 5.0, upperBound + 5.0);
            this.setChartYBounds(chart, 100.0);
            this.addSinglePeek(chart, 80.0, lowerBound);
            layout.setCenter(chart);
            return;
        }
        AreaChart<Number, Number> chart = this.createChart((EObject)dev, commonUnit.getName());
        if (lowerBound != null && upperBound != null && lowerBound < upperBound) {
            double margin = 0.25 * (upperBound - lowerBound);
            double xMin = lowerBound - margin;
            double xMax = upperBound + margin;
            this.setChartXBounds(chart, xMin, xMax);
        }
        if (dev instanceof TimeHistogram) {
            this.fillChart(chart, (TimeHistogram)dev, commonUnit);
        } else if (dev instanceof TimeGaussDistribution) {
            this.fillChart(chart, (TimeGaussDistribution)dev, commonUnit);
        } else if (dev instanceof TimeBoundaries) {
            this.fillChart(chart, (TimeBoundaries)dev, commonUnit);
        } else if (dev instanceof TimeStatistics) {
            this.fillChart(chart, (TimeStatistics)dev, commonUnit);
        } else if (dev instanceof TimeUniformDistribution) {
            this.fillChart(chart, (TimeUniformDistribution)dev, commonUnit);
        } else if (dev instanceof TimeBetaDistribution) {
            this.fillChart(chart, (TimeBetaDistribution)dev, commonUnit);
        } else if (dev instanceof TimeWeibullEstimatorsDistribution) {
            this.fillChart(chart, (TimeWeibullEstimatorsDistribution)dev, commonUnit);
        }
        layout.setCenter(chart);
    }

    @PreDestroy
    public void dispose() {
        System.out.println("Destroy resources");
    }

    private TimeUnit getCommonUnit(ITimeDeviation dev) {
        if (dev instanceof TimeConstant) {
            return ((TimeConstant)dev).getValue().getUnit();
        }
        if (dev instanceof TimeHistogram) {
            ArrayList<Time> list = new ArrayList<Time>();
            for (TimeHistogramEntry entry : ((TimeHistogram)dev).getEntries()) {
                list.add(entry.getLowerBound());
                list.add(entry.getUpperBound());
            }
            return this.getCommonUnit(list);
        }
        if (dev instanceof TimeInterval) {
            TimeInterval interval = (TimeInterval)dev;
            ArrayList<Time> list = new ArrayList<Time>();
            list.add(interval.getLowerBound());
            list.add(interval.getUpperBound());
            Time average = this.getAverage(interval);
            if (average != null) {
                list.add(average);
            }
            return this.getCommonUnit(list);
        }
        if (dev instanceof TimeGaussDistribution) {
            TimeGaussDistribution gauss = (TimeGaussDistribution)dev;
            ArrayList<Time> list = new ArrayList<Time>();
            list.add(gauss.getMean());
            list.add(gauss.getSd());
            return this.getCommonUnit(list);
        }
        return null;
    }

    private TimeUnit getCommonUnit(List<Time> times) {
        List units = AmaltheaServices.TIME_UNIT_LIST;
        int minIndex = units.size() - 1;
        for (Time time : times) {
            int index = units.indexOf(time.getUnit());
            if (index >= minIndex) continue;
            minIndex = index;
        }
        return (TimeUnit)units.get(minIndex);
    }

    private double scaleTo(Time time, TimeUnit unit) {
        List units = AmaltheaServices.TIME_UNIT_LIST;
        int power = units.indexOf(time.getUnit()) - units.indexOf(unit);
        double factor = Math.pow(1000.0, power);
        return time.getValue().doubleValue() * factor;
    }

    private void fillChart(AreaChart<Number, Number> chart, TimeHistogram histogram, TimeUnit commonUnit) {
        long maxY = 0L;
        for (TimeHistogramEntry entry : histogram.getEntries()) {
            double lower = this.scaleTo(entry.getLowerBound(), commonUnit);
            double upper = this.scaleTo(entry.getUpperBound(), commonUnit);
            long occur = entry.getOccurrences();
            maxY = Math.max(occur, maxY);
            XYChart.Series series = new XYChart.Series();
            series.getData().add((Object)new XYChart.Data((Object)lower, (Object)0L));
            series.getData().add((Object)new XYChart.Data((Object)lower, (Object)occur));
            series.getData().add((Object)new XYChart.Data((Object)upper, (Object)occur));
            series.getData().add((Object)new XYChart.Data((Object)upper, (Object)0L));
            this.addSeriesStandard(chart, (XYChart.Series<Number, Number>)series);
        }
        this.setChartYBounds(chart, (double)maxY * 1.2);
        this.addMarkers(chart, (double)maxY * 1.1, this.scaleTo(histogram.getLowerBound(), commonUnit), this.scaleTo(histogram.getAverage(), commonUnit), this.scaleTo(histogram.getUpperBound(), commonUnit));
    }

    private void fillChart(AreaChart<Number, Number> chart, TimeGaussDistribution dev, TimeUnit commonUnit) {
        double maxY = 0.0;
        double mean = this.scaleTo(dev.getMean(), commonUnit);
        double sd = this.scaleTo(dev.getSd(), commonUnit);
        Double lowerBound = dev.getLowerBound() != null ? Double.valueOf(this.scaleTo(dev.getLowerBound(), commonUnit)) : null;
        Double upperBound = dev.getUpperBound() != null ? Double.valueOf(this.scaleTo(dev.getUpperBound(), commonUnit)) : null;
        double average = this.scaleTo(dev.getAverage(), commonUnit);
        double xMin = mean - 4.0 * sd;
        double xMax = mean + 4.0 * sd;
        if (lowerBound != null && upperBound != null && lowerBound < upperBound) {
            double margin = 0.25 * (upperBound - lowerBound);
            xMin = lowerBound - margin;
            xMax = upperBound + margin;
        } else {
            if (lowerBound != null) {
                xMin = lowerBound - sd;
            }
            if (upperBound != null) {
                xMax = upperBound + sd;
            }
        }
        double step = (xMax - xMin) / 200.0;
        NormalDistribution mathFunction = new NormalDistribution(null, mean, sd);
        XYChart.Series seriesMain = new XYChart.Series();
        XYChart.Series seriesLeft = new XYChart.Series();
        XYChart.Series seriesRight = new XYChart.Series();
        double x = xMin;
        while (x <= xMax) {
            double y = mathFunction.density(x);
            maxY = Math.max(y, maxY);
            if (lowerBound != null && x < lowerBound) {
                seriesLeft.getData().add((Object)new XYChart.Data((Object)x, (Object)y));
            } else if (upperBound != null && x > upperBound) {
                seriesRight.getData().add((Object)new XYChart.Data((Object)x, (Object)y));
            } else {
                seriesMain.getData().add((Object)new XYChart.Data((Object)x, (Object)y));
            }
            x += step;
        }
        this.addSeriesOffLimit(chart, (XYChart.Series<Number, Number>)seriesLeft);
        this.addSeriesOffLimit(chart, (XYChart.Series<Number, Number>)seriesRight);
        this.addSeriesStandard(chart, (XYChart.Series<Number, Number>)seriesMain);
        this.setChartXBounds(chart, xMin, xMax);
        this.setChartYBounds(chart, maxY * 1.2);
        this.addMarkers(chart, maxY * 1.1, lowerBound, average, upperBound);
    }

    private void fillChart(AreaChart<Number, Number> chart, TimeBoundaries dev, TimeUnit commonUnit) {
        double lower = this.scaleTo(dev.getLowerBound(), commonUnit);
        double upper = this.scaleTo(dev.getUpperBound(), commonUnit);
        XYChart.Series series = new XYChart.Series();
        series.getData().add((Object)new XYChart.Data((Object)lower, (Object)60));
        series.getData().add((Object)new XYChart.Data((Object)upper, (Object)60));
        this.addSeriesGradient(chart, (XYChart.Series<Number, Number>)series);
        this.setChartYBounds(chart, 100.0);
        this.addMarkers(chart, 80.0, lower, null, upper);
    }

    private void fillChart(AreaChart<Number, Number> chart, TimeStatistics dev, TimeUnit commonUnit) {
        double maxY = 0.0;
        double lower = this.scaleTo(dev.getLowerBound(), commonUnit);
        double upper = this.scaleTo(dev.getUpperBound(), commonUnit);
        double average = this.scaleTo(dev.getAverage(), commonUnit);
        if (lower < upper) {
            double y1 = 100.0 / (average - lower);
            double y2 = 100.0 / (upper - average);
            maxY = Math.max(y1, y2);
            XYChart.Series series1 = new XYChart.Series();
            series1.getData().add((Object)new XYChart.Data((Object)lower, (Object)y1));
            series1.getData().add((Object)new XYChart.Data((Object)average, (Object)y1));
            XYChart.Series series2 = new XYChart.Series();
            series2.getData().add((Object)new XYChart.Data((Object)average, (Object)y2));
            series2.getData().add((Object)new XYChart.Data((Object)upper, (Object)y2));
            this.addSeriesGradient(chart, (XYChart.Series<Number, Number>)series1);
            this.addSeriesGradient(chart, (XYChart.Series<Number, Number>)series2);
        } else {
            maxY = 100.0;
        }
        this.setChartYBounds(chart, maxY * 1.2);
        this.addMarkers(chart, maxY * 1.1, lower, average, upper);
    }

    private void fillChart(AreaChart<Number, Number> chart, TimeUniformDistribution dev, TimeUnit commonUnit) {
        double lower = this.scaleTo(dev.getLowerBound(), commonUnit);
        double upper = this.scaleTo(dev.getUpperBound(), commonUnit);
        XYChart.Series series = new XYChart.Series();
        series.getData().add((Object)new XYChart.Data((Object)lower, (Object)60));
        series.getData().add((Object)new XYChart.Data((Object)upper, (Object)60));
        this.addSeriesStandard(chart, (XYChart.Series<Number, Number>)series);
        this.setChartYBounds(chart, 100.0);
        this.addMarkers(chart, 80.0, lower, null, upper);
    }

    private void fillChart(AreaChart<Number, Number> chart, TimeBetaDistribution dev, TimeUnit commonUnit) {
        double maxY = 0.0;
        double x1 = this.scaleTo(dev.getLowerBound(), commonUnit);
        double x2 = this.scaleTo(dev.getUpperBound(), commonUnit);
        double range = x2 - x1;
        if (range > 0.0) {
            BetaDistribution mathFunction = new BetaDistribution(null, dev.getAlpha(), dev.getBeta());
            XYChart.Series series = new XYChart.Series();
            double x = 0.005;
            while (x < 1.0) {
                double y = mathFunction.density(x);
                maxY = Math.max(y, maxY);
                series.getData().add((Object)new XYChart.Data((Object)(x1 + x * range), (Object)y));
                x += 0.005;
            }
            this.addSeriesStandard(chart, (XYChart.Series<Number, Number>)series);
        }
        this.setChartYBounds(chart, maxY * 1.2);
        this.addMarkers(chart, maxY * 1.1, x1, this.scaleTo(dev.getAverage(), commonUnit), x2);
    }

    private void fillChart(AreaChart<Number, Number> chart, TimeWeibullEstimatorsDistribution dev, TimeUnit commonUnit) {
        double maxY = 0.0;
        double lower = this.scaleTo(dev.getLowerBound(), commonUnit);
        double upper = this.scaleTo(dev.getUpperBound(), commonUnit);
        double average = this.scaleTo(dev.getAverage(), commonUnit);
        double remain = dev.getPRemainPromille();
        WeibullUtil.Parameters params = WeibullUtil.findParameters((double)lower, (double)average, (double)upper, (double)remain);
        double shape = params.shape;
        double scale = params.scale;
        if (lower < upper) {
            if (params.error == null) {
                WeibullDistribution mathFunction = new WeibullDistribution(null, shape, scale);
                XYChart.Series seriesMain = new XYChart.Series();
                XYChart.Series seriesRight = new XYChart.Series();
                double xMax = chart.getXAxis() instanceof NumberAxis ? ((ValueAxis)chart.getXAxis()).getUpperBound() : upper;
                double step = (xMax - lower) / 200.0;
                double x = lower;
                while (x <= xMax) {
                    double y = mathFunction.density(x - lower);
                    if (Double.isFinite(y)) {
                        maxY = Math.max(y, maxY);
                        if (x <= upper) {
                            seriesMain.getData().add((Object)new XYChart.Data((Object)x, (Object)y));
                        } else {
                            seriesRight.getData().add((Object)new XYChart.Data((Object)x, (Object)y));
                        }
                    }
                    x += step;
                }
                this.addSeriesStandard(chart, (XYChart.Series<Number, Number>)seriesMain);
                this.addSeriesOffLimit(chart, (XYChart.Series<Number, Number>)seriesRight);
            } else {
                maxY = 100.0;
            }
            this.setChartYBounds(chart, maxY * 1.2);
            double computedAvg = WeibullUtil.computeAverage((double)shape, (double)scale, (double)lower, (Double)upper);
            XYChart.Series series2 = new XYChart.Series();
            chart.getData().add((Object)series2);
            series2.setName("avg");
            series2.getData().add((Object)new XYChart.Data((Object)computedAvg, (Object)0));
            series2.getData().add((Object)new XYChart.Data((Object)computedAvg, (Object)(maxY / 2.0)));
            series2.getNode().lookup(".chart-series-area-line").setStyle("-fx-stroke: rgba(5, 150, 5, 1.0); -fx-stroke-dash-array: 3;");
            ((XYChart.Data)series2.getData().get(1)).getNode().setVisible(false);
            this.setChartYBounds(chart, maxY * 1.2);
            this.addMarkers(chart, maxY * 1.1, lower, average, upper);
        }
    }
}

