/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.BaseObject;
import org.eclipse.app4mc.amalthea.model.CommonElements;
import org.eclipse.app4mc.amalthea.model.ComponentsModel;
import org.eclipse.app4mc.amalthea.model.ConfigModel;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.EventModel;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.model.IAnnotatable;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.amalthea.model.MappingModel;
import org.eclipse.app4mc.amalthea.model.MeasurementModel;
import org.eclipse.app4mc.amalthea.model.MemoryAddressMappingType;
import org.eclipse.app4mc.amalthea.model.OSModel;
import org.eclipse.app4mc.amalthea.model.PropertyConstraintsModel;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.StimuliModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;

public class AmaltheaMerger {
    public static void addElements(@NonNull Amalthea mainModel, @NonNull Collection<Amalthea> inputs) {
        Preconditions.checkArgument((mainModel != null ? 1 : 0) != 0, (Object)"Model argument is null, expected: Amalthea");
        Preconditions.checkArgument((inputs != null ? 1 : 0) != 0, (Object)"Collection argument is null, expected: Collection<Amalthea>");
        if (inputs.size() == 0) {
            return;
        }
        EcoreUtil.Copier copier = new EcoreUtil.Copier(true, true);
        for (Amalthea model : inputs) {
            Amalthea tmpModel = (Amalthea)copier.copy((EObject)model);
            if (tmpModel == null) continue;
            AmaltheaMerger.addPropertiesIfAbsent(mainModel, tmpModel);
            AmaltheaMerger.addCommonElements(mainModel, tmpModel);
            AmaltheaMerger.addSwModel(mainModel, tmpModel);
            AmaltheaMerger.addHwModel(mainModel, tmpModel);
            AmaltheaMerger.addOsModel(mainModel, tmpModel);
            AmaltheaMerger.addStimuliModel(mainModel, tmpModel);
            AmaltheaMerger.addConstraintsModel(mainModel, tmpModel);
            AmaltheaMerger.addEventModel(mainModel, tmpModel);
            AmaltheaMerger.addPropertyConstraintsModel(mainModel, tmpModel);
            AmaltheaMerger.addMappingModel(mainModel, tmpModel);
            AmaltheaMerger.addComponentsModel(mainModel, tmpModel);
            AmaltheaMerger.addConfigModel(mainModel, tmpModel);
            AmaltheaMerger.addMeasurementModel(mainModel, tmpModel);
        }
        copier.copyReferences();
    }

    private static void addCommonElements(Amalthea mainModel, Amalthea tmpModel) {
        CommonElements main = mainModel.getCommonElements();
        CommonElements tmp = tmpModel.getCommonElements();
        if (tmp == null) {
            return;
        }
        if (main == null) {
            mainModel.setCommonElements(tmp);
        } else {
            AmaltheaMerger.addIfAbsent(main.getCoreClassifiers(), tmp.getCoreClassifiers());
            AmaltheaMerger.addIfAbsent(main.getMemoryClassifiers(), tmp.getMemoryClassifiers());
            AmaltheaMerger.addIfAbsent(main.getTags(), tmp.getTags());
        }
    }

    private static void addSwModel(Amalthea mainModel, Amalthea tmpModel) {
        SWModel main = mainModel.getSwModel();
        SWModel tmp = tmpModel.getSwModel();
        if (tmp == null) {
            return;
        }
        if (main == null) {
            mainModel.setSwModel(tmp);
        } else {
            AmaltheaMerger.addIfAbsent(main.getActivations(), tmp.getActivations());
            AmaltheaMerger.addIfAbsent(main.getChannels(), tmp.getChannels());
            AmaltheaMerger.addIfAbsent(main.getCustomEntities(), tmp.getCustomEntities());
            AmaltheaMerger.addIfAbsent(main.getEvents(), tmp.getEvents());
            AmaltheaMerger.addIfAbsent(main.getIsrs(), tmp.getIsrs());
            AmaltheaMerger.addIfAbsent(main.getLabels(), tmp.getLabels());
            AmaltheaMerger.addIfAbsent(main.getModeLabels(), tmp.getModeLabels());
            AmaltheaMerger.addIfAbsent(main.getModes(), tmp.getModes());
            AmaltheaMerger.addIfAbsent(main.getProcessChains(), tmp.getProcessChains());
            AmaltheaMerger.addIfAbsent(main.getProcessPrototypes(), tmp.getProcessPrototypes());
            AmaltheaMerger.addIfAbsent(main.getRunnables(), tmp.getRunnables());
            AmaltheaMerger.addIfAbsent(main.getSections(), tmp.getSections());
            AmaltheaMerger.addIfAbsent(main.getTasks(), tmp.getTasks());
            AmaltheaMerger.addIfAbsent(main.getTypeDefinitions(), tmp.getTypeDefinitions());
        }
    }

    private static void addHwModel(Amalthea mainModel, Amalthea tmpModel) {
        HWModel main = mainModel.getHwModel();
        HWModel tmp = tmpModel.getHwModel();
        if (tmp == null) {
            return;
        }
        if (main == null) {
            mainModel.setHwModel(tmp);
        } else {
            AmaltheaMerger.addIfAbsent(main.getDefinitions(), tmp.getDefinitions());
            AmaltheaMerger.addIfAbsent(main.getDomains(), tmp.getDomains());
            AmaltheaMerger.addIfAbsent(main.getFeatureCategories(), tmp.getFeatureCategories());
            AmaltheaMerger.addIfAbsent(main.getStructures(), tmp.getStructures());
        }
    }

    private static void addOsModel(Amalthea mainModel, Amalthea tmpModel) {
        OSModel main = mainModel.getOsModel();
        OSModel tmp = tmpModel.getOsModel();
        if (tmp == null) {
            return;
        }
        if (main == null) {
            mainModel.setOsModel(tmp);
        } else {
            AmaltheaMerger.addAll(main.getOperatingSystems(), tmp.getOperatingSystems());
            AmaltheaMerger.addIfAbsent(main.getOsOverheads(), tmp.getOsOverheads());
            AmaltheaMerger.addIfAbsent(main.getSemaphores(), tmp.getSemaphores());
        }
    }

    private static void addStimuliModel(Amalthea mainModel, Amalthea tmpModel) {
        StimuliModel main = mainModel.getStimuliModel();
        StimuliModel tmp = tmpModel.getStimuliModel();
        if (tmp == null) {
            return;
        }
        if (main == null) {
            mainModel.setStimuliModel(tmp);
        } else {
            AmaltheaMerger.addIfAbsent(main.getClocks(), tmp.getClocks());
            AmaltheaMerger.addIfAbsent(main.getStimuli(), tmp.getStimuli());
        }
    }

    private static void addConstraintsModel(Amalthea mainModel, Amalthea tmpModel) {
        ConstraintsModel main = mainModel.getConstraintsModel();
        ConstraintsModel tmp = tmpModel.getConstraintsModel();
        if (tmp == null) {
            return;
        }
        if (main == null) {
            mainModel.setConstraintsModel(tmp);
        } else {
            AmaltheaMerger.addAll(main.getRequirements(), tmp.getRequirements());
            AmaltheaMerger.addIfAbsent(main.getEventChains(), tmp.getEventChains());
            AmaltheaMerger.addIfAbsent(main.getTimingConstraints(), tmp.getTimingConstraints());
            AmaltheaMerger.addIfAbsent(main.getAffinityConstraints(), tmp.getAffinityConstraints());
            AmaltheaMerger.addIfAbsent(main.getRunnableSequencingConstraints(), tmp.getRunnableSequencingConstraints());
            AmaltheaMerger.addIfAbsent(main.getDataAgeConstraints(), tmp.getDataAgeConstraints());
            AmaltheaMerger.addIfAbsent(main.getDataCoherencyGroups(), tmp.getDataCoherencyGroups());
            AmaltheaMerger.addIfAbsent(main.getDataStabilityGroups(), tmp.getDataStabilityGroups());
            AmaltheaMerger.addIfAbsent(main.getPhysicalSectionConstraints(), tmp.getPhysicalSectionConstraints());
        }
    }

    private static void addEventModel(Amalthea mainModel, Amalthea tmpModel) {
        EventModel main = mainModel.getEventModel();
        EventModel tmp = tmpModel.getEventModel();
        if (tmp == null) {
            return;
        }
        if (main == null) {
            mainModel.setEventModel(tmp);
        } else {
            AmaltheaMerger.addIfAbsent(main.getEvents(), tmp.getEvents());
        }
    }

    private static void addPropertyConstraintsModel(Amalthea mainModel, Amalthea tmpModel) {
        PropertyConstraintsModel main = mainModel.getPropertyConstraintsModel();
        PropertyConstraintsModel tmp = tmpModel.getPropertyConstraintsModel();
        if (tmp == null) {
            return;
        }
        if (main == null) {
            mainModel.setPropertyConstraintsModel(tmp);
        } else {
            AmaltheaMerger.addAll(main.getAllocationConstraints(), tmp.getAllocationConstraints());
            AmaltheaMerger.addAll(main.getMappingConstraints(), tmp.getMappingConstraints());
        }
    }

    private static void addMappingModel(Amalthea mainModel, Amalthea tmpModel) {
        MappingModel main = mainModel.getMappingModel();
        MappingModel tmp = tmpModel.getMappingModel();
        if (tmp == null) {
            return;
        }
        if (main == null) {
            mainModel.setMappingModel(tmp);
        } else {
            if (main.getAddressMappingType() == MemoryAddressMappingType._UNDEFINED_) {
                main.setAddressMappingType(tmp.getAddressMappingType());
            }
            AmaltheaMerger.addAll(main.getTaskAllocation(), tmp.getTaskAllocation());
            AmaltheaMerger.addAll(main.getIsrAllocation(), tmp.getIsrAllocation());
            AmaltheaMerger.addAll(main.getRunnableAllocation(), tmp.getRunnableAllocation());
            AmaltheaMerger.addAll(main.getSchedulerAllocation(), tmp.getSchedulerAllocation());
            AmaltheaMerger.addAll(main.getMemoryMapping(), tmp.getMemoryMapping());
            AmaltheaMerger.addIfAbsent(main.getPhysicalSectionMapping(), tmp.getPhysicalSectionMapping());
        }
    }

    private static void addComponentsModel(Amalthea mainModel, Amalthea tmpModel) {
        ComponentsModel main = mainModel.getComponentsModel();
        ComponentsModel tmp = tmpModel.getComponentsModel();
        if (tmp == null) {
            return;
        }
        if (main == null) {
            mainModel.setComponentsModel(tmp);
        } else {
            AmaltheaMerger.addIfAbsent(main.getComponents(), tmp.getComponents());
            AmaltheaMerger.addIfAbsent(main.getSystems(), tmp.getSystems());
        }
    }

    private static void addConfigModel(Amalthea mainModel, Amalthea tmpModel) {
        ConfigModel main = mainModel.getConfigModel();
        ConfigModel tmp = tmpModel.getConfigModel();
        if (tmp == null) {
            return;
        }
        if (main == null) {
            mainModel.setConfigModel(tmp);
        } else {
            AmaltheaMerger.addAll(main.getEventsToTrace(), tmp.getEventsToTrace());
        }
    }

    private static void addMeasurementModel(Amalthea mainModel, Amalthea tmpModel) {
        MeasurementModel main = mainModel.getMeasurementModel();
        MeasurementModel tmp = tmpModel.getMeasurementModel();
        if (tmp == null) {
            return;
        }
        if (main == null) {
            mainModel.setMeasurementModel(tmp);
        } else {
            AmaltheaMerger.addAll(main.getMeasurements(), tmp.getMeasurements());
        }
    }

    private static <T extends BaseObject> void addAll(EList<T> main, EList<T> input) {
        if (main == null || input == null) {
            return;
        }
        main.addAll(input);
    }

    private static <T extends IReferable> void addIfAbsent(EList<T> main, EList<T> input) {
        if (main == null || input == null) {
            return;
        }
        HashSet<String> uniqueNames = new HashSet<String>();
        for (IReferable object : main) {
            if (object == null) continue;
            uniqueNames.add(object.getUniqueName());
        }
        ArrayList<IReferable> objectsToMove = new ArrayList<IReferable>();
        for (IReferable object : input) {
            if (object == null || uniqueNames.contains(object.getUniqueName())) continue;
            objectsToMove.add(object);
        }
        main.addAll(objectsToMove);
    }

    private static void addPropertiesIfAbsent(IAnnotatable main, IAnnotatable input) {
        if (main == null || input == null) {
            return;
        }
        for (Map.Entry property : input.getCustomProperties()) {
            if (main.getCustomProperties().containsKey(property.getKey())) continue;
            main.getCustomProperties().add((Object)property);
        }
    }
}

