/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.Cache;
import org.eclipse.app4mc.amalthea.model.ConnectionHandler;
import org.eclipse.app4mc.amalthea.model.DataRate;
import org.eclipse.app4mc.amalthea.model.Frequency;
import org.eclipse.app4mc.amalthea.model.HwAccessElement;
import org.eclipse.app4mc.amalthea.model.HwAccessPath;
import org.eclipse.app4mc.amalthea.model.HwConnection;
import org.eclipse.app4mc.amalthea.model.HwDestination;
import org.eclipse.app4mc.amalthea.model.HwModule;
import org.eclipse.app4mc.amalthea.model.HwPathElement;
import org.eclipse.app4mc.amalthea.model.HwStructure;
import org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation;
import org.eclipse.app4mc.amalthea.model.Memory;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.ProcessingUnitDefinition;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.util.FactoryUtil;
import org.eclipse.app4mc.amalthea.model.util.RuntimeUtil;

public class HardwareUtil {
    public static <T extends HwModule> List<T> getModulesFromHwModel(Class<T> targetClass, Amalthea model) {
        ArrayList results = new ArrayList();
        for (HwStructure structure : model.getHwModel().getStructures()) {
            HardwareUtil.collectModulesFromHWStructure(structure, targetClass, results);
        }
        return results;
    }

    public static <T extends HwModule> List<T> getModulesFromHWStructure(Class<T> targetClass, HwStructure structure) {
        ArrayList results = new ArrayList();
        HardwareUtil.collectModulesFromHWStructure(structure, targetClass, results);
        return results;
    }

    private static <T extends HwModule> void collectModulesFromHWStructure(HwStructure structure, Class<T> targetClass, List<T> results) {
        for (HwModule module : structure.getModules()) {
            if (targetClass.isInstance(module)) {
                results.add((HwModule)targetClass.cast(module));
            }
            if (!targetClass.isAssignableFrom(Cache.class) || !(module instanceof ProcessingUnit)) continue;
            for (Cache containedCache : ((ProcessingUnit)module).getCaches()) {
                if (!targetClass.isInstance(containedCache)) continue;
                results.add((HwModule)targetClass.cast(containedCache));
            }
        }
        for (HwStructure hwStruct : structure.getStructures()) {
            HardwareUtil.collectModulesFromHWStructure(hwStruct, targetClass, results);
        }
    }

    public static List<ProcessingUnit> getAllProcessingUnitsForProcessingUnitDefinition(Amalthea model, ProcessingUnitDefinition puDef) {
        if (puDef == null) {
            return new ArrayList<ProcessingUnit>();
        }
        ArrayList<ProcessingUnit> result = new ArrayList<ProcessingUnit>();
        for (ProcessingUnit pu : HardwareUtil.getModulesFromHwModel(ProcessingUnit.class, model)) {
            if (!puDef.equals(pu.getDefinition())) continue;
            result.add(pu);
        }
        return result;
    }

    public static Map<Memory, Long> getMemoryAccessLatenciesCycles(Amalthea model, RuntimeUtil.TimeType timeType) {
        HashMap<Memory, Long> result = new HashMap<Memory, Long>();
        List<Memory> mems = HardwareUtil.getModulesFromHwModel(Memory.class, model);
        for (Memory mem : mems) {
            result.put(mem, HardwareUtil.calculateLatency(mem.getDefinition().getAccessLatency(), timeType));
        }
        return result;
    }

    public static Map<Memory, Time> getMemoryAccessLatencyTime(Amalthea model, RuntimeUtil.TimeType timeType) {
        HashMap<Memory, Time> result = new HashMap<Memory, Time>();
        Map<Memory, Long> memoryMap = HardwareUtil.getMemoryAccessLatenciesCycles(model, timeType);
        for (Memory key : memoryMap.keySet()) {
            Time time = RuntimeUtil.getExecutionTimeForCycles(memoryMap.get(key).longValue(), key.getFrequencyDomain().getDefaultValue());
            result.put(key, time);
        }
        return result;
    }

    public static List<HwAccessElement> getAccessElementsToDestination(HwDestination dest, Amalthea model) {
        ArrayList<HwAccessElement> result = new ArrayList<HwAccessElement>();
        List<ProcessingUnit> pus = HardwareUtil.getModulesFromHwModel(ProcessingUnit.class, model);
        for (ProcessingUnit pu : pus) {
            for (HwAccessElement element : pu.getAccessElements()) {
                if (!element.getDestination().equals(dest)) continue;
                result.add(element);
            }
        }
        return result;
    }

    public static Map<ProcessingUnit, HashMap<HwDestination, Time>> getAccessTimes(Amalthea model, RuntimeUtil.TimeType timeType, RuntimeUtil.AccessDirection direction) {
        HashMap<ProcessingUnit, HashMap<HwDestination, Time>> coreMemoryLatency = new HashMap<ProcessingUnit, HashMap<HwDestination, Time>>();
        List<ProcessingUnit> puList = HardwareUtil.getModulesFromHwModel(ProcessingUnit.class, model);
        for (ProcessingUnit pu : puList) {
            HashMap<HwDestination, Time> memoryAccessMap = new HashMap<HwDestination, Time>();
            for (HwAccessElement accessElement : pu.getAccessElements()) {
                HwDestination destination = accessElement.getDestination();
                Time latency = null;
                latency = accessElement.getAccessPath() != null ? HardwareUtil.calculateHwAccessPathTime(accessElement, timeType, direction) : HardwareUtil.calculateLatencyPathTime(accessElement, timeType, direction);
                Time previousLatency = (Time)memoryAccessMap.get(destination);
                if (previousLatency != null && (latency == null || AmaltheaServices.compareTimes(previousLatency, latency) >= 0)) continue;
                memoryAccessMap.put(destination, latency);
            }
            coreMemoryLatency.put(pu, memoryAccessMap);
        }
        return coreMemoryLatency;
    }

    public static Time calculateLatencyPathTime(HwAccessElement accessElement, RuntimeUtil.TimeType timeType, RuntimeUtil.AccessDirection direction) {
        IDiscreteValueDeviation latency = null;
        switch (direction) {
            case READ: {
                if (accessElement.getReadLatency() == null) break;
                latency = accessElement.getReadLatency();
                break;
            }
            case WRITE: {
                if (accessElement.getWriteLatency() == null) break;
                latency = accessElement.getWriteLatency();
                break;
            }
        }
        return RuntimeUtil.getExecutionTimeForCycles(HardwareUtil.calculateLatency(latency, timeType).longValue(), accessElement.getSource().getFrequencyDomain().getDefaultValue());
    }

    public static Time calculateHwAccessPathTime(HwAccessElement accessElement, RuntimeUtil.TimeType timeType, RuntimeUtil.AccessDirection direction) {
        Time result = FactoryUtil.createTime();
        Frequency frequency = null;
        IDiscreteValueDeviation latency = null;
        if (accessElement.getAccessPath() != null) {
            for (HwPathElement element : accessElement.getAccessPath().getPathElements()) {
                if (element instanceof ConnectionHandler) {
                    latency = direction.equals((Object)RuntimeUtil.AccessDirection.READ) ? ((ConnectionHandler)element).getDefinition().getReadLatency() : ((ConnectionHandler)element).getDefinition().getWriteLatency();
                    frequency = HardwareUtil.getFrequencyOfModule((ConnectionHandler)element);
                } else if (element instanceof Cache) {
                    latency = ((Cache)element).getDefinition().getAccessLatency();
                    frequency = HardwareUtil.getFrequencyOfModule((Cache)element);
                } else if (element instanceof HwConnection) {
                    latency = direction.equals((Object)RuntimeUtil.AccessDirection.READ) ? ((HwConnection)element).getReadLatency() : ((HwConnection)element).getWriteLatency();
                    if (frequency == null) {
                        frequency = HardwareUtil.getFrequencyOfModule(accessElement.getSource());
                    }
                } else if (element instanceof ProcessingUnit) {
                    frequency = HardwareUtil.getFrequencyOfModule((ProcessingUnit)element);
                }
                Long tmpLatency = HardwareUtil.calculateLatency(latency, timeType);
                Time executionTimeForCycles = RuntimeUtil.getExecutionTimeForCycles(tmpLatency.longValue(), frequency);
                result = result.add(executionTimeForCycles);
            }
        }
        return result.adjustUnit();
    }

    public static Long calculateLatency(IDiscreteValueDeviation latency, RuntimeUtil.TimeType timeType) {
        if (latency == null) {
            return 0L;
        }
        switch (timeType) {
            case BCET: {
                return latency.getLowerBound();
            }
            case ACET: {
                return latency.getAverage() != null ? Long.valueOf(latency.getAverage().longValue()) : null;
            }
            case WCET: {
                return latency.getUpperBound();
            }
        }
        return latency.getAverage() != null ? Long.valueOf(latency.getAverage().longValue()) : null;
    }

    public static DataRate getMinDataRateOfHwAccessPath(HwAccessPath path) {
        DataRate minimum = null;
        if (path != null) {
            for (HwPathElement element : path.getPathElements()) {
                DataRate temp = null;
                if (element instanceof ConnectionHandler) {
                    temp = ((ConnectionHandler)element).getDefinition().getDataRate();
                } else if (element instanceof HwConnection) {
                    temp = ((HwConnection)element).getDataRate();
                }
                if (temp == null || minimum != null && AmaltheaServices.compareDataRates(temp, minimum) >= 0) continue;
                minimum = temp;
            }
        }
        return minimum;
    }

    public static Frequency getFrequencyOfModule(HwModule module) {
        return module.getFrequencyDomain().getDefaultValue();
    }

    public static long getFrequencyOfModuleInHz(HwModule module) {
        return AmaltheaServices.convertToHertz(HardwareUtil.getFrequencyOfModule(module)).longValue();
    }
}

