/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.ClearEvent;
import org.eclipse.app4mc.amalthea.model.ExecutionNeed;
import org.eclipse.app4mc.amalthea.model.Group;
import org.eclipse.app4mc.amalthea.model.IActivityGraphItemContainer;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.LabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.LabelAccessStatistic;
import org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.ModeSwitch;
import org.eclipse.app4mc.amalthea.model.ModeSwitchEntry;
import org.eclipse.app4mc.amalthea.model.NumericStatistic;
import org.eclipse.app4mc.amalthea.model.ProbabilitySwitch;
import org.eclipse.app4mc.amalthea.model.ProbabilitySwitchEntry;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.ServerCall;
import org.eclipse.app4mc.amalthea.model.SetEvent;
import org.eclipse.app4mc.amalthea.model.SingleValueStatistic;
import org.eclipse.app4mc.amalthea.model.Ticks;
import org.eclipse.app4mc.amalthea.model.WaitEvent;
import org.eclipse.app4mc.amalthea.model.util.RuntimeUtil;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;

public class SoftwareUtil {
    public static EList<ActivityGraphItem> collectActivityGraphItems(IActivityGraphItemContainer container) {
        return SoftwareUtil.collectActivityGraphItems(container, null, ActivityGraphItem.class, null);
    }

    public static EList<ActivityGraphItem> collectActivityGraphItems(IActivityGraphItemContainer container, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems(container, modes, ActivityGraphItem.class, null);
    }

    public static EList<ActivityGraphItem> collectActivityGraphItems(IActivityGraphItemContainer container, EMap<ModeLabel, String> modes, Function<ActivityGraphItem, Boolean> filter) {
        return SoftwareUtil.collectActivityGraphItems(container, modes, ActivityGraphItem.class, filter);
    }

    public static <T extends ActivityGraphItem> EList<T> collectActivityGraphItems(IActivityGraphItemContainer container, EMap<ModeLabel, String> modes, Class<T> targetClass) {
        return SoftwareUtil.collectActivityGraphItems(container, modes, targetClass, null);
    }

    public static <T extends ActivityGraphItem> EList<T> collectActivityGraphItems(IActivityGraphItemContainer container, EMap<ModeLabel, String> modes, Class<T> targetClass, Function<T, Boolean> filter) {
        BasicEList itemList = new BasicEList();
        if (container != null) {
            SoftwareUtil.collectActivityGraphItems(container.getItems(), modes, targetClass, filter, itemList);
        }
        return itemList;
    }

    private static <T extends ActivityGraphItem> void collectActivityGraphItems(EList<ActivityGraphItem> input, EMap<ModeLabel, String> modes, Class<T> targetClass, Function<T, Boolean> filter, List<T> itemList) {
        for (ActivityGraphItem item : input) {
            if (item instanceof Group) {
                SoftwareUtil.collectActivityGraphItems((EList<ActivityGraphItem>)((Group)item).getItems(), modes, targetClass, filter, itemList);
                continue;
            }
            if (item instanceof ProbabilitySwitch) {
                ProbabilitySwitch propSwitch = (ProbabilitySwitch)item;
                for (ProbabilitySwitchEntry pse : propSwitch.getEntries()) {
                    SoftwareUtil.collectActivityGraphItems((EList<ActivityGraphItem>)pse.getItems(), modes, targetClass, filter, itemList);
                }
                continue;
            }
            if (item instanceof ModeSwitch) {
                ModeSwitch modeSwitch = (ModeSwitch)item;
                boolean includeDefault = true;
                for (ModeSwitchEntry mse : modeSwitch.getEntries()) {
                    if (modes == null) {
                        SoftwareUtil.collectActivityGraphItems((EList<ActivityGraphItem>)mse.getItems(), modes, targetClass, filter, itemList);
                        continue;
                    }
                    if (!mse.getCondition().isSatisfiedBy(modes)) continue;
                    SoftwareUtil.collectActivityGraphItems((EList<ActivityGraphItem>)mse.getItems(), modes, targetClass, filter, itemList);
                    includeDefault = false;
                }
                if (!includeDefault || modeSwitch.getDefaultEntry() == null) continue;
                SoftwareUtil.collectActivityGraphItems((EList<ActivityGraphItem>)modeSwitch.getDefaultEntry().getItems(), modes, targetClass, filter, itemList);
                continue;
            }
            if (!targetClass.isInstance(item)) continue;
            ActivityGraphItem castedItem = (ActivityGraphItem)targetClass.cast(item);
            if (filter != null && !filter.apply(castedItem).booleanValue()) continue;
            itemList.add(castedItem);
        }
    }

    public static Set<Label> getAccessedLabelSet(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)runnable.getActivityGraph(), modes, LabelAccess.class).stream().map(la -> la.getData()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Set<Label> getReadLabelSet(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems(runnable.getActivityGraph(), modes, LabelAccess.class, la -> la.getAccess() == LabelAccessEnum.READ).stream().map(la -> la.getData()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Set<Label> getWriteLabelSet(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems(runnable.getActivityGraph(), modes, LabelAccess.class, la -> la.getAccess() == LabelAccessEnum.WRITE).stream().map(la -> la.getData()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static List<LabelAccess> getLabelAccessList(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)runnable.getActivityGraph(), modes, LabelAccess.class);
    }

    public static List<LabelAccess> getReadLabelAccessList(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems(runnable.getActivityGraph(), modes, LabelAccess.class, la -> la.getAccess() == LabelAccessEnum.READ);
    }

    public static List<LabelAccess> getWriteLabelAccessList(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems(runnable.getActivityGraph(), modes, LabelAccess.class, la -> la.getAccess() == LabelAccessEnum.WRITE);
    }

    public static Map<Label, List<LabelAccess>> getLabelToLabelAccessMap(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems(runnable.getActivityGraph(), modes, LabelAccess.class, la -> la.getData() != null).stream().collect(Collectors.groupingBy(LabelAccess::getData));
    }

    public static Map<Label, List<LabelAccessStatistic>> getLabelAccessStatisticsMap(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems(runnable.getActivityGraph(), modes, LabelAccess.class, la -> la.getData() != null && la.getStatistic() != null).stream().collect(Collectors.groupingBy(LabelAccess::getData, Collectors.mapping(LabelAccess::getStatistic, Collectors.toList())));
    }

    public static Map<Label, List<LabelAccessStatistic>> getReadLabelAccessStatisticsMap(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems(runnable.getActivityGraph(), modes, LabelAccess.class, la -> la.getData() != null && la.getStatistic() != null && la.getAccess() == LabelAccessEnum.READ).stream().collect(Collectors.groupingBy(LabelAccess::getData, Collectors.mapping(LabelAccess::getStatistic, Collectors.toList())));
    }

    public static Map<Label, List<LabelAccessStatistic>> getWriteLabelAccessStatisticsMap(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems(runnable.getActivityGraph(), modes, LabelAccess.class, la -> la.getData() != null && la.getStatistic() != null && la.getAccess() == LabelAccessEnum.WRITE).stream().collect(Collectors.groupingBy(LabelAccess::getData, Collectors.mapping(LabelAccess::getStatistic, Collectors.toList())));
    }

    public static Set<Label> getAccessedLabelSet(Process process, EMap<ModeLabel, String> modes) {
        HashSet<Label> result = new HashSet<Label>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getAccessedLabelSet(r, modes));
        }
        return result;
    }

    public static Set<Label> getReadLabelSet(Process process, EMap<ModeLabel, String> modes) {
        HashSet<Label> result = new HashSet<Label>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getReadLabelSet(r, modes));
        }
        return result;
    }

    public static Set<Label> getWriteLabelSet(Process process, EMap<ModeLabel, String> modes) {
        HashSet<Label> result = new HashSet<Label>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getWriteLabelSet(r, modes));
        }
        return result;
    }

    public static List<LabelAccess> getLabelAccessList(Process process, EMap<ModeLabel, String> modes) {
        ArrayList<LabelAccess> result = new ArrayList<LabelAccess>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getLabelAccessList(r, modes));
        }
        return result;
    }

    public static Map<Label, List<LabelAccess>> getLabelToLabelAccessMap(Process process, EMap<ModeLabel, String> modes) {
        HashMap<Label, List<LabelAccess>> result = new HashMap<Label, List<LabelAccess>>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            Map<Label, List<LabelAccess>> labelToLabelAccessMap = SoftwareUtil.getLabelToLabelAccessMap(r, modes);
            for (Label key : labelToLabelAccessMap.keySet()) {
                if (!result.containsKey(key)) {
                    result.put(key, new ArrayList());
                }
                result.get(key).addAll((Collection<LabelAccess>)labelToLabelAccessMap.get(key));
            }
        }
        return result;
    }

    public static Map<Label, List<LabelAccessStatistic>> getLabelAccessStatisticsMap(Process process, EMap<ModeLabel, String> modes) {
        HashMap<Label, List<LabelAccessStatistic>> result = new HashMap<Label, List<LabelAccessStatistic>>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            Map<Label, List<LabelAccessStatistic>> labelToLabelAccessMap = SoftwareUtil.getLabelAccessStatisticsMap(r, modes);
            for (Label key : labelToLabelAccessMap.keySet()) {
                if (!result.containsKey(key)) {
                    result.put(key, new ArrayList());
                }
                result.get(key).addAll((Collection<LabelAccessStatistic>)labelToLabelAccessMap.get(key));
            }
        }
        return result;
    }

    public static Map<Label, List<LabelAccessStatistic>> getReadLabelAccessStatisticsMap(Process process, EMap<ModeLabel, String> modes) {
        HashMap<Label, List<LabelAccessStatistic>> result = new HashMap<Label, List<LabelAccessStatistic>>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            Map<Label, List<LabelAccessStatistic>> readLabelAccessStatisticsMap = SoftwareUtil.getReadLabelAccessStatisticsMap(r, modes);
            for (Label key : readLabelAccessStatisticsMap.keySet()) {
                if (!result.containsKey(key)) {
                    result.put(key, new ArrayList());
                }
                result.get(key).addAll((Collection<LabelAccessStatistic>)readLabelAccessStatisticsMap.get(key));
            }
        }
        return result;
    }

    public static Map<Label, List<LabelAccessStatistic>> getWriteLabelAccessStatisticsMap(Process process, EMap<ModeLabel, String> modes) {
        HashMap<Label, List<LabelAccessStatistic>> result = new HashMap<Label, List<LabelAccessStatistic>>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            Map<Label, List<LabelAccessStatistic>> writeLabelAcessStatisticsMap = SoftwareUtil.getWriteLabelAccessStatisticsMap(r, modes);
            for (Label l : writeLabelAcessStatisticsMap.keySet()) {
                if (!result.containsKey(l)) {
                    result.put(l, new ArrayList());
                }
                result.get(l).addAll((Collection<LabelAccessStatistic>)writeLabelAcessStatisticsMap.get(l));
            }
        }
        return result;
    }

    public static float getLabelReadCount(Label label, Process process, EMap<ModeLabel, String> modes, RuntimeUtil.TimeType timeType) {
        float reads = 0.0f;
        if (timeType == null) {
            timeType = RuntimeUtil.TimeType.ACET;
        }
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            List<LabelAccess> readLabelAccessesOfRunnable = SoftwareUtil.getReadLabelAccessList(r, modes);
            for (LabelAccess la : readLabelAccessesOfRunnable) {
                NumericStatistic statistic = la.getStatistic().getValue();
                if (statistic instanceof SingleValueStatistic) {
                    SingleValueStatistic svs = (SingleValueStatistic)statistic;
                    reads += svs.getValue();
                    continue;
                }
                if (!(statistic instanceof MinAvgMaxStatistic)) continue;
                MinAvgMaxStatistic stat = (MinAvgMaxStatistic)statistic;
                switch (timeType) {
                    case ACET: {
                        reads += stat.getAvg();
                        break;
                    }
                    case BCET: {
                        reads += (float)stat.getMin();
                        break;
                    }
                    case WCET: {
                        reads += (float)stat.getMax();
                    }
                }
            }
        }
        return reads;
    }

    public static float getLabelWriteCount(Label label, Process process, EMap<ModeLabel, String> modes, RuntimeUtil.TimeType timeType) {
        float writes = 0.0f;
        if (timeType == null) {
            timeType = RuntimeUtil.TimeType.ACET;
        }
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            List<LabelAccess> writeLabelAccessesOfRunnable = SoftwareUtil.getWriteLabelAccessList(r, modes);
            for (LabelAccess la : writeLabelAccessesOfRunnable) {
                NumericStatistic statistic = la.getStatistic().getValue();
                if (statistic instanceof SingleValueStatistic) {
                    SingleValueStatistic svs = (SingleValueStatistic)statistic;
                    writes += svs.getValue();
                    continue;
                }
                if (!(statistic instanceof MinAvgMaxStatistic)) continue;
                MinAvgMaxStatistic stat = (MinAvgMaxStatistic)statistic;
                switch (timeType) {
                    case ACET: {
                        writes += stat.getAvg();
                        break;
                    }
                    case BCET: {
                        writes += (float)stat.getMin();
                        break;
                    }
                    case WCET: {
                        writes += (float)stat.getMax();
                    }
                }
            }
        }
        return writes;
    }

    public static List<Runnable> getRunnableList(Process process, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)process.getActivityGraph(), modes, RunnableCall.class).stream().map(call -> call.getRunnable()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Set<Runnable> getRunnableSet(Process process, EMap<ModeLabel, String> modes) {
        return new HashSet<Runnable>(SoftwareUtil.getRunnableList(process, modes));
    }

    public static float getLabelAccessCountFromStatistics(LabelAccess labelAcc, RuntimeUtil.TimeType accType) {
        float accesses = 1.0f;
        if (labelAcc.getStatistic() == null) {
            return 1.0f;
        }
        if (labelAcc.getStatistic().getValue() instanceof SingleValueStatistic) {
            accesses = ((SingleValueStatistic)labelAcc.getStatistic().getValue()).getValue();
        } else if (labelAcc.getStatistic().getValue() instanceof MinAvgMaxStatistic) {
            switch (accType) {
                case ACET: {
                    accesses = ((MinAvgMaxStatistic)labelAcc.getStatistic().getValue()).getAvg();
                    break;
                }
                case BCET: {
                    accesses = ((MinAvgMaxStatistic)labelAcc.getStatistic().getValue()).getMin();
                    break;
                }
                case WCET: {
                    accesses = ((MinAvgMaxStatistic)labelAcc.getStatistic().getValue()).getMax();
                    break;
                }
                default: {
                    accesses = ((MinAvgMaxStatistic)labelAcc.getStatistic().getValue()).getAvg();
                }
            }
        }
        return accesses;
    }

    public static List<Runnable> getReaderListOfLabel(Label label, EMap<ModeLabel, String> modes) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        for (LabelAccess la : label.getLabelAccesses()) {
            if (la.getAccess() != LabelAccessEnum.READ) continue;
            Runnable run = AmaltheaServices.getContainerOfType(la, Runnable.class);
            if (modes != null && !modes.isEmpty() && !SoftwareUtil.collectActivityGraphItems(run.getActivityGraph(), modes).contains((Object)la)) continue;
            result.add(AmaltheaServices.getContainerOfType(la, Runnable.class));
        }
        return result;
    }

    public static Set<Runnable> getReadersSetOfLabel(Label label, EMap<ModeLabel, String> modes) {
        return new HashSet<Runnable>(SoftwareUtil.getReaderListOfLabel(label, modes));
    }

    public static List<Runnable> getWriterListOfLabel(Label label, EMap<ModeLabel, String> modes) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        for (LabelAccess la : label.getLabelAccesses()) {
            if (!la.getAccess().equals((Object)LabelAccessEnum.WRITE)) continue;
            Runnable run = AmaltheaServices.getContainerOfType(la, Runnable.class);
            if (modes != null && !modes.isEmpty() && !SoftwareUtil.collectActivityGraphItems(run.getActivityGraph(), modes).contains((Object)la)) continue;
            result.add(AmaltheaServices.getContainerOfType(la, Runnable.class));
        }
        return result;
    }

    public static Set<Runnable> getWriterSetOfLabel(Label label, EMap<ModeLabel, String> modes) {
        return new HashSet<Runnable>(SoftwareUtil.getWriterListOfLabel(label, modes));
    }

    public static List<SetEvent> collectSetEvents(Process process, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)process.getActivityGraph(), modes, SetEvent.class);
    }

    public static List<ClearEvent> collectClearEvents(Process process, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)process.getActivityGraph(), modes, ClearEvent.class);
    }

    public static List<WaitEvent> collectWaitEvents(Process process, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)process.getActivityGraph(), modes, WaitEvent.class);
    }

    public static List<ActivityGraphItem> collectEventsOfProcess(Process process, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)process.getActivityGraph(), modes, (ActivityGraphItem call) -> call instanceof ClearEvent || call instanceof SetEvent || call instanceof WaitEvent);
    }

    public static List<Label> getInterTaskCommunication(Process sender, Process receiver, EMap<ModeLabel, String> modes) {
        ArrayList<Label> result = new ArrayList<Label>();
        result.addAll(SoftwareUtil.getWriteLabelSet(sender, modes));
        result.retainAll(SoftwareUtil.getReadLabelSet(receiver, modes));
        return result;
    }

    public static List<Process> getCallingProcesses(Runnable runnable, EMap<ModeLabel, String> modes) {
        ArrayList<Process> result = new ArrayList<Process>();
        block0: for (RunnableCall callerRC : runnable.getRunnableCalls()) {
            Process caller = callerRC.getContainingProcess();
            if (caller == null) continue;
            if (modes != null && !modes.isEmpty()) {
                for (RunnableCall rc : SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)caller.getActivityGraph(), modes, RunnableCall.class)) {
                    if (rc.getRunnable() != runnable) continue;
                    result.add(caller);
                    continue block0;
                }
                continue;
            }
            result.add(caller);
        }
        return result;
    }

    public static List<Runnable> getCallingRunnables(Runnable runnable, EMap<ModeLabel, String> modes) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        block0: for (RunnableCall callerRC : runnable.getRunnableCalls()) {
            Runnable caller = callerRC.getContainingRunnable();
            if (caller == null) continue;
            if (modes != null && !modes.isEmpty()) {
                for (RunnableCall rc : SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)caller.getActivityGraph(), modes, RunnableCall.class)) {
                    if (rc.getRunnable() != runnable) continue;
                    result.add(caller);
                    continue block0;
                }
                continue;
            }
            result.add(caller);
        }
        return result;
    }

    public static List<Runnable> getCalledRunnables(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)runnable.getActivityGraph(), modes, RunnableCall.class).stream().map(rc -> rc.getRunnable()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<ExecutionNeed> getExecutionNeeds(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)runnable.getActivityGraph(), modes, ExecutionNeed.class);
    }

    public static List<ExecutionNeed> getExecutionNeeds(Process process, EMap<ModeLabel, String> modes) {
        ArrayList<ExecutionNeed> result = new ArrayList<ExecutionNeed>();
        result.addAll((Collection<ExecutionNeed>)SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)process.getActivityGraph(), modes, ExecutionNeed.class));
        for (Runnable run : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getExecutionNeeds(run, modes));
        }
        return result;
    }

    public static List<Ticks> getTicks(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)runnable.getActivityGraph(), modes, Ticks.class);
    }

    public static List<Ticks> getTicks(Process process, EMap<ModeLabel, String> modes) {
        ArrayList<Ticks> result = new ArrayList<Ticks>();
        result.addAll((Collection<Ticks>)SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)process.getActivityGraph(), modes, Ticks.class));
        for (Runnable run : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getTicks(run, modes));
        }
        return result;
    }

    public static Set<ServerCall> getServerCallSet(Runnable runnable, EMap<ModeLabel, String> modes) {
        return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)runnable.getActivityGraph(), modes, ServerCall.class).stream().collect(Collectors.toSet());
    }

    public static Set<ServerCall> getServerCallSet(Process process, EMap<ModeLabel, String> modes) {
        HashSet<ServerCall> result = new HashSet<ServerCall>();
        for (Runnable run : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getServerCallSet(run, modes));
        }
        return result;
    }
}

