/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters095.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.9.4", "output_model_version=0.9.5"}, service={IConverter.class})
public class StimuliConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(StimuliConverter.class);

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) {
        LOGGER.info("Migration from 0.9.4 to 0.9.5 : Executing Stimuli converter for model file : {}", (Object)targetFile.getName());
        this.basicConvert(targetFile, fileName_documentsMap, caches);
    }

    public void basicConvert(File file, Map<File, Document> map, List<ICache> caches) {
        Document document = map.get(file);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.update_Scenario(rootElement);
        this.update_ClocksMulitplierList(rootElement);
        this.update_ClockSineFunction(rootElement);
        this.update_ClockTriangleFunction(rootElement);
    }

    private void update_Scenario(Element rootElement) {
        String xpath = "./stimuliModel/stimuli[@xsi:type=\"am:VariableRateStimulus\"]/scenario";
        List scenarios = HelperUtil.getXpathResult((Element)rootElement, (String)"./stimuliModel/stimuli[@xsi:type=\"am:VariableRateStimulus\"]/scenario", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._094, (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element element : scenarios) {
            Pattern p;
            Matcher m;
            String hrefValue;
            Element clockElement;
            Pattern p2;
            Matcher m2;
            String clockAttribute;
            Element recurrence = element.getChild("recurrence");
            if (recurrence != null) {
                recurrence.detach();
                String value = recurrence.getAttributeValue("value");
                String unit = recurrence.getAttributeValue("unit");
                this.addCustomProperty(element, "old_definition_v0.9.4", "recurrence=" + value + unit);
            }
            if ((clockAttribute = element.getAttributeValue("clock")) != null && (m2 = (p2 = Pattern.compile("(.+)\\?type=Clock(.+)")).matcher(clockAttribute)).find()) {
                String clockRef = m2.group(1);
                String clockType = this.getNewClockType(m2.group(2));
                element.setAttribute("clock", String.valueOf(clockRef) + "?type=Clock" + clockType);
            }
            if ((clockElement = this.getSingleChild(element, "clock")) == null || (hrefValue = clockElement.getAttributeValue("href")) == null || !(m = (p = Pattern.compile("amlt:/#(.+)\\?type=Clock(.+)")).matcher(hrefValue)).find()) continue;
            String clockRef = m.group(1);
            String clockType = this.getNewClockType(m.group(2));
            clockElement.setAttribute("type", "am:Clock" + clockType, AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            clockElement.setAttribute("href", "amlt:/#" + clockRef + "?type=Clock" + clockType);
        }
    }

    private void update_ClockSineFunction(Element rootElement) {
        String xpath = "./stimuliModel/clocks[@xsi:type=\"am:ClockSinusFunction\"]";
        List clocks = HelperUtil.getXpathResult((Element)rootElement, (String)"./stimuliModel/clocks[@xsi:type=\"am:ClockSinusFunction\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._094, (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        StringBuilder customPropsValue = new StringBuilder();
        for (Element element : clocks) {
            element.setAttribute("type", "am:ClockFunction", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            element.setAttribute("curveType", "sine");
            Attribute amplitude = element.getAttribute("amplitude");
            amplitude.detach();
            customPropsValue.append(this.getStringValue(amplitude));
            customPropsValue.append(" ");
            Attribute offset = element.getAttribute("yOffset");
            offset.detach();
            customPropsValue.append(this.getStringValue(offset));
            customPropsValue.append(" ");
            customPropsValue.append(this.extractPeriodAndShift(element));
            this.addCustomProperty(element, "old_definition_v0.9.4", customPropsValue.toString().trim());
        }
    }

    private void update_ClockTriangleFunction(Element rootElement) {
        String xpath = "./stimuliModel/clocks[@xsi:type=\"am:ClockTriangleFunction\"]";
        List clocks = HelperUtil.getXpathResult((Element)rootElement, (String)"./stimuliModel/clocks[@xsi:type=\"am:ClockTriangleFunction\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._094, (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        StringBuilder customPropsValue = new StringBuilder();
        for (Element element : clocks) {
            element.setAttribute("type", "am:ClockFunction", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            element.setAttribute("curveType", "triangle");
            Attribute max = element.getAttribute("max");
            max.detach();
            customPropsValue.append(this.getStringValue(max));
            customPropsValue.append(" ");
            Attribute min = element.getAttribute("min");
            min.detach();
            customPropsValue.append(this.getStringValue(min));
            customPropsValue.append(" ");
            customPropsValue.append(this.extractPeriodAndShift(element));
            this.addCustomProperty(element, "old_definition_v0.9.4", customPropsValue.toString().trim());
        }
    }

    private String extractPeriodAndShift(Element element) {
        StringBuilder str = new StringBuilder();
        List children = element.getChildren();
        for (Element e : children) {
            str.append(e.getName());
            str.append("=");
            str.append(e.getAttributeValue("value"));
            str.append(e.getAttributeValue("unit"));
            str.append(" ");
        }
        element.removeChild("period");
        element.removeChild("shift");
        return str.toString();
    }

    private String getStringValue(Attribute attr) {
        String str = String.valueOf(attr.getName()) + "=" + attr.getValue();
        return str;
    }

    private void update_ClocksMulitplierList(Element rootElement) {
        String xpath = "./stimuliModel/clocks[@xsi:type=\"am:ClockMultiplierList\"]";
        List clocks = HelperUtil.getXpathResult((Element)rootElement, (String)"./stimuliModel/clocks[@xsi:type=\"am:ClockMultiplierList\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._094, (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element element : clocks) {
            element.setAttribute("type", "am:ClockStepList", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            this.update_ClockEntries(element);
        }
    }

    private void update_ClockEntries(Element clockElement) {
        List entries = clockElement.getChildren("entries");
        for (Element entry : entries) {
            Attribute multiplier = entry.getAttribute("multiplier");
            multiplier.detach();
            this.addCustomProperty(entry, "old_definition_v0.9.4", "multiplier=" + multiplier.getValue());
        }
    }

    private void addCustomProperty(Element element, String key, String value) {
        Element customProps = new Element("customProperties");
        customProps.setAttribute("key", key);
        Element valueElement = new Element("value");
        valueElement.setAttribute("type", "am:StringObject", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
        valueElement.setAttribute("value", value);
        customProps.addContent((Content)valueElement);
        element.addContent((Content)customProps);
    }

    private Element getSingleChild(Element parent, String name) {
        List list = parent.getChildren(name);
        if (list.size() == 1) {
            return (Element)list.get(0);
        }
        return null;
    }

    private String getNewClockType(String oldClockType) {
        switch (oldClockType) {
            case "SinusFunction": 
            case "TriangleFunction": {
                return "Function";
            }
            case "MultiplierList": {
                return "StepList";
            }
        }
        return oldClockType;
    }
}

