/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters080.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.XMLOutputter;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.7.2", "output_model_version=0.8.0"}, service={IConverter.class})
public class PropertyConstraintsConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyConstraintsConverter.class);

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) {
        LOGGER.info("Migration from 0.7.2 to 0.8.0 : Executing PropertyConstraints converter for model file : {}", (Object)targetFile.getName());
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.remove_HWConstraint_Element(rootElement);
    }

    private void remove_HWConstraint_Element(Element rootElement) {
        XMLOutputter xmlOutputter = new XMLOutputter();
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./propertyConstraintsModel/allocationConstraints/hwConstraint");
        xpathBuffer.append("|");
        xpathBuffer.append("./propertyConstraintsModel/mappingConstraints/hwConstraint");
        List elements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element hwConstraintElement : elements) {
            String xmlString = xmlOutputter.outputString(hwConstraintElement);
            Element parentElement = hwConstraintElement.getParentElement();
            Element customPropertyElement = new Element("customProperties");
            customPropertyElement.setAttribute("key", "hwConstraint (element removed during Migration of Model to 0.8.0 version)");
            Element valueElement = new Element("value");
            valueElement.setAttribute("type", "am:StringObject", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            valueElement.setAttribute("value", xmlString);
            customPropertyElement.addContent((Content)valueElement);
            parentElement.addContent((Content)customPropertyElement);
            LOGGER.warn("hwConstraint tag is removed from {}. Below is the content of hwConstraint object: \n{}", (Object)parentElement.getName(), (Object)xmlString);
            parentElement.removeContent((Content)hwConstraintElement);
        }
    }
}

