/**
 ********************************************************************************
 * Copyright (c) 2019 Robert Bosch GmbH and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 ********************************************************************************
 */
package org.eclipse.app4mc.amalthea.converters.ui.jobs;

import org.eclipse.app4mc.amalthea.converters.common.MigrationStatusCode;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationJobChangeListener extends JobChangeAdapter {

	private static final Logger LOGGER = LoggerFactory.getLogger(MigrationJobChangeListener.class);

	private Shell shell;
	private IProject project;

	public MigrationJobChangeListener(Shell shell, IProject project) {
		this.shell = shell;
		this.project = project;
	}

	@Override
	public void done(IJobChangeEvent event) {
		super.done(event);
		IStatus result = event.getResult();

		if (result.getCode() == MigrationStatusCode.UNSUPPORTED_MODEL_VERSIONS) {

			Display.getDefault().asyncExec(() ->
				MessageDialog.openError(this.shell, "AMALTHEA Model Migration", event.getResult().getMessage()));

		} else if (result.getCode() == MigrationStatusCode.ERROR) {

			Display.getDefault().asyncExec(() ->
				ErrorDialog.openError(this.shell, "AMALTHEA Model Migration", event.getResult().getMessage(), event.getResult()));

		} else if (result.equals(Status.OK_STATUS)) {

			Display.getDefault().asyncExec(() -> {
				MessageDialog.openInformation(this.shell, "AMALTHEA Model Migration","Model Migration successful !!");

				if (this.project != null) {
					try {
						this.project.refreshLocal(IResource.DEPTH_INFINITE, new NullProgressMonitor());
					} catch (final CoreException e) {
						LOGGER.error(e.getMessage(), e);
					}
				}

			});

		}
	}

}
