/**
 ********************************************************************************
 * Copyright (c) 2015-2019 Robert Bosch GmbH and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 ********************************************************************************
 */

package org.eclipse.app4mc.amalthea.converters.ui.jobs;

import org.eclipse.app4mc.amalthea.converters.common.MigrationException;
import org.eclipse.app4mc.amalthea.converters.common.MigrationProcessor;
import org.eclipse.app4mc.amalthea.converters.common.MigrationSettings;
import org.eclipse.app4mc.amalthea.converters.common.MigrationStatusCode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ModelMigrationJob extends Job {

	private final MigrationProcessor migrationProcessor;
	private final MigrationSettings migrationSettings;

	public ModelMigrationJob(String name, MigrationProcessor migrationProcessor, MigrationSettings migrationSettings) {
		super(name);
		this.migrationProcessor = migrationProcessor;
		this.migrationSettings = migrationSettings;
	}

	@Override
	protected IStatus run(final IProgressMonitor monitor) {

		try {
			int result = migrationProcessor.execute(migrationSettings, monitor);
			switch (result) {

				case MigrationStatusCode.UNSUPPORTED_MODEL_VERSIONS:
					return new Status(
							IStatus.CANCEL,
							"org.eclipse.app4mc.amalthea.converters.ui",
							MigrationStatusCode.UNSUPPORTED_MODEL_VERSIONS,
							"Migration not supported for the selected model versions. \nInput Model version : \""
									+ this.migrationSettings.getInputModelVersion()
									+ "\" Output Model Version : \""
									+ this.migrationSettings.getMigrationModelVersion() + "\"",
									null);

				case MigrationStatusCode.CANCEL:
					return Status.CANCEL_STATUS;
				case MigrationStatusCode.ERROR:
					return new Status(
							IStatus.ERROR,
							"org.eclipse.app4mc.amalthea.converters.ui",
							MigrationStatusCode.ERROR,
							"Error during migration",
							null);
				default:
					return Status.OK_STATUS;

			}
		} catch (MigrationException e) {
			return new Status(
					IStatus.ERROR,
					"org.eclipse.app4mc.amalthea.converters.ui",
					MigrationStatusCode.ERROR,
					"Error during migration",
					e);
		}
	}

	@Override
	public boolean belongsTo(final Object family) {

		if (family != null && family.equals(IMigrationJobConstants.FAMILY)) {
			return true;
		}

		return super.belongsTo(family);
	}

}
