/**
 ********************************************************************************
 * Copyright (c) 2018-2020 Robert Bosch GmbH.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 ********************************************************************************
 */

package app4mc.example.tool.java;

import java.io.File;
import java.io.IOException;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.sphinx.AmaltheaResourceFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sphinx.emf.resource.ExtendedResourceSet;
import org.eclipse.sphinx.emf.resource.ExtendedResourceSetImpl;

public class SplitModelExample {

	public static void main(String[] args) {

		final String inputName = "model-input/democar.amxmi";

		// ***** Load *****

		Resource resource = loadFromFileNamed(inputName);
		if (resource == null) return;

		final ResourceSet resourceSet = resource.getResourceSet();
		
		try {
			resource.load(null);
		} catch (IOException e) {
			// ignore
		}

		Amalthea inputModel = null;
		for (final EObject content : resource.getContents()) {
			if (content instanceof Amalthea) {
				inputModel = (Amalthea) content;
			}
		}

		if (inputModel == null) {
			System.out.println("Error: No model loaded!");
			return;
		}

		// ***** Modify *****

		Amalthea mCommon		= createNewModelWithResource(resourceSet, "model-output/SplitModel/democar-common.amxmi");
		Amalthea mHardware		= createNewModelWithResource(resourceSet, "model-output/SplitModel/democar-hw.amxmi");
		Amalthea mSoftware		= createNewModelWithResource(resourceSet, "model-output/SplitModel/democar-sw.amxmi");
		Amalthea mOS			= createNewModelWithResource(resourceSet, "model-output/SplitModel/democar-os.amxmi");
		Amalthea mStimuli		= createNewModelWithResource(resourceSet, "model-output/SplitModel/democar-stimuli.amxmi");
		Amalthea mConstraints	= createNewModelWithResource(resourceSet, "model-output/SplitModel/democar-constraints.amxmi");
		Amalthea mMapping		= createNewModelWithResource(resourceSet, "model-output/SplitModel/democar-mapping.amxmi");
		Amalthea mComponents	= createNewModelWithResource(resourceSet, "model-output/SplitModel/democar-components.amxmi");

		mCommon.setCommonElements(inputModel.getCommonElements());
		inputModel.setCommonElements(null);

		mHardware.setHwModel(inputModel.getHwModel());
		inputModel.setHwModel(null);

		mSoftware.setSwModel(inputModel.getSwModel());
		inputModel.setSwModel(null);

		mOS.setOsModel(inputModel.getOsModel());
		inputModel.setOsModel(null);

		mStimuli.setStimuliModel(inputModel.getStimuliModel());
		inputModel.setStimuliModel(null);

		mConstraints.setConstraintsModel(inputModel.getConstraintsModel());
		inputModel.setConstraintsModel(null);

		mMapping.setMappingModel(inputModel.getMappingModel());
		inputModel.setMappingModel(null);

		mComponents.setComponentsModel(inputModel.getComponentsModel());
		inputModel.setComponentsModel(null);

		// ***** Save *****

		writeResource(mCommon.eResource());
		writeResource(mHardware.eResource());
		writeResource(mSoftware.eResource());
		writeResource(mOS.eResource());
		writeResource(mStimuli.eResource());
		writeResource(mConstraints.eResource());
		writeResource(mMapping.eResource());
		writeResource(mComponents.eResource());

		System.out.println("done");
	}

	private static Resource loadFromFileNamed(String pathname) {

		final File file = new File(pathname);
		final URI uri = URI.createFileURI(file.getAbsolutePath());
		if (uri == null) return null;

		System.out.println("Reading file: " + uri.toString());

		final ResourceSet resSet = initializeResourceSet();
		final Resource res = resSet.createResource(uri);

		return res;
	}

	private static Amalthea createNewModelWithResource(ResourceSet resSet, String fileName) {

		Amalthea model = AmaltheaFactory.eINSTANCE.createAmalthea();

		final File file = new File(fileName);
		final URI uri = URI.createFileURI(file.getAbsolutePath());
		if (uri == null) return null;

		final Resource resource = resSet.createResource(uri);
		resource.getContents().add(model);

		return model;
	}

	private static boolean writeResource(Resource res) {

		System.out.println("Writing file: " + res.getURI().path());

		try {
			res.save(null);
		} catch (IOException e) {
			return false;
		}

		return true;
	}

	private static ResourceSet initializeResourceSet() {
		AmaltheaPackage.eINSTANCE.eClass(); // register the package
		final ExtendedResourceSet resSet = new ExtendedResourceSetImpl();
		resSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("amxmi", new AmaltheaResourceFactory(true));

		return resSet;
	}

}
