/**
 ********************************************************************************
 * Copyright (c) 2020 Robert Bosch GmbH.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.app4mc.amalthea.visualization.hw;

import javax.annotation.PostConstruct;

import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.visualization.hw.VisualizationHandler.DiagramResource;
import org.eclipse.app4mc.visualization.ui.registry.Visualization;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.component.annotations.Component;

import net.sourceforge.plantuml.eclipse.utils.PlantumlConstants;

@SuppressWarnings("restriction")
@Component(property= {
		"name=HW Model Block Diagram",
		"description=Block Diagram Visualization for Hardware Models"
})
public class HWBlockDiagramVisualization implements Visualization {

	@PostConstruct
	public void createVisualization(
			HWModel hwModel, 
			Composite parent,
			Shell shell,
			@Optional
			@Preference(
					nodePath = "net.sourceforge.plantuml.eclipse", 
					value = PlantumlConstants.GRAPHVIZ_PATH) 
			String dotPath,
			UISynchronize sync) {
		
		Browser browser = new Browser(parent, SWT.NONE);
		
		VisualizationHandler handler = new VisualizationHandler();
		DiagramResource diagramResource = handler.getDiagramResource(hwModel);
		
		JobChangeAdapter listener = new JobChangeAdapter() {
			@Override
			public void done(IJobChangeEvent event) {
				sync.asyncExec(() -> {
					if (!browser.isDisposed()) {
						browser.setUrl(diagramResource.diagramFilePath);
					}
				});
			};
		};
		
		handler.execute(shell, sync, dotPath, hwModel, diagramResource, false, listener);
	}
}
