/**
 ********************************************************************************
 * Copyright (c) 2018-2020 Robert Bosch GmbH and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 ********************************************************************************
 */

package org.eclipse.app4mc.amalthea.converters093.impl;

import java.io.File;
import java.util.List;
import java.util.Map;

import org.eclipse.app4mc.amalthea.converters.common.ServiceConstants;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters093.utils.HelperUtils_092_093;
import org.jdom2.Document;
import org.jdom2.Element;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(
		property = {
			ServiceConstants.INPUT_MODEL_VERSION_PROPERTY + "=0.9.2",
			ServiceConstants.OUTPUT_MODEL_VERSION_PROPERTY + "=0.9.3"
		},
		service = IConverter.class)
public class MeasurementConverter extends AbstractConverter {

	private static final Logger LOGGER = LoggerFactory.getLogger(MeasurementConverter.class);

	@Override
	@Activate
	protected void activate(Map<String, Object> properties) {
		super.activate(properties);
	}

	@Override
	public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) {

		LOGGER.info(
				"Migration from 0.9.2 to 0.9.3 : Executing Measurement converter for model file : {}", targetFile.getName());

		final Document root = fileName_documentsMap.get(targetFile);

		if (root == null) {
			return;
		}
		final Element rootElement = root.getRootElement();

		update_Stimuli(rootElement);
	}

	private void update_Stimuli(final Element rootElement) {
		final StringBuilder xpathBuffer = new StringBuilder();
		xpathBuffer.append("./measurementModel/measurements");

		final List<Element> measurementElements = HelperUtil.getXpathResult(
				rootElement,
				xpathBuffer.toString(),
				Element.class,
				AmaltheaNamespaceRegistry.getNamespace(ModelVersion._093, "am"),
				AmaltheaNamespaceRegistry.getGenericNamespace("xsi"));

		for (Element measurementElement : measurementElements) {
			Element runtimeDeviation_Time_element = measurementElement.getChild("runtimeDeviation");

			if(runtimeDeviation_Time_element!=null) {
				Element migratedElement = HelperUtils_092_093.migrateDeviationElement_Containing_TimeValue(runtimeDeviation_Time_element, "runtimeDeviation");
				int indexOf = measurementElement.indexOf(runtimeDeviation_Time_element);
				measurementElement.removeContent(runtimeDeviation_Time_element);

				if(migratedElement!=null) {
					//adding migrated element to the stimuli element
					measurementElement.addContent(indexOf, migratedElement);
				}
			}
		}
	}
}
