package org.eclipse.app4mc.amalthea.nature;

import java.net.URL;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class AmaltheaNaturePlugin extends AbstractUIPlugin {

	public static AmaltheaNaturePlugin INSTANCE = new AmaltheaNaturePlugin();

	public static final String IMAGE_ID = "sample_decorator";

	@Override
	public ImageRegistry getImageRegistry() {

		ImageRegistry reg = super.getImageRegistry();

		if (reg.get(IMAGE_ID) == null) {
			Bundle bundle = Platform.getBundle("org.eclipse.app4mc.amalthea.nature");

			if (bundle != null) {
				IPath path = new Path("icons/sample_decorator.gif");
				if (path != null) {
					URL url = FileLocator.find(bundle, path, null);
					if (url != null) {
						ImageDescriptor desc = ImageDescriptor.createFromURL(url);
						reg.put(IMAGE_ID, desc);
					}

				}

			}

		}
		return reg;
	}

}
