package org.eclipse.app4mc.amalthea.nature.decorators;

import java.util.Arrays;

import org.eclipse.app4mc.amalthea.nature.AmaltheaNaturePlugin;
import org.eclipse.app4mc.amalthea.nature.AmaltheaNoLoadNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class ProjectDecorator implements  ILightweightLabelDecorator{

 
	@Override
	public void decorate(Object element, IDecoration decoration) {

		if(element instanceof IProject) {
			
			IProjectDescription desc;
			try {
				desc = ((IProject) element).getDescription();
				
				if(desc !=null) {
					String[] prevNatures = desc.getNatureIds();
					
					if (Arrays.asList(prevNatures).contains(AmaltheaNoLoadNature.ID) == true) {
						
						decoration.addSuffix(" - Amalthea-no-load-activated");
						
						decoration.addOverlay(AmaltheaNaturePlugin.INSTANCE.getImageRegistry().getDescriptor(AmaltheaNaturePlugin.IMAGE_ID), IDecoration.TOP_LEFT);
					}
					
				}
			} catch (CoreException e) {

			}
		}
	}

	@Override
	public void addListener(ILabelProviderListener listener) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void dispose() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public boolean isLabelProperty(Object element, String property) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void removeListener(ILabelProviderListener listener) {
		// TODO Auto-generated method stub
		
	}

}
