/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BinaryOperator;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.ComponentInstance;
import org.eclipse.app4mc.amalthea.model.ComponentPort;
import org.eclipse.app4mc.amalthea.model.DataRate;
import org.eclipse.app4mc.amalthea.model.DataRateUnit;
import org.eclipse.app4mc.amalthea.model.DataSize;
import org.eclipse.app4mc.amalthea.model.DataSizeUnit;
import org.eclipse.app4mc.amalthea.model.Frequency;
import org.eclipse.app4mc.amalthea.model.FrequencyUnit;
import org.eclipse.app4mc.amalthea.model.HwModule;
import org.eclipse.app4mc.amalthea.model.HwPort;
import org.eclipse.app4mc.amalthea.model.HwStructure;
import org.eclipse.app4mc.amalthea.model.ISystem;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.QualifiedPort;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.Voltage;
import org.eclipse.app4mc.amalthea.model.VoltageUnit;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AmaltheaServices {
    private static final BigInteger INT_8 = BigInteger.valueOf(8L);
    private static final BigInteger INT_2_POW_10 = BigInteger.valueOf(2L).pow(10);
    private static final BigInteger INT_2_POW_20 = BigInteger.valueOf(2L).pow(20);
    private static final BigInteger INT_2_POW_30 = BigInteger.valueOf(2L).pow(30);
    private static final BigInteger INT_2_POW_40 = BigInteger.valueOf(2L).pow(40);
    private static final BigInteger INT_10_POW_3 = BigInteger.TEN.pow(3);
    private static final BigInteger INT_10_POW_6 = BigInteger.TEN.pow(6);
    private static final BigInteger INT_10_POW_9 = BigInteger.TEN.pow(9);
    private static final BigInteger INT_10_POW_12 = BigInteger.TEN.pow(12);
    private static final BigDecimal DEC_10_POW_3 = BigDecimal.TEN.pow(3);
    private static final BigDecimal DEC_10_POW_6 = BigDecimal.TEN.pow(6);
    private static final BigDecimal DEC_10_POW_9 = BigDecimal.TEN.pow(9);
    private static final String ARG_NULL_MESSAGE = "Argument is null, expected: %s";
    private static final String ARG_OBJECT_MESSAGE = "Object argument is null, expected: EObject";
    private static final String ARG_CLASS_MESSAGE = "Class argument is null, expected: Class<T extends EObject>";
    private static final String ARG_QUANTITY_MESSAGE = "Invalid %s object: value and unit must be set";
    private static final String ARG_BOUNDS_MESSAGE = "Invalid bounds: lower bound > upper bound";
    private static final String ARG_POSITIVE_VALUE_MESSAGE = "Invalid number, expected: value > 0";
    private static final String DATA_SIZE = DataSize.class.getSimpleName();
    private static final String DATA_RATE = DataRate.class.getSimpleName();
    private static final String TIME = Time.class.getSimpleName();
    private static final String FREQUENCY = Frequency.class.getSimpleName();
    private static final String VOLTAGE = Voltage.class.getSimpleName();
    private static final String NUMBER = Number.class.getSimpleName();
    public static final List<TimeUnit> TIME_UNIT_LIST = Collections.unmodifiableList(Arrays.asList(TimeUnit.PS, TimeUnit.NS, TimeUnit.US, TimeUnit.MS, TimeUnit.S));

    private AmaltheaServices() {
        throw new IllegalStateException("Utility class");
    }

    private static void checkDataSizeArgument(DataSize size) {
        Preconditions.checkArgument((size != null ? 1 : 0) != 0, (String)ARG_NULL_MESSAGE, (Object)DATA_SIZE);
        Preconditions.checkArgument((size.getValue() != null ? 1 : 0) != 0, (String)ARG_QUANTITY_MESSAGE, (Object)DATA_SIZE);
        Preconditions.checkArgument((size.getUnit() != DataSizeUnit._UNDEFINED_ ? 1 : 0) != 0, (String)ARG_QUANTITY_MESSAGE, (Object)DATA_SIZE);
    }

    private static void checkDataRateArgument(@NonNull DataRate rate) {
        Preconditions.checkArgument((rate != null ? 1 : 0) != 0, (String)ARG_NULL_MESSAGE, (Object)DATA_RATE);
        Preconditions.checkArgument((rate.getValue() != null ? 1 : 0) != 0, (String)ARG_QUANTITY_MESSAGE, (Object)DATA_RATE);
        Preconditions.checkArgument((rate.getUnit() != DataRateUnit._UNDEFINED_ ? 1 : 0) != 0, (String)ARG_QUANTITY_MESSAGE, (Object)DATA_RATE);
    }

    private static void checkTimeArgument(@NonNull Time time) {
        Preconditions.checkArgument((time != null ? 1 : 0) != 0, (String)ARG_NULL_MESSAGE, (Object)TIME);
        Preconditions.checkArgument((time.getValue() != null ? 1 : 0) != 0, (String)ARG_QUANTITY_MESSAGE, (Object)TIME);
        Preconditions.checkArgument((time.getUnit() != TimeUnit._UNDEFINED_ ? 1 : 0) != 0, (String)ARG_QUANTITY_MESSAGE, (Object)TIME);
    }

    public static <T extends EObject> T getContainerOfType(@NonNull EObject object, @NonNull Class<T> type) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG_OBJECT_MESSAGE);
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)ARG_CLASS_MESSAGE);
        EObject parent = object.eContainer();
        while (parent != null) {
            if (type.isInstance(parent)) {
                return (T)((EObject)type.cast(parent));
            }
            parent = parent.eContainer();
        }
        return (T)((EObject)type.cast(null));
    }

    public static BigInteger convertToBit(@NonNull DataSize size) {
        AmaltheaServices.checkDataSizeArgument(size);
        BigInteger bitBase = size.getValue();
        BigInteger byteBase = size.getValue().multiply(INT_8);
        switch (size.getUnit()) {
            case BIT: {
                return bitBase;
            }
            case KBIT: {
                return bitBase.multiply(INT_10_POW_3);
            }
            case MBIT: {
                return bitBase.multiply(INT_10_POW_6);
            }
            case GBIT: {
                return bitBase.multiply(INT_10_POW_9);
            }
            case TBIT: {
                return bitBase.multiply(INT_10_POW_12);
            }
            case KIBIT: {
                return bitBase.multiply(INT_2_POW_10);
            }
            case MIBIT: {
                return bitBase.multiply(INT_2_POW_20);
            }
            case GIBIT: {
                return bitBase.multiply(INT_2_POW_30);
            }
            case TIBIT: {
                return bitBase.multiply(INT_2_POW_40);
            }
            case B: {
                return byteBase;
            }
            case KB: {
                return byteBase.multiply(INT_10_POW_3);
            }
            case MB: {
                return byteBase.multiply(INT_10_POW_6);
            }
            case GB: {
                return byteBase.multiply(INT_10_POW_9);
            }
            case TB: {
                return byteBase.multiply(INT_10_POW_12);
            }
            case KI_B: {
                return byteBase.multiply(INT_2_POW_10);
            }
            case MI_B: {
                return byteBase.multiply(INT_2_POW_20);
            }
            case GI_B: {
                return byteBase.multiply(INT_2_POW_30);
            }
            case TI_B: {
                return byteBase.multiply(INT_2_POW_40);
            }
        }
        return BigInteger.ZERO;
    }

    public static BigInteger convertToBitPerSecond(@NonNull DataRate rate) {
        AmaltheaServices.checkDataRateArgument(rate);
        BigInteger bitBase = rate.getValue();
        BigInteger byteBase = rate.getValue().multiply(INT_8);
        switch (rate.getUnit()) {
            case BIT_PER_SECOND: {
                return bitBase;
            }
            case KBIT_PER_SECOND: {
                return bitBase.multiply(INT_10_POW_3);
            }
            case MBIT_PER_SECOND: {
                return bitBase.multiply(INT_10_POW_6);
            }
            case GBIT_PER_SECOND: {
                return bitBase.multiply(INT_10_POW_9);
            }
            case TBIT_PER_SECOND: {
                return bitBase.multiply(INT_10_POW_12);
            }
            case KIBIT_PER_SECOND: {
                return bitBase.multiply(INT_2_POW_10);
            }
            case MIBIT_PER_SECOND: {
                return bitBase.multiply(INT_2_POW_20);
            }
            case GIBIT_PER_SECOND: {
                return bitBase.multiply(INT_2_POW_30);
            }
            case TIBIT_PER_SECOND: {
                return bitBase.multiply(INT_2_POW_40);
            }
            case BPER_SECOND: {
                return byteBase;
            }
            case KB_PER_SECOND: {
                return byteBase.multiply(INT_10_POW_3);
            }
            case MB_PER_SECOND: {
                return byteBase.multiply(INT_10_POW_6);
            }
            case GB_PER_SECOND: {
                return byteBase.multiply(INT_10_POW_9);
            }
            case TB_PER_SECOND: {
                return byteBase.multiply(INT_10_POW_12);
            }
            case KI_BPER_SECOND: {
                return byteBase.multiply(INT_2_POW_10);
            }
            case MI_BPER_SECOND: {
                return byteBase.multiply(INT_2_POW_20);
            }
            case GI_BPER_SECOND: {
                return byteBase.multiply(INT_2_POW_30);
            }
            case TI_BPER_SECOND: {
                return byteBase.multiply(INT_2_POW_40);
            }
        }
        return BigInteger.ZERO;
    }

    public static BigInteger convertToPicoSeconds(@NonNull Time time) {
        AmaltheaServices.checkTimeArgument(time);
        @NonNull BigInteger timeValue = time.getValue();
        switch (time.getUnit()) {
            case PS: {
                return timeValue;
            }
            case NS: {
                return timeValue.multiply(INT_10_POW_3);
            }
            case US: {
                return timeValue.multiply(INT_10_POW_6);
            }
            case MS: {
                return timeValue.multiply(INT_10_POW_9);
            }
            case S: {
                return timeValue.multiply(INT_10_POW_12);
            }
        }
        return BigInteger.ZERO;
    }

    public static BigDecimal convertToHertz(@NonNull Frequency frequency) {
        Preconditions.checkArgument((frequency != null ? 1 : 0) != 0, (String)ARG_NULL_MESSAGE, (Object)FREQUENCY);
        Preconditions.checkArgument((frequency.getUnit() != FrequencyUnit._UNDEFINED_ ? 1 : 0) != 0, (String)ARG_QUANTITY_MESSAGE, (Object)FREQUENCY);
        double freqValue = frequency.getValue();
        switch (frequency.getUnit()) {
            case HZ: {
                return BigDecimal.valueOf(freqValue);
            }
            case KHZ: {
                return BigDecimal.valueOf(freqValue).multiply(DEC_10_POW_3);
            }
            case MHZ: {
                return BigDecimal.valueOf(freqValue).multiply(DEC_10_POW_6);
            }
            case GHZ: {
                return BigDecimal.valueOf(freqValue).multiply(DEC_10_POW_9);
            }
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal convertToMicroVolt(@NonNull Voltage voltage) {
        Preconditions.checkArgument((voltage != null ? 1 : 0) != 0, (String)ARG_NULL_MESSAGE, (Object)VOLTAGE);
        Preconditions.checkArgument((voltage.getUnit() != VoltageUnit._UNDEFINED_ ? 1 : 0) != 0, (String)ARG_QUANTITY_MESSAGE, (Object)VOLTAGE);
        double voltValue = voltage.getValue();
        switch (voltage.getUnit()) {
            case UV: {
                return BigDecimal.valueOf(voltValue);
            }
            case MV: {
                return BigDecimal.valueOf(voltValue).multiply(DEC_10_POW_3);
            }
            case V: {
                return BigDecimal.valueOf(voltValue).multiply(DEC_10_POW_6);
            }
        }
        return BigDecimal.ZERO;
    }

    public static int compareDataRates(@NonNull DataRate r1, @NonNull DataRate r2) {
        AmaltheaServices.checkDataRateArgument(r1);
        AmaltheaServices.checkDataRateArgument(r2);
        if (r1 == r2) {
            return 0;
        }
        BigInteger value1 = AmaltheaServices.convertToBitPerSecond(r1);
        BigInteger value2 = AmaltheaServices.convertToBitPerSecond(r2);
        assert (value1 != null);
        assert (value2 != null);
        return value1.compareTo(value2);
    }

    public static int compareTimes(@NonNull Time t1, @NonNull Time t2) {
        AmaltheaServices.checkTimeArgument(t1);
        AmaltheaServices.checkTimeArgument(t2);
        if (t1 == t2) {
            return 0;
        }
        BigInteger value1 = AmaltheaServices.convertToPicoSeconds(t1);
        BigInteger value2 = AmaltheaServices.convertToPicoSeconds(t2);
        assert (value1 != null);
        assert (value2 != null);
        return value1.compareTo(value2);
    }

    public static @NonNull Time adjustTimeUnit(@NonNull Time time) {
        AmaltheaServices.checkTimeArgument(time);
        if (time.getValue() == BigInteger.ZERO) {
            return AmaltheaServices.createTime(BigInteger.ZERO, TimeUnit.S);
        }
        int index = TIME_UNIT_LIST.indexOf((Object)time.getUnit());
        int maxIndex = TIME_UNIT_LIST.size() - 1;
        BigInteger value = time.getValue();
        BigInteger bigInt1000 = INT_10_POW_3;
        while (value.mod(bigInt1000) == BigInteger.ZERO && index < maxIndex) {
            value = value.divide(bigInt1000);
            ++index;
        }
        return AmaltheaServices.createTime(value, TIME_UNIT_LIST.get(index));
    }

    public static @NonNull Time addTime(@NonNull Time t1, @NonNull Time t2) {
        AmaltheaServices.checkTimeArgument(t1);
        AmaltheaServices.checkTimeArgument(t2);
        return AmaltheaServices.applyToTimes(BigInteger::add, t1, t2);
    }

    public static @NonNull Time subtractTime(@NonNull Time t1, @NonNull Time t2) {
        AmaltheaServices.checkTimeArgument(t1);
        AmaltheaServices.checkTimeArgument(t2);
        return AmaltheaServices.applyToTimes(BigInteger::subtract, t1, t2);
    }

    public static double divideTime(@NonNull Time t1, @NonNull Time t2) {
        AmaltheaServices.checkTimeArgument(t1);
        AmaltheaServices.checkTimeArgument(t2);
        double v1 = AmaltheaServices.convertToPicoSeconds(t1).doubleValue();
        double v2 = AmaltheaServices.convertToPicoSeconds(t2).doubleValue();
        return v1 / v2;
    }

    public static @NonNull Time multiply(@NonNull Time t1, long value) {
        AmaltheaServices.checkTimeArgument(t1);
        BigInteger v1 = t1.getValue();
        BigInteger v2 = BigInteger.valueOf(value);
        return AmaltheaServices.createTime(v1.multiply(v2), t1.getUnit());
    }

    public static @NonNull Time multiply(@NonNull Time t1, double value) {
        AmaltheaServices.checkTimeArgument(t1);
        BigDecimal v1 = BigDecimal.valueOf(AmaltheaServices.convertToPicoSeconds(t1).doubleValue());
        BigDecimal v2 = BigDecimal.valueOf(value);
        return AmaltheaServices.createTime(v1.multiply(v2).toBigInteger(), TimeUnit.PS);
    }

    private static @NonNull Time applyToTimes(@NonNull BinaryOperator<BigInteger> func, @NonNull Time t1, @NonNull Time t2) {
        int index2;
        int minIndex;
        BigInteger v1 = t1.getValue();
        BigInteger v2 = t2.getValue();
        if (t1.getUnit() == t2.getUnit()) {
            return AmaltheaServices.createTime((BigInteger)func.apply(v1, v2), t1.getUnit());
        }
        int index1 = TIME_UNIT_LIST.indexOf((Object)t1.getUnit());
        v1 = index1 > (minIndex = Math.min(index1, index2 = TIME_UNIT_LIST.indexOf((Object)t2.getUnit()))) ? v1.multiply(BigInteger.TEN.pow((index1 - minIndex) * 3)) : v1;
        v2 = index2 > minIndex ? v2.multiply(BigInteger.TEN.pow((index2 - minIndex) * 3)) : v2;
        return AmaltheaServices.createTime((BigInteger)func.apply(v1, v2), TIME_UNIT_LIST.get(minIndex));
    }

    private static @NonNull Time createTime(BigInteger value, TimeUnit unit) {
        Time time = AmaltheaFactory.eINSTANCE.createTime();
        time.setValue(value);
        time.setUnit(unit);
        return time;
    }

    public static @NonNull Time getAverageOfTruncatedNormalDistribution(@Nullable Time a, @Nullable Time b, @NonNull Time mean, @NonNull Time sd) {
        AmaltheaServices.checkTimeArgument(mean);
        if (a == null && b == null) {
            return mean;
        }
        AmaltheaServices.checkTimeArgument(sd);
        if (a != null) {
            AmaltheaServices.checkTimeArgument(a);
        }
        if (b != null) {
            AmaltheaServices.checkTimeArgument(b);
        }
        if (a != null && b != null) {
            Preconditions.checkArgument((a.compareTo(b) <= 0 ? 1 : 0) != 0, (Object)ARG_BOUNDS_MESSAGE);
        }
        if (a != null && b != null && a.compareTo(b) == 0) {
            return AmaltheaServices.createTime(a.getValue(), a.getUnit());
        }
        Double alpha = null;
        Double beta = null;
        if (a != null) {
            alpha = a.subtract(mean).divide(sd);
        }
        if (b != null) {
            beta = b.subtract(mean).divide(sd);
        }
        double factor = AmaltheaServices.computeTruncatedNormalDistFactor(alpha, beta);
        return AmaltheaServices.addTime(mean, AmaltheaServices.multiply(sd, factor));
    }

    public static double getAverageOfTruncatedNormalDistribution(@Nullable Number inputA, @Nullable Number inputB, double mean, double sd) {
        Double b;
        if (inputA == null && inputB == null) {
            return mean;
        }
        if (inputA != null && inputB != null && inputA.equals(inputB)) {
            return inputA.doubleValue();
        }
        Double a = inputA != null ? Double.valueOf(inputA.doubleValue()) : null;
        Double d = b = inputB != null ? Double.valueOf(inputB.doubleValue()) : null;
        if (a != null && b != null) {
            Preconditions.checkArgument((a <= b ? 1 : 0) != 0, (Object)ARG_BOUNDS_MESSAGE);
        }
        Double alpha = null;
        Double beta = null;
        if (a != null) {
            alpha = (a - mean) / sd;
        }
        if (b != null) {
            beta = (b - mean) / sd;
        }
        double factor = AmaltheaServices.computeTruncatedNormalDistFactor(alpha, beta);
        return mean + factor * sd;
    }

    private static double computeTruncatedNormalDistFactor(@Nullable Double alpha, @Nullable Double beta) {
        NormalDistribution normDist = new NormalDistribution(null, 0.0, 1.0);
        double pdfAlpha = 0.0;
        double cdfAlpha = 0.0;
        double pdfBeta = 0.0;
        double cdfBeta = 1.0;
        if (alpha != null) {
            pdfAlpha = normDist.density(alpha.doubleValue());
            cdfAlpha = normDist.cumulativeProbability(alpha.doubleValue());
        }
        if (beta != null) {
            pdfBeta = normDist.density(beta.doubleValue());
            cdfBeta = normDist.cumulativeProbability(beta.doubleValue());
        }
        return (pdfAlpha - pdfBeta) / (cdfBeta - cdfAlpha);
    }

    public static Time getAverageOfBetaDistribution(@NonNull Time a, @NonNull Time b, double alpha, double beta) {
        AmaltheaServices.checkTimeArgument(a);
        AmaltheaServices.checkTimeArgument(b);
        Preconditions.checkArgument((a.compareTo(b) <= 0 ? 1 : 0) != 0, (Object)ARG_BOUNDS_MESSAGE);
        Preconditions.checkArgument((alpha > 0.0 ? 1 : 0) != 0, (Object)ARG_POSITIVE_VALUE_MESSAGE);
        Preconditions.checkArgument((beta > 0.0 ? 1 : 0) != 0, (Object)ARG_POSITIVE_VALUE_MESSAGE);
        double ratio = 1.0 / (1.0 + beta / alpha);
        return AmaltheaServices.addTime(a, AmaltheaServices.multiply(AmaltheaServices.subtractTime(b, a), ratio));
    }

    public static Double getAverageOfBetaDistribution(@NonNull Number inputA, @NonNull Number inputB, double alpha, double beta) {
        Preconditions.checkArgument((inputA != null ? 1 : 0) != 0, (String)ARG_NULL_MESSAGE, (Object)NUMBER);
        Preconditions.checkArgument((inputB != null ? 1 : 0) != 0, (String)ARG_NULL_MESSAGE, (Object)NUMBER);
        double a = inputA.doubleValue();
        double b = inputB.doubleValue();
        Preconditions.checkArgument((a <= b ? 1 : 0) != 0, (Object)ARG_BOUNDS_MESSAGE);
        Preconditions.checkArgument((alpha > 0.0 ? 1 : 0) != 0, (Object)ARG_POSITIVE_VALUE_MESSAGE);
        Preconditions.checkArgument((beta > 0.0 ? 1 : 0) != 0, (Object)ARG_POSITIVE_VALUE_MESSAGE);
        double ratio = 1.0 / (1.0 + beta / alpha);
        return a + (b - a) * ratio;
    }

    public static EList<QualifiedPort> getInnerPorts(@NonNull ISystem system) {
        Preconditions.checkArgument((system != null ? 1 : 0) != 0, (String)ARG_NULL_MESSAGE, (Object)"ISystem");
        ArrayList<QualifiedPort> qualifiedPorts = new ArrayList<QualifiedPort>();
        for (ComponentInstance inst : system.getComponentInstances()) {
            if (inst.getType() == null) continue;
            for (ComponentPort port : inst.getType().getPorts()) {
                QualifiedPort qp = AmaltheaFactory.eINSTANCE.createQualifiedPort();
                qp.setInstance(inst);
                qp.setPort(port);
                qualifiedPorts.add(qp);
            }
        }
        @NonNull EReference eReference = AmaltheaPackage.eINSTANCE.getISystem_InnerPorts();
        return AmaltheaServices.unmodifiableEcoreEList(system, eReference, qualifiedPorts);
    }

    public static EList<HwPort> getInnerPorts(@NonNull HwStructure struct) {
        Preconditions.checkArgument((struct != null ? 1 : 0) != 0, (String)ARG_NULL_MESSAGE, (Object)"HwStructure");
        ArrayList<HwPort> ports = new ArrayList<HwPort>();
        for (HwStructure subStruct : struct.getStructures()) {
            ports.addAll((Collection<HwPort>)subStruct.getPorts());
        }
        for (HwModule module : AmaltheaServices.getAllModules(struct)) {
            ports.addAll((Collection<HwPort>)module.getPorts());
        }
        @NonNull EReference eReference = AmaltheaPackage.eINSTANCE.getHwStructure_InnerPorts();
        return AmaltheaServices.unmodifiableEcoreEList(struct, eReference, ports);
    }

    public static EList<HwModule> getAllModules(@NonNull HwStructure struct) {
        Preconditions.checkArgument((struct != null ? 1 : 0) != 0, (String)ARG_NULL_MESSAGE, (Object)"HwStructure");
        ArrayList<HwModule> moduleList = new ArrayList<HwModule>();
        for (HwModule module : struct.getModules()) {
            moduleList.add(module);
            if (!(module instanceof ProcessingUnit)) continue;
            moduleList.addAll((Collection<HwModule>)((ProcessingUnit)module).getCaches());
        }
        return AmaltheaServices.unmodifiableEList(moduleList);
    }

    private static <T> EList<T> unmodifiableEcoreEList(@NonNull EObject eObject, @NonNull EReference eReference, @NonNull List<? extends T> result) {
        int size = result.size();
        Object[] values = result.toArray();
        return new EcoreEList.UnmodifiableEList((InternalEObject)eObject, (EStructuralFeature)eReference, size, values);
    }

    private static <T> EList<T> unmodifiableEList(@NonNull List<? extends T> list) {
        if (list.isEmpty()) {
            return ECollections.emptyEList();
        }
        return ECollections.unmodifiableEList(list);
    }
}

