/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.standard;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.scene.chart.AreaChart;
import javafx.scene.chart.Axis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import org.eclipse.app4mc.amalthea.model.ContinuousValueBetaDistribution;
import org.eclipse.app4mc.amalthea.model.ContinuousValueConstant;
import org.eclipse.app4mc.amalthea.model.ContinuousValueGaussDistribution;
import org.eclipse.app4mc.amalthea.model.ContinuousValueHistogram;
import org.eclipse.app4mc.amalthea.model.ContinuousValueHistogramEntry;
import org.eclipse.app4mc.amalthea.model.ContinuousValueInterval;
import org.eclipse.app4mc.amalthea.model.ContinuousValueStatistics;
import org.eclipse.app4mc.amalthea.model.ContinuousValueWeibullEstimatorsDistribution;
import org.eclipse.app4mc.amalthea.model.DiscreteValueBetaDistribution;
import org.eclipse.app4mc.amalthea.model.DiscreteValueConstant;
import org.eclipse.app4mc.amalthea.model.DiscreteValueGaussDistribution;
import org.eclipse.app4mc.amalthea.model.DiscreteValueHistogram;
import org.eclipse.app4mc.amalthea.model.DiscreteValueHistogramEntry;
import org.eclipse.app4mc.amalthea.model.DiscreteValueInterval;
import org.eclipse.app4mc.amalthea.model.DiscreteValueStatistics;
import org.eclipse.app4mc.amalthea.model.DiscreteValueWeibullEstimatorsDistribution;
import org.eclipse.app4mc.amalthea.model.IContinuousValueDeviation;
import org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation;
import org.eclipse.app4mc.amalthea.model.ITimeDeviation;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeBetaDistribution;
import org.eclipse.app4mc.amalthea.model.TimeConstant;
import org.eclipse.app4mc.amalthea.model.TimeGaussDistribution;
import org.eclipse.app4mc.amalthea.model.TimeHistogram;
import org.eclipse.app4mc.amalthea.model.TimeHistogramEntry;
import org.eclipse.app4mc.amalthea.model.TimeInterval;
import org.eclipse.app4mc.amalthea.model.TimeStatistics;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.TimeWeibullEstimatorsDistribution;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractDeviationChart {
    private static final String CHART_SERIES_AREA_LINE = ".chart-series-area-line";
    private static final String CHART_SERIES_AREA_FILL = ".chart-series-area-fill";
    protected static final List<String> DEVIATION_LIST = Collections.unmodifiableList(Arrays.asList("Constant", "Histogram", "Boundaries", "Statistic", "Uniform", "Beta", "Gauss", "Weibull"));

    protected AreaChart<Number, Number> createChart(EObject object, String unit) {
        NumberAxis xAxis = new NumberAxis();
        String part1 = this.getXAxisType(object, "values");
        String part2 = unit == null || unit.isEmpty() ? "" : " [" + unit + "]";
        xAxis.setLabel(String.valueOf(part1) + part2);
        xAxis.setForceZeroInRange(false);
        xAxis.setMinorTickVisible(false);
        NumberAxis yAxis = new NumberAxis();
        yAxis.setLabel("density");
        yAxis.setForceZeroInRange(false);
        yAxis.setTickMarkVisible(false);
        yAxis.setTickLabelsVisible(false);
        yAxis.setMinorTickVisible(false);
        AreaChart chart = new AreaChart((Axis)xAxis, (Axis)yAxis);
        chart.setTitle(this.getChartTitle(object));
        chart.setAnimated(false);
        chart.setVerticalGridLinesVisible(false);
        chart.setHorizontalGridLinesVisible(false);
        chart.setLegendVisible(false);
        chart.lookup(".chart-vertical-zero-line").setStyle("-fx-stroke: rgba(0, 0, 0, 0.0);");
        return chart;
    }

    private String getChartTitle(EObject object) {
        if (object != null) {
            String className = object.eClass().getName();
            for (String deviation : DEVIATION_LIST) {
                if (!className.contains(deviation)) continue;
                return deviation;
            }
        }
        return null;
    }

    private String getXAxisType(EObject object, String defaultText) {
        if (object != null && object.eContainer() != null && object.eContainingFeature() != null) {
            String containerClassName = object.eContainer().eClass().getName();
            String featureName = object.eContainingFeature().getName();
            if (containerClassName.contains("Ticks")) {
                return "ticks";
            }
            if (object.eClass().getName().contains("Time")) {
                return "time";
            }
            if (featureName.contains("Latency")) {
                return "cycles";
            }
            if (featureName.contains("occurrences")) {
                return "occurrences";
            }
        }
        return defaultText;
    }

    protected void setChartXBounds(AreaChart<Number, Number> chart, double lowerBound, double upperBound) {
        if (lowerBound >= upperBound) {
            return;
        }
        if (chart.getXAxis() instanceof NumberAxis) {
            NumberAxis axis = (NumberAxis)chart.getXAxis();
            axis.setAutoRanging(false);
            axis.setLowerBound(lowerBound);
            axis.setUpperBound(upperBound);
            axis.setMinorTickCount(0);
            axis.setTickUnit((upperBound - lowerBound) / 5.0);
        }
    }

    protected void setChartYBounds(AreaChart<Number, Number> chart, double upperBound) {
        if (chart.getYAxis() instanceof NumberAxis) {
            NumberAxis axis = (NumberAxis)chart.getYAxis();
            axis.setAutoRanging(false);
            axis.setLowerBound(0.0);
            axis.setUpperBound(upperBound);
        }
    }

    protected void addSeriesStandard(AreaChart<Number, Number> chart, XYChart.Series<Number, Number> series) {
        if (series.getData().isEmpty()) {
            return;
        }
        chart.getData().add(series);
        series.getNode().lookup(CHART_SERIES_AREA_LINE).setStyle("-fx-stroke: rgba(0, 128, 0, 1.0);");
        series.getNode().lookup(CHART_SERIES_AREA_FILL).setStyle("-fx-fill: rgba(0, 128, 0, 0.15);");
        for (XYChart.Data data : series.getData()) {
            data.getNode().setVisible(false);
        }
    }

    protected void addSeriesOffLimit(AreaChart<Number, Number> chart, XYChart.Series<Number, Number> series) {
        if (series.getData().isEmpty()) {
            return;
        }
        chart.getData().add(series);
        series.getNode().lookup(CHART_SERIES_AREA_LINE).setStyle("-fx-stroke: rgba(128, 128, 128, 1.0); -fx-stroke-dash-array: 2;");
        series.getNode().lookup(CHART_SERIES_AREA_FILL).setStyle("-fx-fill: rgba(0, 0, 0, 0.0);");
        for (XYChart.Data data : series.getData()) {
            data.getNode().setVisible(false);
        }
    }

    protected void addSeriesGradient(AreaChart<Number, Number> chart, XYChart.Series<Number, Number> series) {
        if (series.getData().isEmpty()) {
            return;
        }
        chart.getData().add(series);
        series.getNode().lookup(CHART_SERIES_AREA_LINE).setStyle("-fx-stroke: rgba(0, 0, 0, 0.0);");
        series.getNode().lookup(CHART_SERIES_AREA_FILL).setStyle("-fx-fill: linear-gradient(to top, rgba(0, 128, 0, 0.3), rgba(0, 128, 0, 0.0));");
        for (XYChart.Data data : series.getData()) {
            data.getNode().setVisible(false);
        }
    }

    protected void addSinglePeek(AreaChart<Number, Number> chart, double y, double x) {
        if (chart.getYAxis() instanceof NumberAxis) {
            XYChart.Series series = new XYChart.Series();
            chart.getData().add((Object)series);
            series.getData().add((Object)new XYChart.Data((Object)x, (Object)0.0));
            series.getData().add((Object)new XYChart.Data((Object)x, (Object)y));
            series.getNode().lookup(CHART_SERIES_AREA_LINE).setStyle("-fx-stroke: rgba(0, 128, 0, 1.0);");
            ((XYChart.Data)series.getData().get(1)).getNode().setVisible(false);
        }
    }

    protected void addMarkers(AreaChart<Number, Number> chart, double y, Double min, Double avg, Double max) {
        if (chart.getYAxis() instanceof NumberAxis) {
            XYChart.Series series;
            if (min != null) {
                series = new XYChart.Series();
                chart.getData().add((Object)series);
                series.setName("min");
                series.getData().add((Object)new XYChart.Data((Object)min, (Object)0.0));
                series.getData().add((Object)new XYChart.Data((Object)min, (Object)y));
                series.getNode().lookup(CHART_SERIES_AREA_LINE).setStyle("-fx-stroke: rgba(0, 0, 0, 1.0);");
                ((XYChart.Data)series.getData().get(1)).getNode().setVisible(false);
            }
            if (max != null) {
                series = new XYChart.Series();
                chart.getData().add((Object)series);
                series.setName("max");
                series.getData().add((Object)new XYChart.Data((Object)max, (Object)0.0));
                series.getData().add((Object)new XYChart.Data((Object)max, (Object)y));
                series.getNode().lookup(CHART_SERIES_AREA_LINE).setStyle("-fx-stroke: rgba(0, 0, 0, 1.0);");
                ((XYChart.Data)series.getData().get(1)).getNode().setVisible(false);
            }
            if (avg != null) {
                series = new XYChart.Series();
                chart.getData().add((Object)series);
                series.setName("avg");
                series.getData().add((Object)new XYChart.Data((Object)avg, (Object)0.0));
                series.getData().add((Object)new XYChart.Data((Object)avg, (Object)y));
                series.getNode().lookup(CHART_SERIES_AREA_LINE).setStyle("-fx-stroke: rgba(150, 5, 5, 1.0); -fx-stroke-dash-array: 3;");
                ((XYChart.Data)series.getData().get(1)).getNode().setVisible(false);
            }
        }
    }

    public boolean isValid(IDiscreteValueDeviation dev) {
        if (dev instanceof DiscreteValueConstant) {
            return true;
        }
        if (dev instanceof DiscreteValueHistogram) {
            EList entries = ((DiscreteValueHistogram)dev).getEntries();
            if (entries.isEmpty()) {
                return false;
            }
            for (DiscreteValueHistogramEntry entry : entries) {
                Long lowerBound = entry.getLowerBound();
                Long upperBound = entry.getUpperBound();
                if (lowerBound == null) {
                    return false;
                }
                if (upperBound == null) {
                    return false;
                }
                if (lowerBound.compareTo(upperBound) > 0) {
                    return false;
                }
                if (entry.getOccurrences() >= 0L) continue;
                return false;
            }
            return true;
        }
        if (dev instanceof DiscreteValueInterval) {
            DiscreteValueInterval interval = (DiscreteValueInterval)dev;
            Long lowerBound = interval.getLowerBound();
            Long upperBound = interval.getUpperBound();
            if (lowerBound == null) {
                return false;
            }
            if (upperBound == null) {
                return false;
            }
            if (!this.isValidMinAvgMax(lowerBound.doubleValue(), this.getAverage(interval), upperBound.doubleValue())) {
                return false;
            }
        }
        if (dev instanceof DiscreteValueWeibullEstimatorsDistribution) {
            DiscreteValueWeibullEstimatorsDistribution weibullDist = (DiscreteValueWeibullEstimatorsDistribution)dev;
            double promille = weibullDist.getPRemainPromille();
            return promille > 0.0 && promille < 1000.0;
        }
        if (dev instanceof DiscreteValueBetaDistribution) {
            DiscreteValueBetaDistribution betaDist = (DiscreteValueBetaDistribution)dev;
            return betaDist.getAlpha() > 0.0 && betaDist.getBeta() > 0.0;
        }
        if (dev instanceof DiscreteValueGaussDistribution) {
            DiscreteValueGaussDistribution gaussDist = (DiscreteValueGaussDistribution)dev;
            if (gaussDist.getSd() <= 0.0) {
                return false;
            }
            if (!this.isValidMinAvgMax(gaussDist.getLowerBound(), null, gaussDist.getUpperBound())) {
                return false;
            }
        }
        return true;
    }

    public boolean isValid(IContinuousValueDeviation dev) {
        if (dev instanceof ContinuousValueConstant) {
            return true;
        }
        if (dev instanceof ContinuousValueHistogram) {
            EList entries = ((ContinuousValueHistogram)dev).getEntries();
            if (entries.isEmpty()) {
                return false;
            }
            for (ContinuousValueHistogramEntry entry : entries) {
                Double lowerBound = entry.getLowerBound();
                Double upperBound = entry.getUpperBound();
                if (lowerBound == null) {
                    return false;
                }
                if (upperBound == null) {
                    return false;
                }
                if (lowerBound.compareTo(upperBound) > 0) {
                    return false;
                }
                if (entry.getOccurrences() >= 0L) continue;
                return false;
            }
            return true;
        }
        if (dev instanceof ContinuousValueInterval) {
            ContinuousValueInterval interval = (ContinuousValueInterval)dev;
            Double lowerBound = interval.getLowerBound();
            Double upperBound = interval.getUpperBound();
            if (lowerBound == null) {
                return false;
            }
            if (upperBound == null) {
                return false;
            }
            if (!this.isValidMinAvgMax(lowerBound, this.getAverage(interval), upperBound)) {
                return false;
            }
        }
        if (dev instanceof ContinuousValueWeibullEstimatorsDistribution) {
            ContinuousValueWeibullEstimatorsDistribution weibullDist = (ContinuousValueWeibullEstimatorsDistribution)dev;
            double promille = weibullDist.getPRemainPromille();
            return promille > 0.0 && promille < 1000.0;
        }
        if (dev instanceof ContinuousValueBetaDistribution) {
            ContinuousValueBetaDistribution betaDist = (ContinuousValueBetaDistribution)dev;
            return betaDist.getAlpha() > 0.0 && betaDist.getBeta() > 0.0;
        }
        if (dev instanceof ContinuousValueGaussDistribution) {
            ContinuousValueGaussDistribution gaussDist = (ContinuousValueGaussDistribution)dev;
            if (gaussDist.getSd() <= 0.0) {
                return false;
            }
            if (!this.isValidMinAvgMax(gaussDist.getLowerBound(), null, gaussDist.getUpperBound())) {
                return false;
            }
        }
        return true;
    }

    public boolean isValid(ITimeDeviation dev) {
        TimeStatistics statistics;
        if (dev instanceof TimeConstant) {
            return this.isValidTime(((TimeConstant)dev).getValue());
        }
        if (dev instanceof TimeHistogram) {
            EList entries = ((TimeHistogram)dev).getEntries();
            if (entries.isEmpty()) {
                return false;
            }
            for (TimeHistogramEntry entry : entries) {
                Time lowerBound = entry.getLowerBound();
                Time upperBound = entry.getUpperBound();
                if (!this.isValidTime(lowerBound)) {
                    return false;
                }
                if (!this.isValidTime(upperBound)) {
                    return false;
                }
                if (lowerBound.compareTo(upperBound) > 0) {
                    return false;
                }
                if (entry.getOccurrences() >= 0L) continue;
                return false;
            }
            return true;
        }
        if (dev instanceof TimeStatistics && !this.isValidTime((statistics = (TimeStatistics)dev).getAverage())) {
            return false;
        }
        if (dev instanceof TimeWeibullEstimatorsDistribution) {
            TimeWeibullEstimatorsDistribution weibullDist = (TimeWeibullEstimatorsDistribution)dev;
            if (!this.isValidTime(weibullDist.getAverage())) {
                return false;
            }
            double promille = weibullDist.getPRemainPromille();
            if (promille <= 0.0) {
                return false;
            }
            if (promille >= 1000.0) {
                return false;
            }
        }
        if (dev instanceof TimeInterval) {
            TimeInterval interval = (TimeInterval)dev;
            Time lowerBound = interval.getLowerBound();
            Time upperBound = interval.getUpperBound();
            if (!this.isValidTime(lowerBound)) {
                return false;
            }
            if (!this.isValidTime(upperBound)) {
                return false;
            }
            if (!this.isValidMinAvgMax(lowerBound, this.getAverage(interval), upperBound)) {
                return false;
            }
        }
        if (dev instanceof TimeBetaDistribution) {
            TimeBetaDistribution betaDist = (TimeBetaDistribution)dev;
            return betaDist.getAlpha() > 0.0 && betaDist.getBeta() > 0.0;
        }
        if (dev instanceof TimeGaussDistribution) {
            TimeGaussDistribution gaussDist = (TimeGaussDistribution)dev;
            Time mean = gaussDist.getMean();
            Time sd = gaussDist.getSd();
            if (!this.isValidTime(mean)) {
                return false;
            }
            if (!this.isValidTime(sd)) {
                return false;
            }
            if (sd.getValue().signum() < 1) {
                return false;
            }
            if (!this.isValidMinAvgMax(gaussDist.getLowerBound(), null, gaussDist.getUpperBound())) {
                return false;
            }
        }
        return true;
    }

    public boolean isValidTime(Time time) {
        return time != null && time.getValue() != null && time.getUnit() != TimeUnit._UNDEFINED_;
    }

    public <T extends Comparable<T>> boolean isValidMinAvgMax(T min, T avg, T max) {
        return this.isSinglePeek(min, max) || this.isValidRange(min, avg, max);
    }

    public <T extends Comparable<T>> boolean isSinglePeek(T min, T max) {
        return min != null && max != null && min.compareTo(max) == 0;
    }

    public <T extends Comparable<T>> boolean isValidRange(T min, T avg, T max) {
        if (min != null && max != null && min.compareTo(max) >= 0) {
            return false;
        }
        if (min != null && avg != null && min.compareTo(avg) >= 0) {
            return false;
        }
        return avg == null || max == null || avg.compareTo(max) < 0;
    }

    public Time getAverage(TimeInterval obj) {
        Time avg = null;
        if (obj instanceof TimeStatistics) {
            avg = ((TimeStatistics)obj).getAverage();
        }
        if (obj instanceof TimeWeibullEstimatorsDistribution) {
            avg = ((TimeWeibullEstimatorsDistribution)obj).getAverage();
        }
        return avg;
    }

    public Double getAverage(DiscreteValueInterval obj) {
        Double avg = null;
        if (obj instanceof DiscreteValueStatistics) {
            avg = ((DiscreteValueStatistics)obj).getAverage();
        }
        if (obj instanceof DiscreteValueWeibullEstimatorsDistribution) {
            avg = ((DiscreteValueWeibullEstimatorsDistribution)obj).getAverage();
        }
        return avg;
    }

    public Double getAverage(ContinuousValueInterval obj) {
        Double avg = null;
        if (obj instanceof ContinuousValueStatistics) {
            avg = ((ContinuousValueStatistics)obj).getAverage();
        }
        if (obj instanceof ContinuousValueWeibullEstimatorsDistribution) {
            avg = ((ContinuousValueWeibullEstimatorsDistribution)obj).getAverage();
        }
        return avg;
    }
}

