/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb.metrics;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.app4mc.atdb.metrics.EventType;
import org.eclipse.app4mc.atdb.metrics.Metric;
import org.eclipse.app4mc.atdb.metrics.Process;
import org.eclipse.core.resources.IFile;

public class DatabaseAccess {
    private Connection traceDbConnection;
    private Map<Integer, EventType> eventToIdMap;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$app4mc$atdb$metrics$EventType;

    public void connectToDatabase(IFile databaseFile) throws SQLException, ClassNotFoundException {
        Class.forName("org.sqlite.JDBC");
        String connectionStr = "jdbc:sqlite:";
        connectionStr = String.valueOf(connectionStr) + databaseFile.getLocation().toFile().toString();
        Properties properties = new Properties();
        properties.put("open_mode", "1");
        this.traceDbConnection = DriverManager.getConnection(connectionStr, properties);
    }

    public void closeDatabaseConnection() throws SQLException {
        this.traceDbConnection.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String readTimestampUnit() throws SQLException {
        String result = null;
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            Statement statement = this.traceDbConnection.createStatement();
            try {
                try (ResultSet resultSet = statement.executeQuery("SELECT Value FROM MetaInformation WHERE Name LIKE 'time_base'");){
                    if (resultSet.next()) {
                        result = resultSet.getString(1);
                    }
                }
                if (statement == null) return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (statement == null) throw throwable;
                statement.close();
                throw throwable;
            }
            statement.close();
            return result;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Process> loadProcesses() throws SQLException {
        ArrayList<Process> result = new ArrayList<Process>();
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            Statement statement = this.traceDbConnection.createStatement();
            try {
                try (ResultSet resultSet = statement.executeQuery("SELECT a.Id, a.Name, a.HasEvents, a.EventTableName FROM Entity AS a JOIN EntityType AS b ON a.EntityTypeId = b.Id WHERE b.Name LIKE 'task' OR b.Name LIKE 'isr'");){
                    while (resultSet.next()) {
                        int primaryKey = resultSet.getInt("Id");
                        String name = resultSet.getString("Name");
                        boolean hasEvents = resultSet.getBoolean("HasEvents");
                        String databaseTableName = null;
                        if (hasEvents) {
                            databaseTableName = resultSet.getString("EventTableName");
                        }
                        Process process = new Process(primaryKey, name, databaseTableName);
                        result.add(process);
                    }
                }
                if (statement == null) return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (statement == null) throw throwable;
                statement.close();
                throw throwable;
            }
            statement.close();
            return result;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadEventToIdMap() throws SQLException {
        this.eventToIdMap = new HashMap<Integer, EventType>();
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            Statement statement = this.traceDbConnection.createStatement();
            try {
                try (ResultSet resultSet = statement.executeQuery("SELECT Id, Name FROM EventType");){
                    while (resultSet.next()) {
                        Integer id = resultSet.getInt("Id");
                        String eventName = resultSet.getString("Name");
                        try {
                            EventType eventType = EventType.valueOf(eventName.toUpperCase());
                            this.eventToIdMap.put(id, eventType);
                        }
                        catch (Exception exception) {}
                    }
                }
                if (statement == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (statement == null) throw throwable;
                statement.close();
                throw throwable;
            }
            statement.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    public List<Metric> calculateMetrcisForProcess(Process process) throws SQLException {
        if (this.eventToIdMap == null) {
            this.loadEventToIdMap();
        }
        eventSelection = "SELECT TimeStamp, EntityInstanceId, EventTypeId FROM '" + process.databaseTableName + "' WHERE EntityId = " + process.primaryKey + " ORDER BY EntityInstanceId, TimeStamp";
        instancesResponeTime = 0;
        minimumResponseTime = 0x7FFFFFFFFFFFFFFFL;
        maximumResponseTime = 0L;
        sumResponseTime = 0L;
        instancesGrossExecutionTime = 0;
        minimumGrossExecutionTime = 0x7FFFFFFFFFFFFFFFL;
        maximumGrossExecutionTime = 0L;
        sumGrossExecution = 0L;
        currentInstanceId = -1;
        timestampActivate = -1L;
        timestampStart = -1L;
        timestampTerminate = -1L;
        var24_15 = null;
        var25_17 = null;
        try {
            statement = this.traceDbConnection.createStatement();
            try {
                resultSet = statement.executeQuery(eventSelection);
                try {
                    while (resultSet.next()) {
                        timestamp = resultSet.getLong(1);
                        instanceId = resultSet.getInt(2);
                        eventTypeId = resultSet.getInt(3);
                        if (instanceId != currentInstanceId) {
                            currentInstanceId = instanceId;
                            timestampActivate = -1L;
                            timestampStart = -1L;
                            timestampTerminate = -1L;
                        }
                        if ((eventType = this.eventToIdMap.get(eventTypeId)) == null) continue;
                        switch (DatabaseAccess.$SWITCH_TABLE$org$eclipse$app4mc$atdb$metrics$EventType()[eventType.ordinal()]) {
                            case 1: {
                                timestampActivate = timestamp;
                                break;
                            }
                            case 2: {
                                timestampStart = timestamp;
                                break;
                            }
                            case 12: {
                                timestampTerminate = timestamp;
                                if (timestampActivate > -1L) {
                                    responseTime = timestampTerminate - timestampActivate;
                                    minimumResponseTime = Math.min(minimumResponseTime, responseTime);
                                    maximumResponseTime = Math.max(maximumResponseTime, responseTime);
                                    sumResponseTime += responseTime;
                                    ++instancesResponeTime;
                                }
                                if (timestampStart <= -1L) break;
                                grossExecutionTime = timestampTerminate - timestampStart;
                                minimumGrossExecutionTime = Math.min(minimumGrossExecutionTime, grossExecutionTime);
                                maximumGrossExecutionTime = Math.max(maximumGrossExecutionTime, grossExecutionTime);
                                sumGrossExecution += grossExecutionTime;
                                ++instancesGrossExecutionTime;
                                break;
                            }
                        }
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                ** if (statement == null) goto lbl-1000
            }
            catch (Throwable var25_18) {
                if (var24_15 == null) {
                    var24_15 = var25_18;
                } else if (var24_15 != var25_18) {
                    var24_15.addSuppressed(var25_18);
                }
                if (statement != null) {
                    statement.close();
                }
                throw var24_15;
            }
lbl-1000:
            // 1 sources

            {
                statement.close();
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        catch (Throwable var25_19) {
            if (var24_15 == null) {
                var24_15 = var25_19;
            } else if (var24_15 != var25_19) {
                var24_15.addSuppressed(var25_19);
            }
            throw var24_15;
        }
        result = new ArrayList<Metric>(2);
        if (instancesResponeTime > 0) {
            avg = sumResponseTime / (long)instancesResponeTime;
            result.add(new Metric("Response Time", minimumResponseTime, avg, maximumResponseTime));
        }
        if (instancesGrossExecutionTime > 0) {
            avg = sumGrossExecution / (long)instancesGrossExecutionTime;
            result.add(new Metric("Gross Execution Time", minimumGrossExecutionTime, avg, maximumGrossExecutionTime));
        }
        return result;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$app4mc$atdb$metrics$EventType() {
        if ($SWITCH_TABLE$org$eclipse$app4mc$atdb$metrics$EventType != null) {
            return $SWITCH_TABLE$org$eclipse$app4mc$atdb$metrics$EventType;
        }
        int[] nArray = new int[EventType.values().length];
        try {
            nArray[EventType.ACTIVATE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EventType.PARK.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EventType.POLL.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EventType.POLL_PARKING.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EventType.PREEMPT.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EventType.RELEASE.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EventType.RELEASE_PARKING.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EventType.RESUME.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EventType.RUN.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EventType.START.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EventType.TERMINATE.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EventType.WAIT.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$app4mc$atdb$metrics$EventType = nArray;
        return nArray;
    }
}

