/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters093.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters093.utils.HelperUtils_092_093;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.9.2", "output_model_version=0.9.3"}, service={IConverter.class})
public class MeasurementConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MeasurementConverter.class);

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) {
        LOGGER.info("Migration from 0.9.2 to 0.9.3 : Executing Measurement converter for model file : {}", (Object)targetFile.getName());
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.update_Stimuli(rootElement);
    }

    private void update_Stimuli(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./measurementModel/measurements");
        List measurementElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._093, (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element measurementElement : measurementElements) {
            Element runtimeDeviation_Time_element = measurementElement.getChild("runtimeDeviation");
            if (runtimeDeviation_Time_element == null) continue;
            Element migratedElement = HelperUtils_092_093.migrateDeviationElement_Containing_TimeValue(runtimeDeviation_Time_element, "runtimeDeviation");
            int indexOf = measurementElement.indexOf((Content)runtimeDeviation_Time_element);
            measurementElement.removeContent((Content)runtimeDeviation_Time_element);
            if (migratedElement == null) continue;
            measurementElement.addContent(indexOf, (Content)migratedElement);
        }
    }
}

