/**
 ********************************************************************************
 * Copyright (c) 2015-2020 Eclipse APP4MC contributors.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 ********************************************************************************
 */

package org.eclipse.app4mc.atdb.metrics;

import java.text.NumberFormat;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class MetricViewerLabelProvider extends LabelProvider implements ITableLabelProvider {

	@Override
	public Image getColumnImage(final Object element, final int columnIndex) {
		return null;
	}

	@Override
	public String getColumnText(final Object element, final int columnIndex) {
		if (element instanceof Process) {
			return (columnIndex == 0) ? ((Process) element).name : ""; //$NON-NLS-1$
		}

		if (element instanceof Metric) {
			final Metric metric = (Metric) element;
			switch (columnIndex) {
			case 0:
				return metric.name;
			case 1:
				return NumberFormat.getInstance().format(metric.minimum);
			case 2:
				return NumberFormat.getInstance().format(metric.average);
			case 3:
				return NumberFormat.getInstance().format(metric.maximum);
			default:
				return ""; //$NON-NLS-1$
			}
		}

		return ""; //$NON-NLS-1$
	}

}
