/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.LabelPosition;
import org.eclipse.sirius.diagram.ui.business.api.query.DDiagramGraphicalQuery;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Version;

public class LabelOnBorderMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    public static final Version MIGRATION_VERSION = new Version("14.3.0.201908231800");
    private boolean migrationOccured;

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            super.postLoad(dAnalysis, loadedVersion);
            StringBuilder sb = new StringBuilder(Messages.LabelOnBorderMigrationParticipant_title);
            dAnalysis.getOwnedViews().stream().flatMap(view -> new DViewQuery(view).getLoadedRepresentations().stream()).filter(rep -> rep instanceof DDiagram).map(DDiagram.class::cast).forEach(dDiagram -> {
                boolean isLabelMoved = false;
                Collection<Node> nodesWithLabelOnBorder = this.getNodesWithLabelOnBorder((DDiagram)dDiagram);
                for (Node node : nodesWithLabelOnBorder) {
                    boolean bl = isLabelMoved = this.checkAndFixGMFCoordinatesOfLabelOnBorder(node) || isLabelMoved;
                }
                if (isLabelMoved) {
                    this.migrationOccured = true;
                    sb.append(MessageFormat.format(Messages.LabelOnBorderMigrationParticipant_labelsModified, dDiagram.getName()));
                }
            });
            if (this.migrationOccured) {
                DiagramPlugin.getDefault().logInfo(sb.toString());
                this.migrationOccured = false;
            }
        }
    }

    private boolean checkAndFixGMFCoordinatesOfLabelOnBorder(final Node node) {
        boolean isLabelMoved = false;
        for (Object child : node.getChildren()) {
            Dimension labelSize;
            Node childNode;
            int id;
            if (!(child instanceof Node) || (id = SiriusVisualIDRegistry.getVisualID((childNode = (Node)child).getType())) != 5002 && id != 5001 && id != 5003 && id != 5010) continue;
            LayoutConstraint labelLayoutConstraint = childNode.getLayoutConstraint();
            LayoutConstraint nodeLayoutConstraint = node.getLayoutConstraint();
            if (!(labelLayoutConstraint instanceof Location) || !(nodeLayoutConstraint instanceof Size)) continue;
            if (Display.getCurrent() != null) {
                labelSize = GMFHelper.getLabelDimension(node, new Dimension(50, 20));
            } else {
                RunnableWithResult.Impl<Dimension> getLabelDimension = new RunnableWithResult.Impl<Dimension>(){

                    public void run() {
                        this.setResult(GMFHelper.getLabelDimension(node, new Dimension(50, 20)));
                    }
                };
                EclipseUIUtil.displaySyncExec((Runnable)getLabelDimension);
                labelSize = (Dimension)getLabelDimension.getResult();
            }
            Size nodeSize = (Size)nodeLayoutConstraint;
            Dimension computedNodeSize = nodeSize.getHeight() == -1 && nodeSize.getWidth() == -1 ? GMFHelper.getAbsoluteBounds(node).getSize() : new Dimension(nodeSize.getWidth(), nodeSize.getHeight());
            Location currentLabelLocation = (Location)labelLayoutConstraint;
            if (labelSize.width() <= computedNodeSize.width() || currentLabelLocation.getY() >= 0 && currentLabelLocation.getY() <= computedNodeSize.height()) continue;
            boolean bl = isLabelMoved = this.computeNewLocation(labelSize, computedNodeSize, currentLabelLocation) || isLabelMoved;
        }
        return isLabelMoved;
    }

    private boolean computeNewLocation(Dimension labelSize, Dimension nodeSize, Location currentLabelLocation) {
        int newY;
        boolean isSameLocation = true;
        int newX = -(labelSize.width() - nodeSize.width()) / 2;
        if (newX != currentLabelLocation.getX()) {
            isSameLocation = false;
            currentLabelLocation.setX(-(labelSize.width() - nodeSize.width()) / 2);
        }
        if ((newY = currentLabelLocation.getY() < 0 ? IBorderItemOffsets.NO_OFFSET.height() - labelSize.height() : nodeSize.height() - IBorderItemOffsets.NO_OFFSET.height()) != currentLabelLocation.getY()) {
            isSameLocation = false;
            currentLabelLocation.setY(newY);
        }
        return !isSameLocation;
    }

    private Collection<Node> getNodesWithLabelOnBorder(DDiagram dDiagram) {
        HashSet<Node> nodes = new HashSet<Node>();
        DDiagramGraphicalQuery query = new DDiagramGraphicalQuery(dDiagram);
        Option<Diagram> gmfDiagram = query.getAssociatedGMFDiagram();
        if (gmfDiagram.some()) {
            ((Diagram)gmfDiagram.get()).eAllContents().forEachRemaining(eObject -> {
                Node node;
                if (eObject instanceof Node && this.isNodeWithLabelOnBorder(node = (Node)eObject)) {
                    nodes.add(node);
                }
            });
        }
        return nodes;
    }

    private boolean isNodeWithLabelOnBorder(Node node) {
        int id = SiriusVisualIDRegistry.getVisualID(node.getType());
        if (id == 2001 || id == 3001 || id == 3007 || id == 3012) {
            EObject element = node.getElement();
            return element instanceof DNode && ((DNode)element).getLabelPosition().equals((Object)LabelPosition.BORDER_LITERAL);
        }
        return false;
    }
}

