/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.widget.comunication;

import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.view.mxGraph;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.eclipse.app4mc.multicore.execution.ui.widget.eventcanves.SimpleLabelChain;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.XContainer;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.XUtil;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XAccess;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XRunnable;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XScheduler;

public class ComUtil {
    private static final int MAXELEMENT = 100;

    public static void taskInfo(String title, long start, double end, boolean underSampling, boolean overSampling, LinkedList<CollumEntry> outOver, LinkedList<CollumEntry> outUnder) {
        Insets minPadding = new Insets(5.0);
        Object tableOver = outOver.size() > 0 ? ComUtil.tabelFactory(outOver) : new Label("No Producer found");
        Object tableUnder = outUnder.size() > 0 ? ComUtil.tabelFactory(outUnder) : new Label("No Consumer found");
        VBox header = new VBox();
        Label label = new Label(title);
        label.setFont(new Font("Arial", 20.0));
        label.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
        header.getChildren().add((Object)label);
        HBox resTime = new HBox();
        HBox samp = new HBox();
        Label st = new Label("Start: " + start);
        st.setFont(new Font("Arial", 14.0));
        st.setPadding(minPadding);
        Label en = new Label("End: " + end);
        en.setFont(new Font("Arial", 14.0));
        en.setPadding(minPadding);
        resTime.getChildren().add((Object)st);
        resTime.getChildren().add((Object)en);
        resTime.setPadding(minPadding);
        Label over = new Label("Oversampling: " + overSampling);
        over.setFont(new Font("Arial", 14.0));
        over.setPadding(minPadding);
        Label under = new Label("Undersampling: " + underSampling);
        under.setFont(new Font("Arial", 14.0));
        under.setPadding(minPadding);
        samp.getChildren().add((Object)over);
        samp.getChildren().add((Object)under);
        samp.setPadding(minPadding);
        header.getChildren().add((Object)resTime);
        header.getChildren().add((Object)samp);
        ScrollPane layout = new ScrollPane();
        VBox vbox = new VBox();
        vbox.setSpacing(5.0);
        vbox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        vbox.getChildren().addAll((Object[])new Node[]{header, new Label("Producer"), tableOver, new Label("Consumer"), tableUnder});
        tableOver.prefWidthProperty().bind((ObservableValue)layout.widthProperty());
        tableUnder.prefWidthProperty().bind((ObservableValue)layout.widthProperty());
        layout.setContent((Node)vbox);
        layout.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        layout.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        Scene scene = new Scene((Parent)layout);
        Stage newWindow = new Stage();
        newWindow.setTitle(title);
        newWindow.setScene(scene);
        newWindow.setX(230.0);
        newWindow.setY(100.0);
        newWindow.setMinWidth(400.0);
        newWindow.setMaximized(true);
        newWindow.show();
    }

    private static Region tabelFactory(LinkedList<CollumEntry> inp) {
        ObservableList data = FXCollections.observableList(inp);
        TableView table = new TableView();
        table.setEditable(true);
        TableColumn e1 = new TableColumn("Name");
        TableColumn e2 = new TableColumn("Start Time");
        TableColumn e3 = new TableColumn("Status");
        TableColumn e4 = new TableColumn("Over-/UnderSampling");
        TableColumn e5 = new TableColumn("Type");
        e2.setStyle("-fx-alignment: CENTER;");
        e3.setStyle("-fx-alignment: CENTER;");
        e4.setStyle("-fx-alignment: CENTER;");
        e5.setStyle("-fx-alignment: CENTER;");
        e1.setCellValueFactory((Callback)new PropertyValueFactory("e1"));
        e2.setCellValueFactory((Callback)new PropertyValueFactory("e2"));
        e3.setCellValueFactory((Callback)new PropertyValueFactory("e3"));
        e4.setCellValueFactory((Callback)new PropertyValueFactory("e4"));
        e5.setCellValueFactory((Callback)new PropertyValueFactory("e5"));
        table.setItems(data);
        table.getColumns().addAll((Object[])new TableColumn[]{e1, e2, e3, e4, e5});
        return table;
    }

    public static void PopUpWindow(String title, String inString) {
        Label text = new Label(inString);
        StackPane secondaryLayout = new StackPane();
        secondaryLayout.getChildren().add((Object)text);
        int scale = 3;
        Scene secondScene = new Scene((Parent)secondaryLayout, (double)(230 * scale), (double)(100 * scale));
        Stage newWindow = new Stage();
        newWindow.setTitle(title);
        newWindow.setScene(secondScene);
        newWindow.setAlwaysOnTop(true);
        newWindow.setX(230.0);
        newWindow.setY(100.0);
        newWindow.show();
    }

    public static void openManual() {
        StackPane secondaryLayout = new StackPane();
        int scale = 4;
        Scene secondScene = new Scene((Parent)secondaryLayout, (double)(160 * scale), (double)(100 * scale));
        WebView browser = new WebView();
        WebEngine webEngine = browser.getEngine();
        String url = "https://gsocdoku.echo5.me/";
        webEngine.load(url);
        secondaryLayout.getChildren().add((Object)browser);
        Stage newWindow = new Stage();
        newWindow.setTitle("Manual");
        newWindow.setScene(secondScene);
        newWindow.setX(230.0);
        newWindow.setY(100.0);
        newWindow.show();
    }

    public static void PopUpTable(String title, String fromTo, String time, String labels) {
        Stage stage = new Stage();
        stage.setTitle(title);
        Scene scene = new Scene((Parent)new Group());
        stage.setX(230.0);
        stage.setY(100.0);
        Label label = new Label(fromTo);
        label.setFont(new Font("Arial", 20.0));
        Label labelTime = new Label(time);
        label.setFont(new Font("Arial", 14.0));
        XContainer container = XContainer.getInstance(null);
        String[] arr = labels.split(",");
        int x = 0;
        while (x < arr.length) {
            int n = x;
            arr[n] = String.valueOf(arr[n]) + " - " + container.getLabels().get(arr[x]).getSizeInBytes() + " Byte";
            ++x;
        }
        List<String> xLabel = Arrays.asList(arr);
        ListView list = new ListView();
        ObservableList items = FXCollections.observableArrayList(xLabel);
        list.setItems(items);
        VBox vbox = new VBox();
        vbox.setSpacing(5.0);
        vbox.setPadding(new Insets(10.0, 0.0, 0.0, 10.0));
        vbox.getChildren().addAll((Object[])new Node[]{label, labelTime, list});
        ((Group)scene.getRoot()).getChildren().addAll((Object[])new Node[]{vbox});
        stage.setAlwaysOnTop(true);
        stage.setScene(scene);
        stage.setResizable(false);
        stage.show();
    }

    public static void ShowTaskDepend(String core) {
        XContainer xContainer = XContainer.getInstance(null);
        XScheduler xS = new XScheduler();
        if (xContainer != null && xContainer.validateExecutable()) {
            Iterator<String> it = xContainer.getScheduler().keySet().iterator();
            while (it.hasNext()) {
                xS = xContainer.getScheduler().get(it.next());
                System.out.println("ASSERT 0 " + xS.getName());
                if (xS.getCore().getName().compareTo(core) == 0) break;
                xS = null;
            }
        }
        if (xS == null) {
            System.out.println("ASSERT 1 error");
            return;
        }
        TabPane tabpane = new TabPane();
        int i = 0;
        while (i < xS.getTasks().size()) {
            System.out.println("ASSERT 2_" + i);
            String sel = xS.getTasks().get(i).getName();
            Tab tab = new Tab(sel);
            Label l1 = new Label("Access info");
            Label l2 = new Label("Producer info");
            Label l3 = new Label("Consumer info");
            l1.setFont(new Font("Arial", 16.0));
            l2.setFont(new Font("Arial", 16.0));
            l3.setFont(new Font("Arial", 16.0));
            l1.setPadding(new Insets(5.0));
            l1.setPadding(new Insets(5.0));
            tab.setClosable(false);
            SimpleLabelChain cur = new SimpleLabelChain(xS, false);
            Separator separator = new Separator();
            separator.setHalignment(HPos.LEFT);
            separator.setStyle("-fx-border-width: 2;-fx-padding: 4 ");
            Separator separator2 = new Separator();
            separator2.setHalignment(HPos.LEFT);
            separator2.setStyle("-fx-border-width: 2;-fx-padding: 4 ");
            SimpleLabelChain curCons = new SimpleLabelChain(xS, true);
            Separator separatorcons = new Separator();
            separator.setHalignment(HPos.LEFT);
            separator.setStyle("-fx-border-width: 2;-fx-padding: 4 ");
            Object ttmp = XUtil.hasDepended(xS.getTasks().get(i).getName(), xS) ? cur.getCanvas(sel) : new Label("No Producer Detected");
            Object ttmp2 = xS.getTasks().get(i).getConsumer().size() > 0 ? curCons.getCanvas(sel) : new Label("No Consumer Detected");
            Object labelAc = xContainer.isMergingArrow() ? ComUtil.generateLabbelAccess(sel, core) : new Label("Only available in Extended Simulation \nClick on the \ud83d\udec8 button on the TraceView for more information");
            VBox box = new VBox(new Node[]{l1, labelAc, separator, l2, ttmp, separatorcons, l3, ttmp2, separator2});
            tab.setContent((Node)box);
            tabpane.getTabs().add((Object)tab);
            ++i;
        }
        StackPane secondaryLayout = new StackPane();
        if (tabpane.getTabs().size() > 0) {
            secondaryLayout.getChildren().add((Object)tabpane);
        } else {
            secondaryLayout.getChildren().add((Object)new Label("No Dependency detected"));
        }
        Scene secondScene = new Scene((Parent)secondaryLayout);
        System.out.println("ASSERT 3_1");
        Stage newWindow = new Stage();
        newWindow.setTitle("Task View");
        newWindow.setX(100.0);
        newWindow.setY(100.0);
        newWindow.setScene(secondScene);
        newWindow.setMaximized(true);
        newWindow.show();
        System.out.println("ASSERT 3_2");
    }

    private static Node generateLabbelAccess(String sel, String core) {
        NumberAxis xAxis = new NumberAxis();
        CategoryAxis yAxis = new CategoryAxis();
        BarChart bc = new BarChart((Axis)xAxis, (Axis)yAxis);
        xAxis.setLabel("Access");
        xAxis.setTickLabelRotation(90.0);
        yAxis.setLabel(" ");
        XContainer container = XContainer.getInstance(null);
        XContainer.XResult result = container.getLabelAcces(sel, core);
        XYChart.Series series1 = new XYChart.Series();
        series1.setName("");
        XYChart.Data tmp1 = new XYChart.Data((Object)result.getWrite(), (Object)"Write");
        series1.getData().add((Object)tmp1);
        XYChart.Data tmp2 = new XYChart.Data((Object)result.getRead(), (Object)"Read");
        series1.getData().add((Object)tmp2);
        bc.getData().addAll((Object[])new XYChart.Series[]{series1});
        bc.setPadding(new Insets(0.0, 5.0, 0.0, 0.0));
        return new HBox(new Node[]{bc});
    }

    public static void showGlobalChains(XContainer con) {
        JTabbedPane tabbedPane = new JTabbedPane();
        LinkedList<LinkedList<XContainer.ChainElement>> global = con.getGlobalChain();
        Iterator it = global.iterator();
        new LinkedList();
        int count = 0;
        while (it.hasNext()) {
            LinkedList globalTmp = (LinkedList)it.next();
            JComponent tmp = ComUtil.GlobalmxChartt(globalTmp);
            tabbedPane.addTab("Chain #" + (count + 1), null, tmp, "Show chain #" + (count + 1));
            tabbedPane.setSize(800, 600);
            switch (count) {
                case 0: {
                    tabbedPane.setMnemonicAt(count, 49);
                    break;
                }
                case 1: {
                    tabbedPane.setMnemonicAt(count, 50);
                    break;
                }
                case 2: {
                    tabbedPane.setMnemonicAt(count, 51);
                    break;
                }
                case 3: {
                    tabbedPane.setMnemonicAt(count, 52);
                    break;
                }
                case 4: {
                    tabbedPane.setMnemonicAt(count, 53);
                    break;
                }
                case 5: {
                    tabbedPane.setMnemonicAt(count, 54);
                    break;
                }
                case 6: {
                    tabbedPane.setMnemonicAt(count, 55);
                    break;
                }
                case 7: {
                    tabbedPane.setMnemonicAt(count, 56);
                    break;
                }
                case 8: {
                    tabbedPane.setMnemonicAt(count, 57);
                }
            }
            ++count;
        }
        JFrame frame = new JFrame("Event Chain View");
        frame.setResizable(true);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(tabbedPane);
        frame.add(panel);
        frame.setExtendedState(frame.getExtendedState() | 6);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    static JComponent makeTextPanel(String text) {
        JPanel panel = new JPanel(false);
        JLabel filler = new JLabel(text);
        filler.setHorizontalAlignment(0);
        panel.setLayout(new GridLayout(1, 1));
        panel.add(filler);
        return panel;
    }

    static JComponent GlobalmxChartt(LinkedList<XContainer.ChainElement> globalTmp) {
        JPanel panel = new JPanel(false);
        panel.setLayout(new FlowLayout());
        mxGraph graph = new mxGraph();
        graph.setCellsEditable(false);
        new Object();
        LinkedList<Object> listLabel = new LinkedList<Object>();
        HashMap<String, Object> listRunnable = new HashMap<String, Object>();
        HashMap<String, Object> listTask = new HashMap<String, Object>();
        for (XContainer.ChainElement curr : globalTmp) {
            String task;
            String run;
            String fillTask = "#FA0031";
            String textTask = "white";
            String fillRun = "#00FFFF";
            String textRun = "black";
            String fillLabel = "white";
            String textLabel = "blue";
            listLabel.add(graph.insertVertex(null, null, (Object)curr.getLabel().getName(), 0.0, 0.0, 80.0, 30.0, "fillColor=" + fillLabel + ";fontColor=" + textLabel));
            if (listLabel.size() > 1) {
                graph.insertEdge(null, null, (Object)"", listLabel.get(listLabel.size() - 2), listLabel.get(listLabel.size() - 1), "strokeColor=orange");
            }
            for (XRunnable runn : curr.getRead()) {
                run = runn.getName();
                task = runn.getTask().getName();
                if (listRunnable.get(run) == null) {
                    listRunnable.put(run, graph.insertVertex(null, null, (Object)run, 0.0, 0.0, 80.0, 30.0, "fillColor=" + fillRun + ";fontColor=" + textRun));
                }
                if (listTask.get(task) == null) {
                    listTask.put(task, graph.insertVertex(null, null, (Object)task, 0.0, 0.0, 80.0, 30.0, "fillColor=" + fillTask + ";fontColor=" + textTask));
                }
                graph.insertEdge(null, null, (Object)"", listLabel.getLast(), listRunnable.get(run), "strokeColor=blue");
                graph.insertEdge(null, null, (Object)"", listRunnable.get(run), listTask.get(task), "strokeColor=blue");
            }
            for (XRunnable runn : curr.getWrite()) {
                run = runn.getName();
                task = runn.getTask().getName();
                if (listRunnable.get(run) == null) {
                    listRunnable.put(run, graph.insertVertex(null, null, (Object)run, 0.0, 0.0, 80.0, 30.0, "fillColor=" + fillRun + ";fontColor=" + textRun));
                }
                if (listTask.get(task) == null) {
                    listTask.put(task, graph.insertVertex(null, null, (Object)task, 0.0, 0.0, 80.0, 30.0, "fillColor=" + fillTask + ";fontColor=" + textTask));
                }
                graph.insertEdge(null, null, (Object)"", listRunnable.get(run), listLabel.getLast(), "strokeColor=red");
                graph.insertEdge(null, null, (Object)"", listTask.get(task), listRunnable.get(run), "strokeColor=red");
            }
        }
        mxGraphComponent graphComponent = new mxGraphComponent(graph);
        mxHierarchicalLayout layout = new mxHierarchicalLayout(graph);
        layout.execute(graph.getDefaultParent());
        graphComponent.setAutoscrolls(true);
        JScrollPane scrollFrame = new JScrollPane((Component)graphComponent);
        scrollFrame.setPreferredSize(new Dimension(900, 650));
        return scrollFrame;
    }

    private static void StartAllChain(LinkedList<XContainer.ChainElement> list) {
        JFrame frame = new JFrame("Event Chain View");
        frame.setResizable(true);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(ComUtil.GlobalmxChartt(list));
        frame.add(panel);
        frame.setSize(800, 600);
        frame.setLocationRelativeTo(null);
        frame.setExtendedState(frame.getExtendedState() | 6);
        frame.setVisible(true);
    }

    private static void prepareAllChain(LinkedList<String> name, LinkedList<Integer> val) {
        LinkedList<XContainer.ChainElement> out = new LinkedList<XContainer.ChainElement>();
        XContainer con = XContainer.getInstance(null);
        int i = 0;
        while (i < name.size()) {
            int j = 0;
            while (j < name.size()) {
                if (val.get(j) == i) {
                    out.add(new XContainer.ChainElement(con.getLabels().get(name.get(j))));
                    System.out.println(name.get(j));
                    break;
                }
                ++j;
            }
            ++i;
        }
        for (String ss : con.getRunnables().keySet()) {
            XRunnable ttmp = con.getRunnables().get(ss);
            for (XAccess acc : ttmp.getList()) {
                for (XContainer.ChainElement el : out) {
                    el.saveAdd(ttmp, acc);
                }
            }
        }
        if (out.size() > 0) {
            ComUtil.StartAllChain(out);
        } else {
            JOptionPane.showMessageDialog(null, "Error");
        }
    }

    public static void showAllChains(XContainer xContainer) {
        Stage newWindow = new Stage();
        Node depIcon = null;
        new LinkedList();
        CheckBoxTreeItem rootNode = new CheckBoxTreeItem((Object)"Model");
        LinkedList<ULabel> label = XUtil.getAllLabels(xContainer);
        rootNode.setExpanded(false);
        for (ULabel ulabel : label) {
            TreeItem taskLeaf2;
            CheckBoxTreeItem labelLeaf = new CheckBoxTreeItem((Object)ulabel.getName(), (Node)new Label("\ud83d\udcbe"));
            boolean found = false;
            for (TreeItem taskLeaf2 : rootNode.getChildren()) {
                TreeItem runLeaf2;
                if (!((String)taskLeaf2.getValue()).contentEquals(ulabel.getTask())) continue;
                found = true;
                boolean found2 = false;
                for (TreeItem runLeaf2 : taskLeaf2.getChildren()) {
                    if (!((String)runLeaf2.getValue()).contentEquals(ulabel.getRunnable())) continue;
                    found2 = true;
                    runLeaf2.getChildren().add((Object)labelLeaf);
                    break;
                }
                if (found2) break;
                runLeaf2 = new CheckBoxTreeItem((Object)ulabel.getRunnable(), depIcon);
                taskLeaf2.getChildren().add((Object)runLeaf2);
                runLeaf2.getChildren().add((Object)labelLeaf);
                break;
            }
            if (found) continue;
            taskLeaf2 = new CheckBoxTreeItem((Object)ulabel.getTask(), depIcon);
            CheckBoxTreeItem runLeaf = new CheckBoxTreeItem((Object)ulabel.getRunnable(), depIcon);
            rootNode.getChildren().add((Object)taskLeaf2);
            taskLeaf2.getChildren().add((Object)runLeaf);
            runLeaf.getChildren().add((Object)labelLeaf);
        }
        VBox box = new VBox();
        Scene scene = new Scene((Parent)box, 400.0, 300.0);
        scene.setFill((Paint)Color.LIGHTGRAY);
        TreeView treeView = new TreeView((TreeItem)rootNode);
        treeView.setCellFactory(CheckBoxTreeCell.forTreeView());
        Button button = new Button("Plot Event Chain");
        button.setPadding(new Insets(5.0));
        button.setOnMouseClicked(event -> {
            LinkedList<String> out = new LinkedList<String>();
            for (TreeItem task : rootNode.getChildren()) {
                for (TreeItem run : task.getChildren()) {
                    for (TreeItem item : run.getChildren()) {
                        if (!((CheckBoxTreeItem)item).isSelected() || out.indexOf(item.getValue()) != -1) continue;
                        out.add((String)item.getValue());
                    }
                }
            }
            for (String aa : out) {
                System.out.println(aa);
            }
            if (!out.isEmpty() && out.size() < 101) {
                ComUtil.selectOrder(out);
                newWindow.close();
            } else {
                JOptionPane.showMessageDialog(null, "Please select 1 - 100 Label\nCurrent selectet: " + out.size());
            }
        });
        box.getChildren().add((Object)new Label("Please select 1 - 100 items"));
        box.getChildren().add((Object)treeView);
        box.getChildren().add((Object)button);
        newWindow.setTitle("LabelSelect");
        newWindow.setScene(scene);
        newWindow.setX(100.0);
        newWindow.setY(100.0);
        newWindow.show();
    }

    private static void selectOrder(LinkedList<String> it) {
        Stage stage = new Stage();
        stage.setTitle("Define sequence");
        VBox box = new VBox();
        LinkedList<Integer> options = new LinkedList<Integer>();
        int i = 0;
        while (i < it.size()) {
            options.add(i);
            ++i;
        }
        LinkedList<String> name = it;
        LinkedList<ChoiceBox> boxes = new LinkedList<ChoiceBox>();
        LinkedList<Integer> val = new LinkedList<Integer>();
        int count = 0;
        for (String cur : it) {
            val.add(count);
            ChoiceBox sb = new ChoiceBox(FXCollections.observableList(options));
            sb.setValue((Object)count);
            int x = count++;
            sb.getSelectionModel().selectedIndexProperty().addListener((observable, oldValue, newValue) -> {
                val.set(x, newValue.intValue());
                for (Integer ii : val) {
                    System.out.println(ii);
                }
            });
            boxes.add(sb);
            HBox boxi = new HBox();
            Label ll = new Label(cur);
            Insets insets = new Insets(5.0);
            ll.setPadding(insets);
            sb.setPadding(insets);
            boxi.setPadding(insets);
            boxi.getChildren().add((Object)ll);
            boxi.getChildren().add((Object)sb);
            box.getChildren().add((Object)boxi);
        }
        Button bt = new Button("Confirm sequence");
        bt.setPrefWidth(345.0);
        bt.setOnMouseClicked(event -> {
            System.out.println(ComUtil.validate(val));
            if (ComUtil.validate(val)) {
                ComUtil.prepareAllChain(name, val);
                stage.close();
            } else {
                JOptionPane.showMessageDialog(null, "Error\n Each position may only be occupied once");
            }
        });
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContent((Node)box);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        stage.setScene(new Scene((Parent)new VBox(new Node[]{scrollPane, bt}), 350.0, 500.0));
        stage.setResizable(false);
        stage.show();
    }

    private static boolean validate(LinkedList<Integer> inp) {
        System.out.println("" + inp.size());
        int i = -1;
        while (i < inp.size()) {
            boolean tmp = false;
            for (Integer x : inp) {
                if (x == i && !tmp) {
                    tmp = true;
                    continue;
                }
                if ((x != i || !tmp) && x != -1) continue;
                return false;
            }
            ++i;
        }
        return !inp.isEmpty();
    }

    public static class CollumEntry {
        private final SimpleStringProperty e1;
        private final SimpleStringProperty e2;
        private final SimpleStringProperty e3;
        private final SimpleStringProperty e4;
        private final SimpleStringProperty e5;

        public CollumEntry(String e1, String e2, String e3, String e4) {
            this.e1 = new SimpleStringProperty(e1);
            this.e2 = new SimpleStringProperty(e2);
            this.e3 = new SimpleStringProperty(e3);
            this.e4 = new SimpleStringProperty(e4);
            this.e5 = new SimpleStringProperty("");
        }

        public CollumEntry(String e1, String e2, String e3, String e4, String e5) {
            this.e1 = new SimpleStringProperty(e1);
            this.e2 = new SimpleStringProperty(e2);
            this.e3 = new SimpleStringProperty(e3);
            this.e4 = new SimpleStringProperty(e4);
            this.e5 = new SimpleStringProperty(e5);
        }

        public String getE1() {
            return this.e1.get();
        }

        public SimpleStringProperty e1Property() {
            return this.e1;
        }

        public void setE1(String e1) {
            this.e1.set(e1);
        }

        public String getE2() {
            return this.e2.get();
        }

        public SimpleStringProperty e2Property() {
            return this.e2;
        }

        public void setE2(String e2) {
            this.e2.set(e2);
        }

        public String getE3() {
            return this.e3.get();
        }

        public SimpleStringProperty e3Property() {
            return this.e3;
        }

        public void setE3(String e3) {
            this.e3.set(e3);
        }

        public String getE4() {
            return this.e4.get();
        }

        public SimpleStringProperty e4Property() {
            return this.e4;
        }

        public void setE4(String e4) {
            this.e4.set(e4);
        }

        public String getE5() {
            return this.e5.get();
        }

        public SimpleStringProperty e5Property() {
            return this.e5;
        }

        public void setE5(String e5) {
            this.e5.set(e5);
        }
    }

    public static class ULabel {
        private final SimpleStringProperty name;
        private final SimpleStringProperty runnable;
        private final SimpleStringProperty task;

        public ULabel(String name, String runnable, String task) {
            this.name = new SimpleStringProperty(name);
            this.runnable = new SimpleStringProperty(runnable);
            this.task = new SimpleStringProperty(task);
        }

        public String getName() {
            return this.name.get();
        }

        public SimpleStringProperty nameProperty() {
            return this.name;
        }

        public void setName(String name) {
            this.name.set(name);
        }

        public String getRunnable() {
            return this.runnable.get();
        }

        public SimpleStringProperty runnableProperty() {
            return this.runnable;
        }

        public void setRunnable(String runnable) {
            this.runnable.set(runnable);
        }

        public String getTask() {
            return this.task.get();
        }

        public SimpleStringProperty taskProperty() {
            return this.task;
        }

        public void setTask(String task) {
            this.task.set(task);
        }
    }
}

