/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.widget.eventcanves;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.eclipse.app4mc.multicore.execution.ui.widget.eventcanves.EventCanvas;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.XUtil;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XAccess;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XScheduler;
import org.eclipse.app4mc.multicore.execution.ui.widget.model.elements.XTasks;

public class SimpleLabelChain
implements EventCanvas {
    private Canvas canvas;
    private int elements;
    private GraphicsContext gc;
    private XScheduler sc;
    LinkedList<XAccess> list;
    private double x = 30.0;
    private double y = 10.0;
    private double w = 90.0;
    private double h = 30.0;
    private int scale = 200;
    private int hiScale = 150;
    private boolean consumer;

    public SimpleLabelChain(XScheduler sc, boolean consumer) {
        this.sc = sc;
        this.consumer = consumer;
    }

    private void runWithArrow(String[] runableN, int row) {
        double offset = this.y + (double)(row * this.hiScale) + 5.0;
        String[] runableName = runableN;
        int i = 0;
        while (i < runableN.length) {
            this.gc.setFill((Paint)Color.GRAY);
            if (i != runableN.length - 1) {
                this.gc.setStroke((Paint)Color.BLACK);
                this.gc.setLineWidth(5.0);
                this.gc.strokeLine(this.x + this.w + (double)(i * this.scale), offset + 15.0, this.x + this.w + (double)(i * this.scale) + ((double)this.scale - this.w), offset + 15.0);
                this.gc.strokeLine(this.x + this.w + (double)(i * this.scale) + ((double)this.scale - this.w) * 0.33, offset + 8.0, this.x + this.w + (double)(i * this.scale), offset + 15.0);
                this.gc.strokeLine(this.x + this.w + (double)(i * this.scale) + ((double)this.scale - this.w) * 0.33, offset + 22.0, this.x + this.w + (double)(i * this.scale), offset + 15.0);
            }
            if (i == 0) {
                this.gc.setFill((Paint)Color.GREEN);
            }
            this.gc.fillRect(this.x + (double)(i * this.scale), offset, this.w, this.h);
            this.gc.setStroke((Paint)Color.BLACK);
            this.gc.setLineWidth(1.0);
            this.gc.strokeText(runableName[i], this.x + (double)(i * this.scale), offset + this.h + 15.0, (double)(this.scale - 5));
            ++i;
        }
    }

    private void runWithSync(String[] runableN, int row, LinkedList<String> varChange) {
        double offset = this.y + (double)(row * this.hiScale) + 5.0;
        String[] runableName = runableN;
        Iterator val = varChange.iterator();
        int i = 0;
        while (i < runableN.length) {
            this.gc.setFill((Paint)Color.GRAY);
            if (i != runableN.length) {
                this.gc.setStroke((Paint)Color.BLACK);
                this.gc.setLineWidth(3.0);
                if (i != runableN.length - 1) {
                    this.gc.strokeLine(this.x + this.w / 2.0 + (double)(i * this.scale), offset - 11.0, this.x + this.w + (double)(i * this.scale) + ((double)this.scale - this.w) + this.w / 2.0, offset - 11.0);
                }
                this.gc.strokeLine(this.x + this.w / 2.0 + (double)(i * this.scale), offset - 11.0, this.x + this.w / 2.0 + (double)(i * this.scale), offset);
            }
            if (i == 0) {
                if (this.consumer) {
                    this.gc.setFill((Paint)Color.BLUE);
                } else {
                    this.gc.setFill((Paint)Color.RED);
                }
            }
            this.gc.fillRect(this.x + (double)(i * this.scale), offset, this.w, this.h);
            this.gc.setStroke((Paint)Color.BLACK);
            this.gc.setLineWidth(1.0);
            this.gc.strokeText(runableName[i], this.x + (double)(i * this.scale), offset + this.h + 15.0, (double)(this.scale - 5));
            if (i != 0 && val.hasNext()) {
                this.gc.setStroke((Paint)Color.BLUE);
                String[] tmpArr = ((String)val.next()).split(",");
                int runOffset = 0;
                String[] stringArray = tmpArr;
                int n = tmpArr.length;
                int n2 = 0;
                while (n2 < n) {
                    String st = stringArray[n2];
                    if (runOffset > 3) {
                        this.gc.strokeText("(" + (tmpArr.length - (runOffset + 1)) + " more)", this.x + (double)(i * this.scale), offset + this.h + 30.0 + (double)(runOffset * 15));
                        break;
                    }
                    this.gc.strokeText(st, this.x + (double)(i * this.scale), offset + this.h + 30.0 + (double)(runOffset * 15), (double)this.scale);
                    ++runOffset;
                    ++n2;
                }
            }
            ++i;
        }
    }

    private void runSync(String[] runableN, int row, String sel, LinkedList<String> varChange) {
        if (runableN != null && runableN.length > 0 && sel != null && row >= 0) {
            String[] runableName = runableN;
            String[] arr = new String[runableName.length + 1];
            arr[0] = sel;
            int i = 1;
            while (i < arr.length) {
                arr[i] = runableName[i - 1];
                ++i;
            }
            this.runWithSync(arr, row, varChange);
        }
    }

    private void prepare(String sel) {
        this.elements = this.sc.getTasks().size();
        Iterator<XTasks> it = this.sc.getTasks().iterator();
        int rows = 0;
        int maxElements = 0;
        LinkedList<String[]> list = new LinkedList<String[]>();
        LinkedList varList = new LinkedList();
        LinkedList<String> nameList = new LinkedList<String>();
        while (it.hasNext()) {
            XTasks xs = it.next();
            HashMap<String, XTasks> xmp = this.consumer ? xs.getConsumer() : xs.getProducer();
            if (xmp.size() <= 0) continue;
            list.add(new String[xmp.size()]);
            varList.add(new LinkedList());
            nameList.add(xs.getName());
            if (xmp.size() > maxElements) {
                maxElements = xmp.size();
            }
            Iterator<String> iterator = xmp.keySet().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                XTasks xxs = xmp.get(iterator.next());
                if (this.consumer) {
                    ((LinkedList)varList.getLast()).add("");
                } else {
                    ((LinkedList)varList.getLast()).add(XUtil.compareTasks(xs, xxs));
                }
                ((String[])list.get((int)rows))[i] = xxs.getName();
                System.out.println(String.valueOf(xs.getName()) + " - > " + ((String[])list.get(rows))[i] + " " + " " + (i + 1) + " /" + xmp.size() + " ==> " + (String)((LinkedList)varList.getLast()).getLast());
                ++i;
            }
            ++rows;
        }
        this.canvas = sel != null ? new Canvas((double)(maxElements * this.scale), (double)this.hiScale) : new Canvas((double)(++maxElements * this.scale), (double)(this.hiScale * rows));
        this.gc = this.canvas.getGraphicsContext2D();
        Iterator itRun = list.iterator();
        System.out.println("list: " + list.size() + " rows: " + rows + "  varlist: " + varList.size());
        int i = 0;
        while (itRun.hasNext() && list.size() == varList.size()) {
            if (sel != null && ((String)nameList.get(i)).compareTo(sel) == 0) {
                this.runSync((String[])itRun.next(), 0, (String)nameList.get(i), (LinkedList)varList.get(i));
                System.out.println("found :_> " + sel);
                break;
            }
            if (sel != null && ((String)nameList.get(i)).compareTo(sel) != 0) {
                System.out.println("Skip");
                itRun.next();
            } else {
                System.out.println("ohne");
                this.runSync((String[])itRun.next(), i, (String)nameList.get(i), (LinkedList)varList.get(i));
            }
            ++i;
        }
    }

    @Override
    public Canvas getCanvas() {
        this.prepare(null);
        return this.canvas;
    }

    public Canvas getCanvas(String task) {
        this.prepare(task);
        return this.canvas;
    }
}

