/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.widget.gantt;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.StringConverter;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.IGantt;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.IntegerStringConverter;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.AbstractGanttViewElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.ProgressViewElement;

public class FXGanttWidget
extends XYChart<Number, String>
implements IGantt {
    private double blockPadding = 10.0;
    private double blockHeight = 15.0;
    private final boolean deugPrint = true;
    private NumberAxis xAxi;
    private CategoryAxis catAxi;
    private Map<String, XYChart.Series<Number, String>> series = new HashMap<String, XYChart.Series<Number, String>>();
    private double deltX = 0.0;
    private double xBefore = 0.0;

    public FXGanttWidget(int vieport) {
        this(new NumberAxis(), new CategoryAxis());
        this.xAxi.setMinorTickCount(1);
        this.xAxi.setTickUnit(1.0);
        this.xAxi.setTickLabelFormatter((StringConverter)new IntegerStringConverter());
        this.xAxi.setLabel("");
        this.xAxi.setTickLabelFill((Paint)Color.CHOCOLATE);
        this.xAxi.setAutoRanging(false);
        this.xAxi.setLowerBound(0.0);
        this.xAxi.setUpperBound((double)vieport);
        this.catAxi.setAutoRanging(false);
        this.getYAxis().setLabel("");
        this.getYAxis().setTickLabelFill((Paint)Color.CHOCOLATE);
        this.getYAxis().setTickLabelGap(5.0);
        this.setLegendVisible(false);
        this.prefHeightProperty().bind((ObservableValue)this.minHeightProperty());
        this.setupDragging();
        this.setupScrolling();
        System.out.println("FXGanttWidget Consturctur Start");
    }

    private FXGanttWidget(NumberAxis xAxis, CategoryAxis yAxis) {
        super((Axis)xAxis, (Axis)yAxis);
        this.setData(FXCollections.observableArrayList());
        this.xAxi = xAxis;
        this.catAxi = yAxis;
    }

    private void setupDragging() {
        this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (FXGanttWidget.this.xBefore == 0.0) {
                    FXGanttWidget.this.xBefore = event.getX();
                }
                FXGanttWidget fXGanttWidget = FXGanttWidget.this;
                fXGanttWidget.deltX = fXGanttWidget.deltX + (event.getX() - FXGanttWidget.this.xBefore);
                double pxPerUnit = FXGanttWidget.this.getNumberAxis().getScale();
                if (FXGanttWidget.this.deltX >= pxPerUnit) {
                    FXGanttWidget.this.moveViewPort(-1);
                    FXGanttWidget.this.deltX = 0.0;
                } else if (FXGanttWidget.this.deltX <= -pxPerUnit) {
                    FXGanttWidget.this.moveViewPort(1);
                    FXGanttWidget.this.deltX = 0.0;
                }
                FXGanttWidget.this.xBefore = event.getX();
            }
        });
        this.setOnMouseDragReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                FXGanttWidget.this.deltX = 0.0;
                FXGanttWidget.this.xBefore = 0.0;
            }
        });
    }

    private void setupScrolling() {
        this.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(){
            static final double moveSpeed = 0.1;
            static final int zoomSpeed = 75;

            public void handle(ScrollEvent event) {
                if (event.isControlDown()) {
                    if (event.getDeltaY() < 0.0) {
                        FXGanttWidget.this.zoomViewPort(75);
                    } else {
                        FXGanttWidget.this.zoomViewPort(-75);
                    }
                } else if (event.getDeltaY() < 0.0) {
                    FXGanttWidget.this.moveViewPort(-((int)(0.1 * FXGanttWidget.this.getViewSize())));
                } else {
                    FXGanttWidget.this.moveViewPort((int)(0.1 * FXGanttWidget.this.getViewSize()));
                }
                event.consume();
            }
        });
    }

    @Override
    public void addCategorie(String categorie) {
        if (this.getMinHeight() == -1.0) {
            this.setMinHeight(100.0);
        }
        double delta = this.getBlockHeight() + this.getBlockPadding() / 2.0;
        this.setMinHeight(this.getMinHeight() + delta);
        this.catAxi.getCategories().add(0, (Object)categorie);
        XYChart.Series s = new XYChart.Series();
        this.series.put(categorie, (XYChart.Series<Number, String>)s);
        this.getData().add((Object)s);
    }

    @Override
    public void addEvent(String categorie, long start, AbstractGanttViewElement v) {
        XYChart.Data d = new XYChart.Data((Object)start, (Object)categorie, (Object)v);
        this.series.get(categorie).getData().add((Object)d);
    }

    @Override
    public void moveViewPort(int move) {
        double ub = this.xAxi.getUpperBound() + (double)move;
        double lb = this.xAxi.getLowerBound() + (double)move;
        if (lb >= 0.0) {
            this.xAxi.setUpperBound(ub);
            this.xAxi.setLowerBound(lb);
        }
    }

    @Override
    public void setViewPort(double lower, double upper) {
        double d = lower = lower < 0.0 ? 0.0 : lower;
        if (upper > 0.0 && lower < upper) {
            this.xAxi.setLowerBound(lower);
            this.xAxi.setUpperBound(upper);
        }
    }

    public void zoomViewPort(int zoom) {
        double ub = this.xAxi.getUpperBound() + (double)zoom;
        double lb = this.xAxi.getLowerBound() - (double)zoom;
        this.setViewPort(lb, ub);
    }

    public double getViewSize() {
        return this.xAxi.getUpperBound() - this.xAxi.getLowerBound();
    }

    protected void layoutPlotChildren() {
        int seriesIndex = 0;
        while (seriesIndex < this.getData().size()) {
            XYChart.Series series = (XYChart.Series)this.getData().get(seriesIndex);
            Iterator it = this.getDisplayedDataIterator(series);
            while (it.hasNext()) {
                Node node;
                XYChart.Data item = (XYChart.Data)it.next();
                double x = this.getXAxis().getDisplayPosition((Object)((Number)item.getXValue()));
                double y = this.getYAxis().getDisplayPosition((Object)((String)item.getYValue()));
                if (Double.isNaN(x) || Double.isNaN(y) || (node = item.getNode()) == null || !(node instanceof AbstractGanttViewElement)) continue;
                AbstractGanttViewElement ev = (AbstractGanttViewElement)node;
                ev.update(this, x, y -= this.getBlockHeight() / 2.0);
            }
            ++seriesIndex;
        }
    }

    protected void dataItemAdded(XYChart.Series<Number, String> series, int itemIndex, XYChart.Data<Number, String> item) {
        boolean cfr_ignored_0 = item.getExtraValue() instanceof ProgressViewElement;
        Node block = FXGanttWidget.createNode(item);
        this.getPlotChildren().add((Object)block);
    }

    protected void dataItemRemoved(XYChart.Data<Number, String> item, XYChart.Series<Number, String> series) {
        Node block = item.getNode();
        this.getPlotChildren().remove((Object)block);
        this.removeDataItemFromDisplay(series, item);
    }

    protected void dataItemChanged(XYChart.Data<Number, String> item) {
    }

    protected void seriesAdded(XYChart.Series<Number, String> series, int seriesIndex) {
        int j = 0;
        while (j < series.getData().size()) {
            XYChart.Data item = (XYChart.Data)series.getData().get(j);
            Node container = FXGanttWidget.createNode((XYChart.Data<Number, String>)item);
            this.getPlotChildren().add((Object)container);
            ++j;
        }
    }

    protected void seriesRemoved(XYChart.Series<Number, String> series) {
        for (XYChart.Data d : series.getData()) {
            Node container = d.getNode();
            this.getPlotChildren().remove((Object)container);
        }
        this.removeSeriesFromDisplay(series);
    }

    private static Node createNode(XYChart.Data<Number, String> item) {
        Object container = item.getNode();
        if (container == null) {
            container = item.getExtraValue() instanceof AbstractGanttViewElement ? (AbstractGanttViewElement)((Object)item.getExtraValue()) : new StackPane();
            item.setNode(container);
        }
        return container;
    }

    public double getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(double blockHeight) {
        this.blockHeight = blockHeight;
    }

    public double getBlockPadding() {
        return this.blockPadding;
    }

    public void setBlockPadding(double blockPadding) {
        this.blockPadding = blockPadding;
    }

    public NumberAxis getNumberAxis() {
        return this.xAxi;
    }

    public CategoryAxis getCatAxi() {
        return this.catAxi;
    }
}

