/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements;

import javafx.beans.value.ObservableValue;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;

public class Arrow
extends Path {
    private static final double defaultArrowHeadSize = 5.0;

    public Arrow(double startX, double startY, double endX, double endY, Color c, double arrowHeadSize) {
        this.strokeProperty().bind((ObservableValue)this.fillProperty());
        this.setFill((Paint)c);
        this.getElements().add((Object)new MoveTo(endX, endY));
        double angle = Math.atan2(endY - startY, endX - startX) - 1.5707963267948966;
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        double x1 = (-0.5 * cos + Math.sqrt(3.0) / 2.0 * sin) * arrowHeadSize + endX;
        double y1 = (-0.5 * sin - Math.sqrt(3.0) / 2.0 * cos) * arrowHeadSize + endY;
        double x2 = (0.5 * cos + Math.sqrt(3.0) / 2.0 * sin) * arrowHeadSize + endX;
        double y2 = (0.5 * sin - Math.sqrt(3.0) / 2.0 * cos) * arrowHeadSize + endY;
        this.getElements().add((Object)new LineTo(x1, y1));
        this.getElements().add((Object)new LineTo(x2, y2));
        this.getElements().add((Object)new LineTo(endX, endY));
        this.setStrokeWidth(2.0);
    }

    public Arrow(double startX, double startY, double endX, double endY) {
        this(startX, startY, endX, endY, Color.BLACK, 5.0);
    }
}

