/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements;

import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.FXGanttWidget;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.AbstractGanttViewElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.TimeMarkModelElement;

public class ArrowTimeMarkerViewElement
extends AbstractGanttViewElement {
    private final TimeMarkModelElement model;
    private static final int ARROW_HEAD_LEG_OFF = 3;
    private static final int HEIGT_ADDITION = 3;
    private Path arrow;
    private double height;
    private long isUpate;

    public ArrowTimeMarkerViewElement(String style, TimeMarkModelElement model) {
        super(style);
        this.model = model;
        this.isUpate = 0L;
    }

    @Override
    protected void updateElement(FXGanttWidget chart) {
        double compheight = chart.getBlockHeight() + 3.0;
        if (this.height != compheight && this.arrow != null) {
            this.getChildren().remove((Object)this.arrow);
            this.arrow = null;
        }
        if (this.arrow == null) {
            this.height = compheight;
            this.arrow = this.createPath(this.height);
            Tooltip t = new Tooltip(String.valueOf(this.model.getTime()) + " " + this.model.getLabel());
            Tooltip.install((Node)this.arrow, (Tooltip)t);
            this.getChildren().add((Object)this.arrow);
        }
    }

    protected Path createPath(double height) {
        Path path = new Path();
        MoveTo moveTo = new MoveTo();
        moveTo.setX(0.0);
        moveTo.setY(0.0);
        LineTo verticalLine = new LineTo();
        verticalLine.setX(0.0);
        verticalLine.setY(height);
        LineTo arwHead1 = new LineTo();
        arwHead1.setX(3.0);
        arwHead1.setY(height - 3.0);
        MoveTo backToPeak = new MoveTo();
        backToPeak.setX(0.0);
        backToPeak.setY(height);
        LineTo arwHead2 = new LineTo();
        arwHead2.setX(-3.0);
        arwHead2.setY(height - 3.0);
        path.getElements().add((Object)moveTo);
        path.getElements().add((Object)verticalLine);
        path.getElements().add((Object)arwHead1);
        path.getElements().add((Object)backToPeak);
        path.getElements().add((Object)arwHead2);
        path.setStrokeWidth(2.0);
        return path;
    }
}

