/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements;

import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.FXGanttWidget;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.ArrowElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.DurationModelElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.tracewidget.TraceWidget;

public class DataFlowArrowViewElementAlternative
extends ArrowElement {
    private static final int HEIGT_ADDITION = 3;
    private Line line;
    private Line p1;
    private Line p2;
    private Line p3;
    private double height;
    private long index1;
    private long index2;
    private long cals;
    private long isUpate;

    public DataFlowArrowViewElementAlternative(String style, long index1, long index2, long cals, TraceWidget.ArrowTooltip model) {
        super(style, new DurationModelElement(index1, 1.0, String.valueOf(model.getTask2()) + " to " + model.getTask1() + " \n" + model.getLabel()), model);
        Color main = Color.RED;
        this.isUpate = 0L;
        this.index1 = index1;
        this.index2 = index2;
        this.cals = cals;
        this.line = new Line();
        this.line.setStrokeWidth(2.0);
        this.line.setStroke((Paint)main);
        this.p1 = new Line();
        this.p1.setStrokeWidth(2.0);
        this.p1.setStroke((Paint)main);
        this.p2 = new Line();
        this.p2.setStrokeWidth(2.0);
        this.p2.setStroke((Paint)main);
        this.getChildren().addAll((Object[])new Node[]{this.line});
        this.getChildren().addAll((Object[])new Node[]{this.p1});
        this.getChildren().addAll((Object[])new Node[]{this.p2});
    }

    @Override
    protected void updateElement(FXGanttWidget chart) {
        super.updateElement(chart);
        double compheight = chart.getBlockHeight() + 3.0;
        this.setHeight(this.getHeight());
        this.height = compheight;
        double offset = (double)(this.index2 - this.index1) * (this.height + (double)Math.abs(this.index2 - this.index1));
        if (offset >= 0.0) {
            offset += this.height / 2.0;
        }
        double crycyOffset = (double)(-this.cals) * chart.getNumberAxis().getScale() * 1.0;
        this.line.setStartX(crycyOffset);
        this.line.setStartY(offset);
        this.line.setEndX(0.0);
        this.line.setEndY(this.height / 2.0);
        double angle = Math.atan2(this.height / 2.0 - offset, 0.0 - crycyOffset) - 1.5707963267948966;
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        double x1 = (-0.5 * cos + Math.sqrt(3.0) / 2.0 * sin) * 8.0 + 0.0;
        double y1 = (-0.5 * sin - Math.sqrt(3.0) / 2.0 * cos) * 8.0 + this.height / 2.0;
        double x2 = (0.5 * cos + Math.sqrt(3.0) / 2.0 * sin) * 8.0 + 0.0;
        double y2 = (0.5 * sin - Math.sqrt(3.0) / 2.0 * cos) * 8.0 + this.height / 2.0;
        this.p1.setStartX(x1);
        this.p1.setStartY(y1);
        this.p1.setEndX(0.0);
        this.p1.setEndY(this.height / 2.0);
        this.p2.setStartX(x2);
        this.p2.setStartY(y2);
        this.p2.setEndX(0.0);
        this.p2.setEndY(this.height / 2.0);
    }
}

